#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Factory Town
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250129.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='factory-town'
GAME_NAME='Factory Town'

ARCHIVE_BASE_1_NAME='setup_factory_town_2.2.7_(64bit)_(77941).exe'
ARCHIVE_BASE_1_MD5='79cfa439d7468916310f9293dbfc6c6c'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='598856'
ARCHIVE_BASE_1_VERSION='2.2.7-gog77941'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/factory_town'

ARCHIVE_BASE_0_NAME='setup_factory_town_1.13.3_(64bit)_(53563).exe'
ARCHIVE_BASE_0_MD5='4b9199687bd79a1d8f7641bf4577a2dd'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='630000'
ARCHIVE_BASE_0_VERSION='1.13.3-gog53563'

UNITY3D_NAME='factory town'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/82 Apps/Factory Town'
## Work around missing text
WINE_WINETRICKS_VERBS='arial'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
