#!/bin/sh

FILE=latex-five-pages-example

cp debian/tests/data/$FILE.tex $AUTOPKGTEST_TMP
cd $AUTOPKGTEST_TMP
latex $FILE.tex > /dev/null

output=$(catdvi -p 2 -l 4 $FILE.dvi)

if echo $output | grep "page 1"; then
    exit 1
fi

if echo $output | grep "page 5"; then
    exit 1
fi

for p in `seq 2 4`; do
    if ! echo $output | grep "page $p"; then
        exit 1
    fi
done
