.TH aconnect 1 "August 31, 2000"
.\" Test odd macroexpansion case where numeric zero gets put in expansion
.de EX
.nf
.ft CW
..
.de EE
.ft R
.fi
..
.SH NAME
aconnect \- ALSA sequencer connection manager

.SH SYNOPSIS
.B aconnect
[\-d] [\-options] sender receiver
.br
.B aconnect
\-i|\-o [\-options]
.br
.B aconnect
\-x

.SH DESCRIPTION
.B aconnect
is a utility to connect and disconnect two existing ports on ALSA sequencer
system.
The ports with the arbitrary subscription permission, such as created
by
.B aseqview(1),
can be connected to any (MIDI) device ports using
.B aconnect.
For example, to connect from port 64:0 to 65:0, run as follows:
.IP "" 4
% aconnect 64:0 65:0
.PP
The connection is one-way, and the whole data to the sender port (64:0)
is redirected to the receiver port (65:0).  When another port (e.g. 65:1)
is attached to the same sender port, the data is sent to both receiver
ports.
For disconnection, use
.B \-d
option.
.sp
.EX
% aconnect \-d 64:0 65:0
.EE
.PP
The address can be given using the client's name.
.sp
.EX
% aconnect External:0 Emu8000:1
.EE
.PP
Then the port 0 of the client matching with the string "External" is
connected to the port 1 of the client matching with the "Emu8000".
.PP
Another function of
.B aconnect
is to list the present ports
on the given condition.
The input ports, which may become
.I sender
ports, can be listed with
.B \-i
option.
.sp
.EX
% aconnect \-i
client 0: 'System' [type=kernel]
    0 'Timer           '
    1 'Announce        '
client 64: 'External MIDI\-0' [type=kernel]
    0 'MIDI 0\-0        '
.EE
.PP
Similarly, to see the output ports, use
.B \-o
flag.
.PP
You can remove all existing exported connections using
.B \-x
option.  This function is useful for terminating the ALSA drivers,
because the modules with sequencer connections cannot be unloaded
unless their connections are removed.

.SH OPTIONS
.SS CONNECTION MANAGEMENT
.TP
.B \-d, \-\-disconnect
Disconnect the given subscription.
.TP
.B \-e, \-\-exclusive
Connect ports with exclusive mode.
Both sender and receiver ports can be no longer connected by any other ports.
.TP
.B \-r, \-\-real queue
Convert time-stamps of event packets to the current value of the given
.I real-time
queue.
This is option is, however, not so useful, since
the receiver port must use (not necessarily own) the specified queue.
.TP
.B \-t, \-\-tick queue
Like
.B \-r
option, but 
time-stamps are converted to the current value of the given
.I tick
queue.

.SS LIST PORTS
.TP
.B \-i, \-\-input
List existing input (readable) ports.
This option is exclusive to
.B \-o.
.TP
.B \-o, \-\-output
List existing output (writable) ports.
This option is exclusive to
.B \-i.
.TP
.B \-l, \-\-list
List the current connection status.  The connected and connecting ports
from/to each port are listed together.
The suffix flag
.B [ex]
means the connection is exclusive.
The suffix flag
.B [real:#]
and
.B [tick:#]
mean the connection includes real-time and tick conversion on the listed
queue, respectively.

.SS REMOVE ALL CONNECTIONS
.TP
.B \-x, \-\-removeall
Remove all exported connections.

.SH "SEE ALSO"
aseqnet(1), aseqview(1)

.SH AUTHOR
Takashi Iwai <tiwai@suse.de>
