# Contributing

One of the great things about open source projects is that anyone can contribute in any number of meaningful ways. ESLint couldn't exist without the help of the many contributors it's had since the project began, and we want you to feel like you can contribute and make a difference as well.

This guide is intended for anyone who wants to contribute to an ESLint project. Please read it carefully as it answers a lot of the questions many newcomers have when first working with our projects.

## Read the [Code of Conduct](https://js.foundation/community/code-of-conduct)

ESLint welcomes contributions from everyone and adheres to the [JS Foundation Code of Conduct](https://js.foundation/community/code-of-conduct). We kindly request that you read over our code of conduct before contributing.

## [Signing the CLA](https://js.foundation/CLA)

In order to submit code or documentation to an ESLint project, you will need to electronically sign our [Contributor License Agreement](https://cla.js.foundation/eslint/eslint). The CLA is you giving us permission to use your contribution.

## [Bug Reporting](reporting-bugs)

Think you found a problem? We'd love to hear about it. This section explains how to submit a bug, the type of information we need to properly verify it, and the overall process.

## Proposing a [New Rule](new-rules.md)

We get a lot of proposals for new rules in ESLint. This section explains how we determine which rules are accepted and what information you should provide to help us evaluate your proposal.

## Proposing a [Rule Change](rule-changes.md)

Want to make a change to an existing rule? This section explains the process and how we evaluate such proposals.

## Requesting a [Change](changes.md)

If you'd like to request a change other than a bug fix or new rule, this section explains that process.

## Reporting a security vulnerability

To report a security vulnerability in ESLint, please use our [HackerOne program](https://hackerone.com/eslint).

## [Working on Issues](working-on-issues.md)

Have some extra time and want to contribute? This section talks about the process of working on issues.

## Submitting a [Pull Request](pull-requests.md)

We're always looking for contributions from the community. This section explains the requirements for pull requests and the process of contributing code.
