package CParse::Op::Alignof;

use 5.6.0;
use strict;
use warnings;

use CParse::Op;

use CExpr::Alignof;

our @ISA = qw/CParse::Op/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $arg = shift;

    my $self = {arg => $arg,
               };
    bless $self, $class;
    return $self;
  }

sub args
  {
    my $self = shift;
    return ($self->{arg});
  }

sub dump_c
  {
    my $self = shift;
    my $arg = $self->{arg}->dump_c;

    return "__alignof__($arg)";
  }

sub get_expr
  {
    my $self = shift;
    my $namespace = shift;

    my $type = $self->{arg}->get_type($namespace);

    return new CExpr::Alignof $type;
  }

1;
