/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef hmac_sha3_256_vectors_h__
#define hmac_sha3_256_vectors_h__

#include "testvectors_base/test-structs.h"

const HmacTestVector kHmacSha3256WycheproofVectors[] = {
    {1, "empty message",
     "1e225cafb90339bba1b24076d4206c3e79c355805d851682bc818baa4f5a7779", "",
     "a3c58470afa8835d6e2357fb7b1cd07f8c4bc4c7874ca59d83163f046a9e227e", false},

    {2, "short message",
     "8159fd15133cd964c9a6964c94f0ea269a806fd9f43f0da58b6cd1b33d189b2a", "77",
     "f709a35d41e82e36955512bf5fc1af0c1a9c580ff8fc3199bcb7454027029282", false},

    {3, "short message",
     "85a7cbaae825bb82c9b6f6c5c2af5ac03d1f6daa63d2a93c189948ec41b9ded9", "a59b",
     "bd323e494c3d22bde1d11dbde458f81bbe590007b42c4cee1cc45030d2b733cf", false},

    {4, "short message",
     "48f3029334e55cfbd574ccc765fb2c3685aab1f4837d23370874a3e634c3a76d",
     "c7b8b2",
     "7ad928d2f7e905aaca9bd63d34e4b84c58ed37f439b9b85b33f1f47c8baa26da", false},

    {5, "short message",
     "de8b5b5b2f09645be47ecb6407a4e1d9c6b33ae3c2d22517d3357da0357a3139",
     "cc021d65",
     "8a5db60345aa7cc4afb39e645ede87b16e73d37df045623ec58e9e901f96e224", false},

    {6, "short message",
     "b7938910f518f13205ca1492c669001a14ff913c8ab4a0dc3564e7418e91297c",
     "a4a6ef6ebd",
     "dfd1ddfec9c5133d1a2be33c4a978d3bee78740895a5b1e15c54542842e4c8de", false},

    {7, "short message",
     "1bb997ff4de8a5a391de5c08a33bc2c7c2891e47ad5b9c63110192f78b98fe78",
     "667e015df7fc",
     "ca5e8f039efc1137cefd128c40e275e727811bc2f785f7222343c2866f80b44d", false},

    {8, "short message",
     "32fdeda39f98b4f4426c2d2ac00ab5dd4bfabb68f311447256ed6d3d3a51b154",
     "4163a9f77e41f5",
     "06d38848b90d0a797567cb6fa68e3b2d970b2c52ea9114786eb54aa22d403e70", false},

    {9, "short message",
     "233e4fdee70bcc20235b6977ddfc05b0df66f5635d827c66e5a63cdb16a24938",
     "fdb2ee4b6d1a0ac2",
     "799b30418ec2619936b0260bb50264ef4c8233997418604d04f8e8d318d4ff3c", false},

    {10, "short message",
     "b984c6734e0bd12b1737b2fc7a1b3803b4dfec402140a57b9eccc35414ae661b",
     "dea584d0e2a14ad5fd",
     "684383e2460fd270044532e95b5e83fec520ffa99dd2a898aa8c88a5d76da02d", false},

    {11, "short message",
     "d0caf1456ac5e255fa6afd61a79dc8c716f5358a298a508271363fe1ff983561",
     "18261dc806913c534666",
     "665b8f703c719a6a4bfce97567050aba77aaeea66e70fd3ec37d52b9b80ec937", false},

    {12, "short message",
     "835bc8241ed817735ec9d3d0e2df4c173ee4dded4a8ef0c04a96c48f11820463",
     "26f8083e944bacf04e9a4d",
     "5208852f40c5fe6e97ba733a9fd0aa39e039e1b2d2501da361ae0e92fcbd6e7d", false},

    {13, "short message",
     "055f95c9461b0809575eccdfa5cdd06275f25d30915c4eb8db40e1acd3ab7591",
     "bfb7d6a08dbaa5225f320887",
     "678908a602c9c215049a92221f22981039c2cfd1c699bc360f7da5e6d0967b5a", false},

    {14, "short message",
     "e40f7a3eb88ddec4c6347ea4d67610756c82c8ebcc237629bf873ccabc32984a",
     "7fe43febc78474649e45bf99b2",
     "80bdbf6abc65ee4223fff5e91d61a4a3e3973286dfb4e62b51bff7d2e4a4e43c", false},

    {15, "short message",
     "b020ad1de1c141f7ec615ee5701521773f9b232e4d06376c382894ce51a61f48",
     "81c7581a194b5e71b41146a582c1",
     "4a57e7b7d438b93c8b7951ef789b93a13b20d6463fdbd4fa0026354b9959a273", false},

    {16, "short message",
     "9f3fd61a105202648ecff6074c95e502c1c51acd32ec538a5cce89ef841f7989",
     "2a76f2acdace42e3b779724946912c",
     "f95b627660ece175304f36a701e647f26f0794b6d5e226f2e272ef9e9bf69744", false},

    {17, "", "6fa353868c82e5deeedac7f09471a61bf749ab5498239e947e012eee3c82d7c4",
     "aeed3e4d4cb9bbb60d482e98c126c0f5",
     "4c5198e69a42db2d77aae9975c96429970a4bc64dd906d8cb16883a216a3f304", false},

    {18, "", "5300489494ca86221c91d6d953952ae1a5e097139dc9cf1179c2f56433753824",
     "90fea6cf2bd811b449f333ee9233e57697",
     "a8ade6e91e97abb4cf6e92d4bcf1fb3b8f1be3b9da4add09b0e4544b978fbe14", false},

    {19, "", "383e7c5c13476a62268423ef0500479f9e86e236c5a081c6449189e6afdf2af5",
     "3202705af89f9555c540b0e1276911d01971abb2c35c78b2",
     "e9b4fe8196723db56d59221197f11a713f21a17fd217788726c4d98a4f5730a0", false},

    {20, "", "186e248ad824e1eb93329a7fdcd565b6cb4eaf3f85b90b910777128d8c538d27",
     "92ef9ff52f46eccc7e38b9ee19fd2de3b37726c8e6ce9e1b96db5dda4c317902",
     "d565faa179be14d8c6679e00235fda9db5b4bc13c00b876be62cf61c30dd8392", false},

    {21, "long message",
     "28855c7efc8532d92567300933cc1ca2d0586f55dcc9f054fcca2f05254fbf7f",
     "9c09207ff0e6e582cb3747dca954c94d45c05e93f1e6f21179cf0e25b4cede74b5479d32f"
     "5166935c86f0441905865",
     "2876012e6bdfc89899b8d080f5e3ac584c4150e5e0bbbea3a98baa68d74c7893", false},

    {22, "long message",
     "8e540cb30c94836ae2a5950f355d482a7002e255207e94fda3f7ef1a099013a0",
     "d6500f95e11262e308bf3df4df4b855f33e857563d4543f195639a0a17b442eb9fdcc1367"
     "d2eee75c8f805730b89290f",
     "394ad185fc8d8b1351c4a3aa96e7f6ccd8e817d86f244a427791f865f5aa1d3c", false},

    {23, "long message",
     "69c50d5274358188cff4c0fae742243d4e8a5e5ba55d94ff40edd90f6a43dd10",
     "1ac5255aff052828d8ea21b376f1ebdd4bb879949913900405aebce83e48feb6813b5e9c8"
     "9f94501a8ade41b26b815c521",
     "928d84f9ce34b5b5e6c1d7486a369f2d94186629aad94d644c16728863eb619a", false},

    {24, "long message",
     "23209b7c5aadcbd13f7279af1a86d3c7ae8f179d1bcaaad0dff9a15302e78dbf",
     "84bdac37e1af35d9356404e2787d47ece58348dea76a4a46e8aade3463d4db8c94a051be3"
     "733b38d756984865d56c60e8025f15e3f968f093e7fb7ebc7e31189c5692d15ed4256737b"
     "9b1894e5809503aaa1c9983fb096aa21916361eeb6ef455b129723a1a1ddf9deddea20852"
     "9a648",
     "0e408a884cedac6f019dfc13364dcaf490f3f542b3d4795e10bf9c55641e3b2e", false},

    {25, "long message",
     "7c9cc667cae175f448faa96647319633b2d48531373ae7d316c44ddd8b9f69cf",
     "9233c1d73b498c5106ff88951e07b9652cb0ddae740737ec205c9876d094978bfc947f7dc"
     "937119fd6a93915b19b625958a7a22363aa2ac33fb869ed16b303336ab740a0498a2df66a"
     "6599da710094481a7b544bd955b6f97135ba4673401db2db144a6e287041e47a51ed9b6ba"
     "956c13508c1c0c25310105239ab73629e30",
     "8577a591c1cf204334bc3f45008dc373d2c366c8959a144db9681b364a591d54", false},

    {26, "long message",
     "82314540564ea3ce30591e97f68b2602de40fa29f773c2508327471b8348e8c4",
     "6a6d2f45cebf2757ae16ea33c68617671d77f8fdf80bed8fc5cdc5c8b7086bd28e7eb3eec"
     "c7163491104e5309455e67f836579b82a1da3bf5991a8e2b2f189a49e05700e46c409ed5d"
     "e77780a5f389e3f13dad406c9d55675329c5c921f07034180937c0f6ef34a2308b6ff3e1a"
     "0e9dc1ea65f5632730e8744d1db2c40a6595b",
     "773a539701e55662fe11f01690b70dac29366e55ac57c251993439972ead7ce4", false},

    {27, "long message",
     "d115acc9a636915241795f48852052e07b51273ae2448251ec1d0d0f9807f3db",
     "696d2456de853fa028f486fef437b6b6d1b530a8475e299db3a9005ae9cef8401985b7d31"
     "e172e8f439ccd1ad1ec44c9b86b78f3f243c1305b53bc21abad7a8fc5256311bfd34c98e3"
     "7dfdc649e7ae4bda08cf2994b063c0c7106ed0b02a1f48af9191cbfb0d6a953b7e04327df"
     "e8c93779cb574ba9cba575d01674e83621aa0c5f400d6e6cd24b301e33c9f3303e73bf357"
     "408c1be86c2489c09de998ff2ef32df554f1247d9313ce1a7160115d06f4c18d6556ff798"
     "6ef8a55e2adcfa27e4c69c71cc2ff01639e9d49bd9ed0687f530ffeb0890132457df20880"
     "81bc4a2f7f0a9f4dcea2c80d991db7f3747a1803d7619aaf3dd382c69536a0bcdb931cbe",
     "2f2a862bd0d9f305135629396b05988054e0f5103883892271a20b7902e0cb86", false},

    {28, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "51ab1606034383fe4b3b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {29, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0a7aeb9eab9b57a80d7bd0ea2726394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {30, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "52ab1606034383fe4b3b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {31, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "097aeb9eab9b57a80d7bd0ea2726394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {32, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "d0ab1606034383fe4b3b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {33, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "8b7aeb9eab9b57a80d7bd0ea2726394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {34, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50aa1606034383fe4b3b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {35, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7beb9eab9b57a80d7bd0ea2726394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {36, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1686034383fe4b3b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {37, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb1eab9b57a80d7bd0ea2726394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {38, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606024383fe4b3b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {39, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb9eaa9b57a80d7bd0ea2726394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {40, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606014383fe4b3b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {41, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb9ea99b57a80d7bd0ea2726394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {42, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab16060343837e4b3b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {43, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb9eab9b57280d7bd0ea2726394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {44, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4a3b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {45, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb9eab9b57a80c7bd0ea2726394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {46, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fecb3b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {47, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb9eab9b57a88d7bd0ea2726394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {48, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b1b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {49, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb9eab9b57a80d5bd0ea2726394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {50, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b3b4ac0a341a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {51, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb9eab9b57a80d7bd1ea2726394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {52, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b3b4bc0a241a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {53, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb9eab9b57a80d7bd0ea2626394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {54, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b3b4bc0a141a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {55, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb9eab9b57a80d7bd0ea2526394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {56, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b3b4bc02341a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {57, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb9eab9b57a80d7bd0eaa726394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {58, "Flipped bit 248 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b3b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccfc0", true},

    {59, "Flipped bit 248 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb9eab9b57a80d7bd0ea2726394a56144e2a0fc0b979d090c1846c14b3ec", true},

    {60, "Flipped bit 249 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b3b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccfc3", true},

    {61, "Flipped bit 249 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb9eab9b57a80d7bd0ea2726394a56144e2a0fc0b979d090c1846c14b3ef", true},

    {62, "Flipped bit 254 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b3b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccf81", true},

    {63, "Flipped bit 254 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb9eab9b57a80d7bd0ea2726394a56144e2a0fc0b979d090c1846c14b3ad", true},

    {64, "Flipped bit 255 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b3b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccf41", true},

    {65, "Flipped bit 255 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb9eab9b57a80d7bd0ea2726394a56144e2a0fc0b979d090c1846c14b36d", true},

    {66, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "51ab1606034383fe4a3b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {67, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0a7aeb9eab9b57a80c7bd0ea2726394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {68, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab16860343837e4b3b4bc0a341a82e40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {69, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb1eab9b57280d7bd0ea2726394a56144e2a0fc0b979d090c1846c14b3ed", true},

    {70, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab16060343837e4b3b4bc0a341a8ae40ac85e455cdfeed4cac902a7b8ccfc1", true},

    {71, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0b7aeb9eab9b57280d7bd0ea272639ca56144e2a0fc0b979d090c1846c14b3ed", true},

    {72, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "af54e9f9fcbc7c01b4c4b43f5cbe57d1bf537a1baa320112b3536fd58473303e", true},

    {73, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "f48514615464a857f2842f15d8d9c6b5a9ebb1d5f03f46862f6f3e7b93eb4c12", true},

    {74, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "0000000000000000000000000000000000000000000000000000000000000000", true},

    {75, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0000000000000000000000000000000000000000000000000000000000000000", true},

    {76, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", true},

    {77, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", true},

    {78, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "d02b968683c3037ecbbbcb4023c128aec02c0564d54d7e6dcc2c10aafb0c4f41", true},

    {79, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "8bfa6b1e2b1bd7288dfb506aa7a6b9cad694ceaa8f4039f950104104ec94336d", true},

    {80, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "51aa1707024282ff4a3a4ac1a240a92f41ad84e554ccffec4dad912b7a8dcec0", true},

    {81, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f",
     "0a7bea9faa9a56a90c7ad1eb2627384b57154f2b0ec1b878d191c0856d15b2ec", true},

    {82, "empty message",
     "7bf9e536b66a215c22233fe2daaa743a898b9acb9f7802de70b40e3d6e43ef97", "",
     "d087790afab25477456d379cab1639d1", false},

    {83, "short message",
     "e754076ceab3fdaf4f9bcab7d4f0df0cbbafbc87731b8f9b7cd2166472e8eebc", "40",
     "9bd4531b76933c9267d5dd0ee9bc81b9", false},

    {84, "short message",
     "ea3b016bdd387dd64d837c71683808f335dbdc53598a4ea8c5f952473fafaf5f", "6601",
     "79965f484fff8350ddf0fcb0cc513f13", false},

    {85, "short message",
     "73d4709637857dafab6ad8b2b0a51b06524717fedf100296644f7cfdaae1805b",
     "f1d300", "37747ec77e7844a81c3355f9c2f72875", false},

    {86, "short message",
     "d5c81b399d4c0d1583a13da56de6d2dc45a66e7b47c24ab1192e246dc961dd77",
     "2ae63cbf", "ad6d1627d7a1f67b855381da44fd4ec3", false},

    {87, "short message",
     "2521203fa0dddf59d837b2830f87b1aa61f958155df3ca4d1df2457cb4284dc8",
     "af3a015ea1", "0fca2284a5d3346cbf9b98a65822a8a7", false},

    {88, "short message",
     "665a02bc265a66d01775091da56726b6668bfd903cb7af66fb1b78a8a062e43c",
     "3f56935def3f", "8cd87f6ae1614e4a731d52ad0d877442", false},

    {89, "short message",
     "facd75b22221380047305bc981f570e2a1af38928ea7e2059e3af5fc6b82b493",
     "57bb86beed156f", "73941b79cb7c9f0c7b711bb94441b432", false},

    {90, "short message",
     "505aa98819809ef63b9a368a1e8bc2e922da45b03ce02d9a7966b15006dba2d5",
     "2e4e7ef728fe11af", "5cf2b04fe3af8d2694ba4e614367c08a", false},

    {91, "short message",
     "f942093842808ba47f64e427f7351dde6b9546e66de4e7d60aa6f328182712cf",
     "852a21d92848e627c7", "3e06ab8ab01fffb65865a7e8a123b374", false},

    {92, "short message",
     "64be162b39c6e5f1fed9c32d9f674d9a8cde6eaa2443214d86bd4a1fb53b81b4",
     "195a3b292f93baff0a2c", "80cb2ab4e57ec551fd73a3fcbc622538", false},

    {93, "short message",
     "b259a555d44b8a20c5489e2f38392ddaa6be9e35b9833b67e1b5fdf6cb3e4c6c",
     "afd73117330c6e8528a6e4", "71ceb6dd3ccf0c96b15ae42b432c1d83", false},

    {94, "short message",
     "2c6fc62daa77ba8c6881b3dd6989898fef646663cc7b0a3db8228a707b85f2dc",
     "0ff54d6b6759120c2e8a51e3", "ef5e5e4a958e7820b13fce3d181f2a76", false},

    {95, "short message",
     "abab815d51df29f740e4e2079fb798e0152836e6ab57d1536ae8929e52c06eb8",
     "f0058d412a104e53d820b95a7f", "d56cbaf3aee9310f66083f242a37affe", false},

    {96, "short message",
     "3d5da1af83f7287458bff7a7651ea5d8db72259401333f6b82096996dd7eaf19",
     "aacc36972f183057919ff57b49e1", "6520b49b8a11abdbe5ac46f4ec00ffbc", false},

    {97, "short message",
     "c19bdf314c6cf64381425467f42aefa17c1cc9358be16ce31b1d214859ce86aa",
     "5d066a92c300e9b6ddd63a7c13ae33", "3f14e6b55d2691a6048b70bab7ceada6",
     false},

    {98, "", "612e837843ceae7f61d49625faa7e7494f9253e20cb3adcea686512b043936cd",
     "cc37fae15f745a2f40e2c8b192f2b38d", "22f48f8668f5c2505315f0b525cf4f95",
     false},

    {99, "", "73216fafd0022d0d6ee27198b2272578fa8f04dd9f44467fbb6437aa45641bf7",
     "d5247b8f6c3edcbfb1d591d13ece23d2f5", "31a2a03723c51e04611ab09d47bf2598",
     false},

    {100, "",
     "0427a70e257528f3ab70640bba1a5de12cf3885dd4c8e284fbbb55feb35294a5",
     "13937f8544f44270d01175a011f7670e93fa6ba7ef02336e",
     "ed651a977854fb5cc577ab7db7b567af", false},

    {101, "",
     "96e1e4896fb2cd05f133a6a100bc5609a7ac3ca6d81721e922dadd69ad07a892",
     "91a17e4dfcc3166a1add26ff0e7c12056e8a654f28a6de24f4ba739ceb5b5b18",
     "a3cdf96778e1f9a42a89f91426873ff1", false},

    {102, "long message",
     "41201567be4e6ea06de2295fd0e6e8a7d862bb57311894f525d8adeabba4a3e4",
     "58c8c73bdd3f350c97477816eae4d0789c9369c0e99c248902c700bc29ed986425985eb3f"
     "a55709b73bf620cd9b1cb",
     "15cf5da2312cfd8f9debdd8b3ab07d6b", false},

    {103, "long message",
     "649e373e681ef52e3c10ac265484750932a9918f28fb824f7cb50adab39781fe",
     "39b447bd3a01983c1cb761b456d69000948ceb870562a536126a0d18a8e7e49b16de8fe67"
     "2f13d0808d8b7d957899917",
     "5ddcacb9ad0b02dac96012b4a4d1729d", false},

    {104, "long message",
     "7b0d237f7b536e2c6950990e61b361b384333dda690045c591321a4e3f79747f",
     "3d6283d11c0219b525620e9bf5b9fd887d3f0f707acb1fbdffab0d97a5c6d07fc547762e0"
     "e7dd7c43ad35fab1c790f8047",
     "781c196c0d71d88e8db7685571ad13e4", false},

    {105, "long message",
     "17c92663741f012e5bb6714e614c2d155948617f10936269d954c58aba2ae62d",
     "7fdd6a15c861d0313f6635d77dc55e115ff18c8ab063b5d03eab472eeca87a378188f2581"
     "3515cf90b6cffa94a8ff36b29d65603eab3fbd2aa9500b261e184049893dc6ca2010becac"
     "163053f211070bdda621b8bd8af77e450268603b52db34c90be836dfebddef42303f724e6"
     "3bf0f",
     "3c31e9fa2ea634f2bfbd0d7f6dbf29c2", false},

    {106, "long message",
     "424c6b22606fcc094ae82fc5d3cbe484174c2211b3ec778091cac34a8e38a152",
     "d96ff062e2490e8e0c54c5a8b89e85b25a66d93d7c2b93bdfef846b70d38672746a4b988d"
     "08f15a5c527ca4f2c80e53f7c6ac0521bc57ebe38209180cbf934e0bbeb58cfb63d75da64"
     "af41d09ce174af1896f42522910fced35ea000402e95fd3ac7aa6d5e0a6b533b0879bc466"
     "019b3a5e6b16e4bd1ea6cdfc9ccc1d6f0f0",
     "0f937aa5b5aa5efa6f8c1940c9b57b19", false},

    {107, "long message",
     "15d553c8da433d53cdc7f15087a70349caab57b379a4078928ce9b99302e31a6",
     "d6c0c53b73f74fb426adfdc143d70db7f7a8f8ed32a2faef263cf9ab117537b6b9d1728bd"
     "1000c1f28906c6ce6ad21862bfa4d689c1a8ebe3868b992098b7f981b2af5189a6adedff5"
     "3a6c70c83693f5c8d6385a9a8a4dca017c5716ac4d5b9765c5ca2ab5f9867e02795198c0b"
     "9527e07d08af52dbcb91ceb3d8b412a2b2402",
     "b2948a1b6fa0558d443c0b8cee87c4c8", false},

    {108, "long message",
     "ffe559468a1031dfb3ced2e381e74b5821a36d9abf5f2e59895a7fdca0fa56a0",
     "238899a84a3cf15202a1fbef4741e133fb24c009a0cd83854c6d1d7c9266d4c3eafe6d1df"
     "c18f13845ccdad7fe277627b5fd5ff2555ce6dfde1ee078540a0a3590c6d9bf2fb63ba9af"
     "be9380e797be7cd017645c5a3613eef38ef89e3b7461e6e700ff2b4deef5636c9d2198b14"
     "3f797ca1820a3dcc5d462ebf4a8c4c09eb202a23592eb9524082c79adda8fcd56d256041a"
     "26bf8f523962ba911ce5a5786570d65be3c4df722ed8830302065febdf944715298a1fbb7"
     "d10b68d7da2bf889324314ce51e815c7fbf03aa0a8358aff3a86eb7a33f9a4923660db304"
     "7e793bebb0c6918f4395d400381723fdae2832c36efc8e368a68f30f6351c3bc942cd560",
     "9c899283ace03520d5109e43c30d4698", false},

    {109, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "51ab1606034383fe4b3b4bc0a341a82e", true},

    {110, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0a7aeb9eab9b57a80d7bd0ea2726394a",
     true},

    {111, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "52ab1606034383fe4b3b4bc0a341a82e", true},

    {112, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "097aeb9eab9b57a80d7bd0ea2726394a",
     true},

    {113, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "d0ab1606034383fe4b3b4bc0a341a82e", true},

    {114, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "8b7aeb9eab9b57a80d7bd0ea2726394a",
     true},

    {115, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50aa1606034383fe4b3b4bc0a341a82e", true},

    {116, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7beb9eab9b57a80d7bd0ea2726394a",
     true},

    {117, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1686034383fe4b3b4bc0a341a82e", true},

    {118, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb1eab9b57a80d7bd0ea2726394a",
     true},

    {119, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606024383fe4b3b4bc0a341a82e", true},

    {120, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb9eaa9b57a80d7bd0ea2726394a",
     true},

    {121, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606014383fe4b3b4bc0a341a82e", true},

    {122, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb9ea99b57a80d7bd0ea2726394a",
     true},

    {123, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab16060343837e4b3b4bc0a341a82e", true},

    {124, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb9eab9b57280d7bd0ea2726394a",
     true},

    {125, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4a3b4bc0a341a82e", true},

    {126, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb9eab9b57a80c7bd0ea2726394a",
     true},

    {127, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fecb3b4bc0a341a82e", true},

    {128, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb9eab9b57a88d7bd0ea2726394a",
     true},

    {129, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b1b4bc0a341a82e", true},

    {130, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb9eab9b57a80d5bd0ea2726394a",
     true},

    {131, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b3b4ac0a341a82e", true},

    {132, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb9eab9b57a80d7bd1ea2726394a",
     true},

    {133, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b3b4bc0a241a82e", true},

    {134, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb9eab9b57a80d7bd0ea2626394a",
     true},

    {135, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b3b4bc0a141a82e", true},

    {136, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb9eab9b57a80d7bd0ea2526394a",
     true},

    {137, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b3b4bc02341a82e", true},

    {138, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb9eab9b57a80d7bd0eaa726394a",
     true},

    {139, "Flipped bit 120 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b3b4bc0a341a82f", true},

    {140, "Flipped bit 120 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb9eab9b57a80d7bd0ea2726394b",
     true},

    {141, "Flipped bit 121 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b3b4bc0a341a82c", true},

    {142, "Flipped bit 121 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb9eab9b57a80d7bd0ea27263948",
     true},

    {143, "Flipped bit 126 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b3b4bc0a341a86e", true},

    {144, "Flipped bit 126 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb9eab9b57a80d7bd0ea2726390a",
     true},

    {145, "Flipped bit 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab1606034383fe4b3b4bc0a341a8ae", true},

    {146, "Flipped bit 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb9eab9b57a80d7bd0ea272639ca",
     true},

    {147, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "51ab1606034383fe4a3b4bc0a341a82e", true},

    {148, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0a7aeb9eab9b57a80c7bd0ea2726394a",
     true},

    {149, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab16860343837e4b3b4bc0a341a82e", true},

    {150, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb1eab9b57280d7bd0ea2726394a",
     true},

    {151, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "50ab16060343837e4b3b4bc0a341a8ae", true},

    {152, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0b7aeb9eab9b57280d7bd0ea272639ca",
     true},

    {153, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "af54e9f9fcbc7c01b4c4b43f5cbe57d1", true},

    {154, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "f48514615464a857f2842f15d8d9c6b5",
     true},

    {155, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "00000000000000000000000000000000", true},

    {156, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "00000000000000000000000000000000",
     true},

    {157, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "ffffffffffffffffffffffffffffffff", true},

    {158, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "ffffffffffffffffffffffffffffffff",
     true},

    {159, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "d02b968683c3037ecbbbcb4023c128ae", true},

    {160, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "8bfa6b1e2b1bd7288dfb506aa7a6b9ca",
     true},

    {161, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "",
     "51aa1707024282ff4a3a4ac1a240a92f", true},

    {162, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f",
     "000102030405060708090a0b0c0d0e0f", "0a7bea9faa9a56a90c7ad1eb2627384b",
     true},

    {163, "short key", "a349ac0a9f9f74e48e099cc3dbf9a9c9", "",
     "ee8234ca22b6cbd87cc2ba492ecea39aebc634032998965689d393e2d4f88653", false},

    {164, "short key", "ac686ba0f1a51b4ec4f0b30492b7f556",
     "2fa43a14ae500507deb95ab5bd32b0fe",
     "39eaea730a72f19b316dae7ae77904000c8e64ac5bb8a1e75eeaea2e3dc3afce", false},

    {165, "short key", "73ef9ef1a4225e51e3c1db3ace1fa24f",
     "ffad380d9aabb0acede5c1bf112925cdfc3d379fc2376a4fe2644490d0430ac3",
     "4c85f67258256226dcdde626b100daef34dedb8c38b34bf9f3b9db5afe87ae9b", false},

    {166, "short key", "e34f15c7bd819930fe9d66e0c166e61c", "",
     "872026cd30ed8482af7508c0c52c8cb6", false},

    {167, "short key", "e09eaa5a3f5e56d279d5e7a03373f6ea",
     "ef4eab37181f98423e53e947e7050fd0", "6700cfd7fdb1c667ead477fb942ff03b",
     false},

    {168, "short key", "9bd3902ed0996c869b572272e76f3889",
     "a7ba19d49ee1ea02f098aa8e30c740d893a4456ccc294040484ed8a00a55f93e",
     "54632b0ffcbb3763b70c6dd6dc38ed3a", false},

    {169, "long key",
     "8a0c46eb8a2959e39865330079763341e7439dab149694ee57e0d61ec73d947e1d5301cd9"
     "74e18a5e0d1cf0d2c37e8aadd9fd589d57ef32e47024a99bc3f70c077",
     "", "7a1ea05873f754f9993062243474d3874f4fffa823ce16a804b22cb101a5b100",
     false},

    {170, "long key",
     "2877ebb81f80334fd00516337446c5cf5ad4a3a2e197269e5b0ad1889dfe2b4b0aaa676fa"
     "c55b36ce3affc7f1092ab89c53273a837bd5bc94d1a9d9e5b02e9856f",
     "ba448db88f154f775028fdecf9e6752d",
     "17831971b854b2210579098b019ae62f3bf56affbd0ecd3bac77a02bd78b4f49", false},

    {171, "long key",
     "21178e26bc28ffc27c06f762ba190a627075856d7ca6feab79ac63149b17126e34fd9e559"
     "0e0e90aac801df09505d8af2dd0a2703b352c573ac9d2cb063927f2af",
     "7d5f1d6b993452b1b53a4375760d10a20d46a0ab9ec3943fc4b07a2ce735e731",
     "a14f8864e3c71a3da1fd268701547cee12c0b1ddc4f7480f253b7cafc3d04e6a", false},

    {172, "long key",
     "813e0c078c221375e80590ace6774eafd2d2c242350988d02efa550e05aecbe100c1b8bf1"
     "54c932cf9e57177015c816c42bc7fbc71ceaa5328c7316b7f0f30330f",
     "", "681f84442bd90223bd5577a7bce8b93e", false},

    {173, "long key",
     "5713343096b0aaf0562a6b92c1a15535924160475a4e4233589159728c562e3b2ad96f740"
     "c6a4da2bc3f768ce98c9bd66bac28d1646ff592028c940d455f35eeb4",
     "71712de2fac1fb855673bff72af64257", "2e6969e57f7b33e96a31ea194f3e188c",
     false},

    {174, "long key",
     "7208afbecf5f1f34828f98b719414e280716de64f5edd1ae1c774153cd2022337bb20fade"
     "1b7856f1dbfd40e2b4307f1293ceff1692ee90d8c90b5fdf953ab01a5",
     "43b53302b604d613e62db002044a4782d572ac8fbd3cd0ece91b43bc52e18e98",
     "c6712f2c1b0df39eca97ac472b257ecd", false}};

#endif  // hmac_sha3_256_vectors_h__
