/* Generated by re2c 4.0 */
/*
 * phpdbg_lexer.l
 */

#include "phpdbg.h"
#include "phpdbg_cmd.h"

#include "phpdbg_parser.h"

#define LEX(v) (PHPDBG_G(lexer).v)

#define YYCTYPE unsigned char
#define YYSETCONDITION(x) LEX(state) = x;
#define YYGETCONDITION() LEX(state)
#define YYCURSOR LEX(cursor)
#define YYMARKER LEX(marker)
#define YYCTXMARKER LEX(ctxmarker)
#define yyleng LEX(len)
#define yytext ((char*) LEX(text))
#undef YYDEBUG
#define YYDEBUG(a, b)
#define YYFILL(n)

#define NORMAL 0
#define PRE_RAW 1
#define RAW 2
#define INITIAL 3

ZEND_EXTERN_MODULE_GLOBALS(phpdbg)

void phpdbg_init_lexer (phpdbg_param_t *stack, char *input) {
	PHPDBG_G(parser_stack) = stack;

	YYSETCONDITION(INITIAL);

	LEX(text) = YYCURSOR = (unsigned char *) input;
	LEX(len) = strlen(input);
}

static int unescape_string(char *s) {
	switch (*s) {
		case '\'':
		case '\"': {
			char start = *s;
			size_t off = 1;
			do {
				if (s[off] == '\\') {
					off++;
				}
				*s = s[off];
			} while ((++s)[off] != start);
			return off + 1;
		}
	}

	return 0;
}

int phpdbg_lex (phpdbg_param_t* yylval) {

restart:
	LEX(text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm_NORMAL[512] = {
		  0,  62,  62,  62,  62,  62,  62,  62,
		 62,  40,   0,  62,  62,  40,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 40,  62,  50,  40,  62,  62,  62,  14,
		 62,  62,  62,  62,  62,  62,  63,  62,
		127, 127, 127, 127, 127, 127, 127, 127,
		127, 127,  40,  62,  62,  62,  62,  62,
		 62, 254, 254, 254, 254, 254, 254, 190,
		190, 190, 190, 190, 190, 190, 190, 190,
		190, 190, 190, 190, 190, 190, 190, 190,
		190, 190, 190,  62,   2,  62,  62, 190,
		 62, 254, 254, 254, 254, 254, 254, 190,
		190, 190, 190, 190, 190, 190, 190, 190,
		190, 190, 190, 190, 190, 190, 190, 190,
		190, 190, 190,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		 62,  62,  62,  62,  62,  62,  62,  62,
		  0,  64,  64,  64,  64,  64,  64,  64,
		 64, 128,   0,  64,  64, 128,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		128,  64,   0,   0,  64,  64,  64,   0,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,   0,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64,
		 64,  64,  64,  64,  64,  64,  64,  64
	};
	static const unsigned char yybm_PRE_RAW[256] = {
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,  64,   0,   0,   0,  64,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		 64,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0, 128,   0,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0
	};
	static const unsigned char yybm_RAW[256] = {
		  0, 247, 247, 247, 247, 247, 247, 247,
		247, 247,   0, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 148,  70, 247, 247, 247, 162,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247,   8, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 247
	};
	static const unsigned char yybm_INITIAL[256] = {
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0, 128,   0,   0,   0, 128,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		128,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0
	};
	if (YYGETCONDITION() < 2) {
		if (YYGETCONDITION() < 1) goto yyc_NORMAL;
		else goto yyc_PRE_RAW;
	} else {
		if (YYGETCONDITION() < 3) goto yyc_RAW;
		else goto yyc_INITIAL;
	}
/* *********************************** */
yyc_NORMAL:
	YYFILL(11);
	yych = *YYCURSOR;
	YYDEBUG(0, yych);
	if (yybm_NORMAL[256+yych] & 128) goto yy5;
	switch (yych) {
		case 0x00:
		case '\t':
		case '\n': goto yy1;
		case '"': goto yy6;
		case '#': goto yy8;
		case '\'': goto yy10;
		case '-': goto yy11;
		case '.':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy12;
		case '0': goto yy14;
		case ':': goto yy15;
		case 'D':
		case 'd': goto yy16;
		case 'E':
		case 'e': goto yy17;
		case 'F':
		case 'f': goto yy18;
		case 'I':
		case 'i': goto yy19;
		case 'N':
		case 'n': goto yy20;
		case 'O':
		case 'o': goto yy21;
		case 'T':
		case 't': goto yy22;
		case 'Y':
		case 'y': goto yy23;
		case 'Z': goto yy24;
		case 'z': goto yy25;
		default: goto yy2;
	}
yy1:
	YYDEBUG(1, yych);
	++YYCURSOR;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	return 0;
}
yy2:
	YYDEBUG(2, yych);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
yy3:
	YYDEBUG(3, yych);
	if (yybm_NORMAL[256+yych] & 64) goto yy2;
	if (yych <= ' ') goto yy4;
	if (yych == '#') goto yy4;
	if (yych <= '\'') goto yy26;
	goto yy28;
yy4:
	YYDEBUG(4, yych);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrndup(yytext, yyleng - unescape_string(yytext));
	yylval->len = yyleng;
	return T_ID;
}
yy5:
	YYDEBUG(5, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_NORMAL[256+yych] & 128) goto yy5;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	/* ignore whitespace */

	goto restart;
}
yy6:
	YYDEBUG(6, yych);
	yych = *++YYCURSOR;
	if (yych == '"') goto yy26;
	goto yy30;
yy7:
	YYDEBUG(7, yych);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 3) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) goto yy4;
			else goto yy9;
		} else {
			if (yyaccept == 2) goto yy13;
			else goto yy71;
		}
	} else {
		if (yyaccept <= 5) {
			if (yyaccept == 4) goto yy73;
			else goto yy85;
		} else {
			goto yy100;
		}
	}
yy8:
	YYDEBUG(8, yych);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy9;
		if (yych <= '-') {
			YYCTXMARKER = YYCURSOR;
			goto yy35;
		}
		YYCTXMARKER = YYCURSOR;
		goto yy36;
	} else {
		if (yych <= '/') goto yy9;
		if (yych <= '9') {
			YYCTXMARKER = YYCURSOR;
			goto yy36;
		}
	}
yy9:
	YYDEBUG(9, yych);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	YYSETCONDITION(INITIAL);
	return T_SEPARATOR;
}
yy10:
	YYDEBUG(10, yych);
	yych = *++YYCURSOR;
	if (yych == '\'') goto yy26;
	goto yy39;
yy11:
	YYDEBUG(11, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm_NORMAL[0+yych] & 1) goto yy12;
	if (yych == 'r') goto yy44;
	goto yy3;
yy12:
	YYDEBUG(12, yych);
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	if (yybm_NORMAL[0+yych] & 1) goto yy12;
	if (yych <= ' ') {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy13;
			if (yych <= 0x08) goto yy2;
		} else {
			if (yych == '\r') goto yy13;
			if (yych <= 0x1F) goto yy2;
		}
	} else {
		if (yych <= '&') {
			if (yych <= '!') goto yy2;
			if (yych <= '"') goto yy26;
			if (yych >= '$') goto yy2;
		} else {
			if (yych <= '\'') goto yy26;
			if (yych <= '/') goto yy2;
			if (yych <= ':') goto yy28;
			goto yy2;
		}
	}
yy13:
	YYDEBUG(13, yych);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = atoi(yytext);
	return T_DIGITS;
}
yy14:
	YYDEBUG(14, yych);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm_NORMAL[0+yych] & 1) goto yy12;
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy13;
			if (yych <= 0x08) goto yy3;
			goto yy13;
		} else {
			if (yych == '\r') goto yy13;
			goto yy3;
		}
	} else {
		if (yych <= '#') {
			if (yych <= ' ') goto yy13;
			if (yych <= '"') goto yy3;
			goto yy13;
		} else {
			if (yych == 'x') goto yy45;
			goto yy3;
		}
	}
yy15:
	YYDEBUG(15, yych);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy47;
	if (yych == '\\') goto yy48;
	goto yy46;
yy16:
	YYDEBUG(16, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy49;
	if (yych == 'i') goto yy49;
	goto yy3;
yy17:
	YYDEBUG(17, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy50;
	if (yych == 'n') goto yy50;
	goto yy3;
yy18:
	YYDEBUG(18, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'A') goto yy51;
	if (yych == 'a') goto yy51;
	goto yy3;
yy19:
	YYDEBUG(19, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'F') goto yy52;
	if (yych == 'f') goto yy52;
	goto yy3;
yy20:
	YYDEBUG(20, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy53;
	if (yych == 'o') goto yy53;
	goto yy3;
yy21:
	YYDEBUG(21, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == 'F') goto yy54;
		if (yych <= 'M') goto yy3;
		goto yy55;
	} else {
		if (yych <= 'f') {
			if (yych <= 'e') goto yy3;
			goto yy54;
		} else {
			if (yych == 'n') goto yy55;
			goto yy3;
		}
	}
yy22:
	YYDEBUG(22, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy56;
	if (yych == 'r') goto yy56;
	goto yy3;
yy23:
	YYDEBUG(23, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy57;
	if (yych == 'e') goto yy57;
	goto yy3;
yy24:
	YYDEBUG(24, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy58;
	goto yy3;
yy25:
	YYDEBUG(25, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'e') goto yy59;
	goto yy3;
yy26:
	YYDEBUG(26, yych);
	++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
yy27:
	YYDEBUG(27, yych);
	if (yybm_NORMAL[0+yych] & 2) goto yy26;
	if (yych <= '#') goto yy7;
	goto yy60;
yy28:
	YYDEBUG(28, yych);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy61;
	if (yych == '\\') goto yy48;
	goto yy7;
yy29:
	YYDEBUG(29, yych);
	++YYCURSOR;
	YYFILL(4);
	yych = *YYCURSOR;
yy30:
	YYDEBUG(30, yych);
	if (yybm_NORMAL[0+yych] & 4) goto yy29;
	if (yych <= ' ') {
		if (yych <= 0x00) goto yy7;
		if (yych == '\n') goto yy7;
	} else {
		if (yych <= '"') goto yy62;
		if (yych <= '#') goto yy31;
		if (yych <= ':') goto yy33;
		goto yy34;
	}
yy31:
	YYDEBUG(31, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
yy32:
	YYDEBUG(32, yych);
	if (yybm_NORMAL[0+yych] & 8) goto yy31;
	if (yych <= '\n') goto yy7;
	if (yych <= '"') goto yy63;
	goto yy64;
yy33:
	YYDEBUG(33, yych);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy65;
	goto yy32;
yy34:
	YYDEBUG(34, yych);
	++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy7;
			if (yych <= 0x08) goto yy26;
			goto yy7;
		} else {
			if (yych == '\r') goto yy7;
			if (yych <= 0x1F) goto yy26;
			goto yy7;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '!') goto yy26;
			if (yych <= '"') goto yy29;
			if (yych <= '#') goto yy7;
			goto yy26;
		} else {
			if (yych <= ':') goto yy60;
			if (yych == '\\') goto yy29;
			goto yy26;
		}
	}
yy35:
	YYDEBUG(35, yych);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy36;
	if (yych <= '/') goto yy7;
	if (yych >= ':') goto yy7;
yy36:
	YYDEBUG(36, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '.') goto yy36;
	if (yych <= '/') goto yy37;
	if (yych <= '9') goto yy36;
yy37:
	YYDEBUG(37, yych);
	YYCURSOR = YYCTXMARKER;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	return T_POUND;
}
yy38:
	YYDEBUG(38, yych);
	++YYCURSOR;
	YYFILL(4);
	yych = *YYCURSOR;
yy39:
	YYDEBUG(39, yych);
	if (yybm_NORMAL[0+yych] & 16) goto yy38;
	if (yych <= '\n') {
		if (yych <= 0x00) goto yy7;
		if (yych >= '\n') goto yy7;
	} else {
		if (yych <= '#') goto yy40;
		if (yych <= '\'') goto yy62;
		if (yych <= ':') goto yy42;
		goto yy43;
	}
yy40:
	YYDEBUG(40, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
yy41:
	YYDEBUG(41, yych);
	if (yybm_NORMAL[0+yych] & 32) goto yy40;
	if (yych <= '\n') goto yy7;
	if (yych <= '\'') goto yy63;
	goto yy66;
yy42:
	YYDEBUG(42, yych);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy67;
	goto yy41;
yy43:
	YYDEBUG(43, yych);
	++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	if (yych <= '"') {
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy7;
			if (yych <= 0x08) goto yy26;
			if (yych <= '\n') goto yy7;
			goto yy26;
		} else {
			if (yych <= '\r') goto yy7;
			if (yych == ' ') goto yy7;
			goto yy26;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '#') goto yy7;
			if (yych == '\'') goto yy38;
			goto yy26;
		} else {
			if (yych <= ':') goto yy60;
			if (yych == '\\') goto yy38;
			goto yy26;
		}
	}
yy44:
	YYDEBUG(44, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych <= '\f') {
			if (yych == '\t') goto yy68;
			goto yy3;
		} else {
			if (yych <= '\r') goto yy68;
			if (yych <= 0x1F) goto yy3;
			goto yy68;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy3;
			if (yych <= '-') goto yy69;
			goto yy70;
		} else {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy70;
			goto yy3;
		}
	}
yy45:
	YYDEBUG(45, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm_NORMAL[0+yych] & 64) goto yy72;
	goto yy3;
yy46:
	YYDEBUG(46, yych);
	++YYCURSOR;
	YYCURSOR -= 1;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	return T_COLON;
}
yy47:
	YYDEBUG(47, yych);
	++YYCURSOR;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	return T_DCOLON;
}
yy48:
	YYDEBUG(48, yych);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy4;
			if (yych <= 0x08) goto yy48;
			goto yy4;
		} else {
			if (yych == '\r') goto yy4;
			if (yych <= 0x1F) goto yy48;
			goto yy4;
		}
	} else {
		if (yych <= '&') {
			if (yych <= '!') goto yy48;
			if (yych <= '#') goto yy4;
			goto yy48;
		} else {
			if (yych <= '\'') goto yy4;
			if (yych == ':') goto yy74;
			goto yy48;
		}
	}
yy49:
	YYDEBUG(49, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy75;
	if (yych == 's') goto yy75;
	goto yy3;
yy50:
	YYDEBUG(50, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'A') goto yy76;
	if (yych == 'a') goto yy76;
	goto yy3;
yy51:
	YYDEBUG(51, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'L') goto yy77;
	if (yych == 'l') goto yy77;
	goto yy3;
yy52:
	YYDEBUG(52, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '\f') {
		if (yych == '\t') goto yy78;
		goto yy3;
	} else {
		if (yych <= '\r') goto yy78;
		if (yych == ' ') goto yy78;
		goto yy3;
	}
yy53:
	YYDEBUG(53, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '\f') {
		if (yych <= 0x00) goto yy79;
		if (yych <= 0x08) goto yy3;
		if (yych <= '\n') goto yy79;
		goto yy3;
	} else {
		if (yych <= '\r') goto yy79;
		if (yych == ' ') goto yy79;
		goto yy3;
	}
yy54:
	YYDEBUG(54, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'F') goto yy53;
	if (yych == 'f') goto yy53;
	goto yy3;
yy55:
	YYDEBUG(55, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '\f') {
		if (yych <= 0x00) goto yy80;
		if (yych <= 0x08) goto yy3;
		if (yych <= '\n') goto yy80;
		goto yy3;
	} else {
		if (yych <= '\r') goto yy80;
		if (yych == ' ') goto yy80;
		goto yy3;
	}
yy56:
	YYDEBUG(56, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy81;
	if (yych == 'u') goto yy81;
	goto yy3;
yy57:
	YYDEBUG(57, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy55;
	if (yych == 's') goto yy55;
	goto yy3;
yy58:
	YYDEBUG(58, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy82;
	goto yy3;
yy59:
	YYDEBUG(59, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'n') goto yy83;
	goto yy3;
yy60:
	YYDEBUG(60, yych);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy7;
yy61:
	YYDEBUG(61, yych);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy84;
	goto yy7;
yy62:
	YYDEBUG(62, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '\r') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy4;
			goto yy27;
		} else {
			if (yych <= '\n') goto yy4;
			if (yych <= '\f') goto yy27;
			goto yy4;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= 0x1F) goto yy27;
			goto yy4;
		} else {
			if (yych == '#') goto yy4;
			goto yy27;
		}
	}
yy63:
	YYDEBUG(63, yych);
	++YYCURSOR;
	goto yy4;
yy64:
	YYDEBUG(64, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '"') goto yy31;
	if (yych == '\\') goto yy31;
	goto yy7;
yy65:
	YYDEBUG(65, yych);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy86;
	goto yy32;
yy66:
	YYDEBUG(66, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '\'') goto yy40;
	if (yych == '\\') goto yy40;
	goto yy7;
yy67:
	YYDEBUG(67, yych);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy87;
	goto yy41;
yy68:
	YYDEBUG(68, yych);
	++YYCURSOR;
	YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych <= '\f') {
			if (yych == '\t') goto yy68;
			goto yy7;
		} else {
			if (yych <= '\r') goto yy68;
			if (yych <= 0x1F) goto yy7;
			goto yy68;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy7;
			if (yych <= '-') goto yy88;
			goto yy89;
		} else {
			if (yych <= '/') goto yy7;
			if (yych <= '9') goto yy89;
			goto yy7;
		}
	}
yy69:
	YYDEBUG(69, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy70;
	if (yych <= '/') goto yy3;
	if (yych >= ':') goto yy3;
yy70:
	YYDEBUG(70, yych);
	yyaccept = 3;
	YYMARKER = ++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	if (yych <= '"') {
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy71;
			if (yych <= 0x08) goto yy2;
			if (yych >= '\v') goto yy2;
		} else {
			if (yych <= 0x1F) {
				if (yych >= 0x0E) goto yy2;
			} else {
				if (yych <= ' ') goto yy71;
				if (yych <= '!') goto yy2;
				goto yy26;
			}
		}
	} else {
		if (yych <= '-') {
			if (yych <= '#') goto yy71;
			if (yych == '\'') goto yy26;
			goto yy2;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy70;
				goto yy2;
			} else {
				if (yych <= '9') goto yy70;
				if (yych <= ':') goto yy28;
				goto yy2;
			}
		}
	}
yy71:
	YYDEBUG(71, yych);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	char *text = yytext + 2;
	while (*++text < '0');
	yylval->num = atoi(text);
	return T_REQ_ID;
}
yy72:
	YYDEBUG(72, yych);
	yyaccept = 4;
	YYMARKER = ++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	if (yybm_NORMAL[0+yych] & 64) goto yy72;
	if (yych <= ' ') {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy73;
			if (yych <= 0x08) goto yy2;
		} else {
			if (yych == '\r') goto yy73;
			if (yych <= 0x1F) goto yy2;
		}
	} else {
		if (yych <= '&') {
			if (yych <= '!') goto yy2;
			if (yych <= '"') goto yy26;
			if (yych >= '$') goto yy2;
		} else {
			if (yych <= '\'') goto yy26;
			if (yych <= '/') goto yy2;
			if (yych <= ':') goto yy28;
			goto yy2;
		}
	}
yy73:
	YYDEBUG(73, yych);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	phpdbg_init_param(yylval, ADDR_PARAM);
	yylval->addr = strtoul(yytext, 0, 16);
	return T_ADDR;
}
yy74:
	YYDEBUG(74, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '\\') goto yy48;
	goto yy7;
yy75:
	YYDEBUG(75, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'A') goto yy90;
	if (yych == 'a') goto yy90;
	goto yy3;
yy76:
	YYDEBUG(76, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'B') goto yy91;
	if (yych == 'b') goto yy91;
	goto yy3;
yy77:
	YYDEBUG(77, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy92;
	if (yych == 's') goto yy92;
	goto yy3;
yy78:
	YYDEBUG(78, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '\f') {
		if (yych == '\t') goto yy78;
	} else {
		if (yych <= '\r') goto yy78;
		if (yych == ' ') goto yy78;
	}
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	YYSETCONDITION(RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_IF;
}
yy79:
	YYDEBUG(79, yych);
	++YYCURSOR;
	YYCURSOR -= 1;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = 0;
	return T_FALSY;
}
yy80:
	YYDEBUG(80, yych);
	++YYCURSOR;
	YYCURSOR -= 1;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = 1;
	return T_TRUTHY;
}
yy81:
	YYDEBUG(81, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy55;
	if (yych == 'e') goto yy55;
	goto yy3;
yy82:
	YYDEBUG(82, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy93;
	goto yy3;
yy83:
	YYDEBUG(83, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy93;
	goto yy3;
yy84:
	YYDEBUG(84, yych);
	++YYCURSOR;
yy85:
	YYDEBUG(85, yych);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrndup(yytext, yyleng);
	yylval->len = yyleng;
	return T_PROTO;
}
yy86:
	YYDEBUG(86, yych);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x00) goto yy85;
	if (yych == '\n') goto yy85;
	goto yy32;
yy87:
	YYDEBUG(87, yych);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x00) goto yy85;
	if (yych == '\n') goto yy85;
	goto yy41;
yy88:
	YYDEBUG(88, yych);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy89;
	if (yych <= '/') goto yy7;
	if (yych >= ':') goto yy7;
yy89:
	YYDEBUG(89, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '.') goto yy89;
	if (yych <= '/') goto yy71;
	if (yych <= '9') goto yy89;
	goto yy71;
yy90:
	YYDEBUG(90, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'B') goto yy94;
	if (yych == 'b') goto yy94;
	goto yy3;
yy91:
	YYDEBUG(91, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'L') goto yy95;
	if (yych == 'l') goto yy95;
	goto yy3;
yy92:
	YYDEBUG(92, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy53;
	if (yych == 'e') goto yy53;
	goto yy3;
yy93:
	YYDEBUG(93, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '_') goto yy96;
	goto yy3;
yy94:
	YYDEBUG(94, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'L') goto yy97;
	if (yych == 'l') goto yy97;
	goto yy3;
yy95:
	YYDEBUG(95, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy98;
	if (yych == 'e') goto yy98;
	goto yy3;
yy96:
	YYDEBUG(96, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm_NORMAL[0+yych] & 128) goto yy99;
	goto yy3;
yy97:
	YYDEBUG(97, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy101;
	if (yych == 'e') goto yy101;
	goto yy3;
yy98:
	YYDEBUG(98, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy55;
	if (yych == 'd') goto yy55;
	goto yy3;
yy99:
	YYDEBUG(99, yych);
	yyaccept = 6;
	YYMARKER = ++YYCURSOR;
	YYFILL(3);
	yych = *YYCURSOR;
	if (yybm_NORMAL[0+yych] & 128) goto yy99;
	if (yych <= ' ') {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy100;
			if (yych <= 0x08) goto yy2;
		} else {
			if (yych == '\r') goto yy100;
			if (yych <= 0x1F) goto yy2;
		}
	} else {
		if (yych <= '&') {
			if (yych <= '!') goto yy2;
			if (yych <= '"') goto yy26;
			if (yych >= '$') goto yy2;
		} else {
			if (yych <= '\'') goto yy26;
			if (yych == ':') goto yy28;
			goto yy2;
		}
	}
yy100:
	YYDEBUG(100, yych);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	phpdbg_init_param(yylval, OP_PARAM);
	yylval->str = estrndup(yytext, yyleng);
	yylval->len = yyleng;
	return T_OPCODE;
}
yy101:
	YYDEBUG(101, yych);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy53;
	if (yych == 'd') goto yy53;
	goto yy3;
/* *********************************** */
yyc_PRE_RAW:
	YYFILL(2);
	yych = *YYCURSOR;
	YYDEBUG(102, yych);
	if (yych <= '\r') {
		if (yych == '\t') goto yy104;
		if (yych >= '\r') goto yy104;
	} else {
		if (yych <= ' ') {
			if (yych >= ' ') goto yy105;
		} else {
			if (yych == '-') goto yy106;
		}
	}
	++YYCURSOR;
yy103:
	YYDEBUG(103, yych);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	YYSETCONDITION(RAW);

	YYCURSOR = LEX(text);
	goto restart;
}
yy104:
	YYDEBUG(104, yych);
	yych = *++YYCURSOR;
	if (yybm_PRE_RAW[0+yych] & 64) goto yy105;
	goto yy103;
yy105:
	YYDEBUG(105, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_PRE_RAW[0+yych] & 64) goto yy105;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	/* ignore whitespace */

	goto restart;
}
yy106:
	YYDEBUG(106, yych);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != 'r') goto yy103;
yy107:
	YYDEBUG(107, yych);
	++YYCURSOR;
	YYFILL(2);
	yych = *YYCURSOR;
	if (yybm_PRE_RAW[0+yych] & 128) goto yy110;
	if (yych <= '\r') {
		if (yych == '\t') goto yy107;
		if (yych >= '\r') goto yy107;
	} else {
		if (yych <= ' ') {
			if (yych >= ' ') goto yy107;
		} else {
			if (yych == '-') goto yy109;
		}
	}
yy108:
	YYDEBUG(108, yych);
	YYCURSOR = YYMARKER;
	goto yy103;
yy109:
	YYDEBUG(109, yych);
	yych = *++YYCURSOR;
	if (yybm_PRE_RAW[0+yych] & 128) goto yy110;
	goto yy108;
yy110:
	YYDEBUG(110, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_PRE_RAW[0+yych] & 128) goto yy110;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	char *text = yytext + 2;
	while (*++text < '0');
	yylval->num = atoi(text);
	return T_REQ_ID;
}
/* *********************************** */
yyc_RAW:
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(111, yych);
	if (yybm_RAW[0+yych] & 1) goto yy113;
	if (yych <= '\n') goto yy112;
	if (yych <= '"') goto yy115;
	if (yych <= '#') goto yy117;
	if (yych <= '\'') goto yy118;
	goto yy119;
yy112:
	YYDEBUG(112, yych);
	++YYCURSOR;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	return 0;
}
yy113:
	YYDEBUG(113, yych);
	YYMARKER = ++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 1) goto yy113;
	if (yych <= '\n') goto yy114;
	if (yych <= '"') goto yy115;
	if (yych <= '#') goto yy114;
	if (yych <= '\'') goto yy118;
	goto yy119;
yy114:
	YYDEBUG(114, yych);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrdup(yytext);
	yylval->len = yyleng;
	return T_INPUT;
}
yy115:
	YYDEBUG(115, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 2) goto yy115;
	if (yych <= '\n') goto yy116;
	if (yych <= '"') goto yy113;
	goto yy120;
yy116:
	YYDEBUG(116, yych);
	YYCURSOR = YYMARKER;
	goto yy114;
yy117:
	YYDEBUG(117, yych);
	++YYCURSOR;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	YYSETCONDITION(INITIAL);
	return T_SEPARATOR;
}
yy118:
	YYDEBUG(118, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 4) goto yy118;
	if (yych <= '\n') goto yy116;
	if (yych <= '\'') goto yy113;
	goto yy121;
yy119:
	YYDEBUG(119, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 8) goto yy119;
	if (yych <= '!') {
		if (yych <= 0x00) goto yy114;
		if (yych == '\n') goto yy114;
		goto yy113;
	} else {
		if (yych <= '"') goto yy122;
		if (yych == '\'') goto yy123;
		goto yy113;
	}
yy120:
	YYDEBUG(120, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 2) goto yy115;
	if (yych <= '\n') goto yy116;
	if (yych <= '"') goto yy122;
	goto yy120;
yy121:
	YYDEBUG(121, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 4) goto yy118;
	if (yych <= '\n') goto yy116;
	if (yych <= '\'') goto yy123;
	goto yy121;
yy122:
	YYDEBUG(122, yych);
	YYMARKER = ++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 16) goto yy122;
	if (yych <= '\n') goto yy114;
	if (yych <= '#') goto yy115;
	if (yych <= '\'') goto yy124;
	goto yy125;
yy123:
	YYDEBUG(123, yych);
	YYMARKER = ++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 32) goto yy123;
	if (yych <= '\n') goto yy114;
	if (yych <= '"') goto yy124;
	if (yych <= '#') goto yy118;
	goto yy126;
yy124:
	YYDEBUG(124, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 64) goto yy124;
	if (yych <= '\n') goto yy116;
	if (yych <= '"') goto yy123;
	if (yych <= '\'') goto yy122;
	goto yy127;
yy125:
	YYDEBUG(125, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '&') {
		if (yych <= 0x00) goto yy114;
		if (yych == '\n') goto yy114;
		goto yy122;
	} else {
		if (yych <= '\'') goto yy128;
		if (yych == '\\') goto yy125;
		goto yy122;
	}
yy126:
	YYDEBUG(126, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '!') {
		if (yych <= 0x00) goto yy114;
		if (yych == '\n') goto yy114;
		goto yy123;
	} else {
		if (yych <= '"') goto yy128;
		if (yych == '\\') goto yy126;
		goto yy123;
	}
yy127:
	YYDEBUG(127, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 64) goto yy124;
	if (yych <= '\n') goto yy116;
	if (yych >= '(') goto yy127;
yy128:
	YYDEBUG(128, yych);
	YYMARKER = ++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_RAW[0+yych] & 128) goto yy128;
	if (yych <= '\n') goto yy114;
	if (yych <= '#') goto yy124;
yy129:
	YYDEBUG(129, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '\n') {
		if (yych <= 0x00) goto yy114;
		if (yych <= '\t') goto yy128;
		goto yy114;
	} else {
		if (yych == '\\') goto yy129;
		goto yy128;
	}
/* *********************************** */
yyc_INITIAL:
	YYFILL(4);
	yych = *YYCURSOR;
	YYDEBUG(130, yych);
	if (yych <= 'E') {
		if (yych <= '\r') {
			if (yych == '\t') goto yy133;
			if (yych >= '\r') goto yy133;
		} else {
			if (yych == ' ') goto yy134;
			if (yych >= 'E') goto yy135;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Q') goto yy131;
			if (yych <= 'R') goto yy136;
			if (yych <= 'S') goto yy137;
		} else {
			if (yych <= 'q') {
				if (yych <= 'e') goto yy135;
			} else {
				if (yych <= 'r') goto yy138;
				if (yych <= 's') goto yy137;
			}
		}
	}
yy131:
	YYDEBUG(131, yych);
	++YYCURSOR;
yy132:
	YYDEBUG(132, yych);
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	YYSETCONDITION(NORMAL);

	YYCURSOR = LEX(text);
	goto restart;
}
yy133:
	YYDEBUG(133, yych);
	yych = *++YYCURSOR;
	if (yybm_INITIAL[0+yych] & 128) goto yy134;
	goto yy132;
yy134:
	YYDEBUG(134, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yybm_INITIAL[0+yych] & 128) goto yy134;
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	/* ignore whitespace */

	goto restart;
}
yy135:
	YYDEBUG(135, yych);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'V') goto yy139;
	if (yych == 'v') goto yy139;
	goto yy132;
yy136:
	YYDEBUG(136, yych);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy141;
	if (yych == 'u') goto yy141;
	goto yy132;
yy137:
	YYDEBUG(137, yych);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'H') goto yy142;
	if (yych == 'h') goto yy142;
	goto yy132;
yy138:
	YYDEBUG(138, yych);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy132;
			goto yy143;
		} else {
			if (yych == '\r') goto yy143;
			goto yy132;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= ' ') goto yy143;
			if (yych <= 'T') goto yy132;
			goto yy141;
		} else {
			if (yych == 'u') goto yy141;
			goto yy132;
		}
	}
yy139:
	YYDEBUG(139, yych);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych == '\t') goto yy144;
	} else {
		if (yych <= '\r') goto yy144;
		if (yych == ' ') goto yy144;
	}
yy140:
	YYDEBUG(140, yych);
	YYCURSOR = YYMARKER;
	goto yy132;
yy141:
	YYDEBUG(141, yych);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy145;
	if (yych == 'n') goto yy145;
	goto yy140;
yy142:
	YYDEBUG(142, yych);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych == '\t') goto yy146;
		goto yy140;
	} else {
		if (yych <= '\r') goto yy146;
		if (yych == ' ') goto yy146;
		goto yy140;
	}
yy143:
	YYDEBUG(143, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '\f') {
		if (yych == '\t') goto yy143;
	} else {
		if (yych <= '\r') goto yy143;
		if (yych == ' ') goto yy143;
	}
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_RUN;
}
yy144:
	YYDEBUG(144, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '\f') {
		if (yych == '\t') goto yy144;
	} else {
		if (yych <= '\r') goto yy144;
		if (yych == ' ') goto yy144;
	}
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_EVAL;
}
yy145:
	YYDEBUG(145, yych);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych == '\t') goto yy143;
		goto yy140;
	} else {
		if (yych <= '\r') goto yy143;
		if (yych == ' ') goto yy143;
		goto yy140;
	}
yy146:
	YYDEBUG(146, yych);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '\f') {
		if (yych == '\t') goto yy146;
	} else {
		if (yych <= '\r') goto yy146;
		if (yych == ' ') goto yy146;
	}
	yyleng = (size_t) YYCURSOR - (size_t) yytext;
	{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_SHELL;
}
}

}
