% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compat.r
\name{destiny-deprecated}
\alias{destiny-deprecated}
\alias{DiffusionMapCompat}
\alias{cube.helix}
\alias{dm.predict}
\alias{eig.decomp}
\alias{find.dm.k}
\alias{find.sigmas}
\alias{optimal.sigma}
\alias{lWhich}
\alias{plot_gradient_map}
\title{Compatibility versions of functions for destiny 1.x scripts}
\usage{
DiffusionMapCompat(
  data,
  sigma = "global",
  k = find_dm_k(nrow(data) - 1L),
  n.eigs = min(20L, nrow(data) - 2L),
  density.norm = TRUE,
  ...,
  distance = c("euclidean", "cosine", "rankcor"),
  censor.val = NULL,
  censor.range = NULL,
  missing.range = NULL,
  vars = NULL,
  verbose = !is.null(censor.range)
)

cube.helix(
  n = 6,
  start = 0,
  r = 0.4,
  hue = 0.8,
  gamma = 1,
  light = 0.85,
  dark = 0.15,
  reverse = FALSE
)

dm.predict(dm, new.data, verbose = FALSE)

eig.decomp(M, n.eigs, sym = isSymmetric(M))

find.dm.k(n, min.k = 100L, small = 1000L, big = 10000L)

find.sigmas(
  data,
  step.size = 0.1,
  steps = 10L,
  start = NULL,
  sample.rows = 500L,
  early.exit = FALSE,
  ...,
  censor.val = NULL,
  censor.range = NULL,
  missing.range = NULL,
  vars = NULL,
  verbose = TRUE
)

optimal.sigma(object)

lWhich(idx, nms = seq_len(len), len = length(nms), useNames = TRUE)

plot_gradient_map(
  coords,
  exprs,
  ...,
  gene,
  dims = 1:2,
  pal = hcl.colors,
  faceter = facet_wrap(~Gene)
)
}
\arguments{
\item{data, n, n.eigs, start, censor.val, censor.range, missing.range, vars, verbose, ...}{Corresponding parameters in multiple functions}

\item{sigma, k, density.norm, distance}{Corresponding \code{\link{DiffusionMap}} parameters}

\item{r, hue, gamma, light, dark, reverse}{Corresponding \code{\link{cube_helix}} parameters}

\item{dm, new.data}{Corresponding \code{\link{dm_predict}} parameters}

\item{M, sym}{Corresponding \code{\link{eig_decomp}} parameters}

\item{min.k, small, big}{Corresponding \code{\link{find_dm_k}} parameters}

\item{step.size, steps, sample.rows, early.exit}{Corresponding \code{\link{find_sigmas}} parameters}

\item{object}{Corresponding \code{\link{optimal_sigma}} parameters}
}
\description{
This is most useful if you have old scripts that use the old argument order and the default being global sigma.
Simply put \code{DiffusionMap <- DiffusionMapCompat} on top of your script to make it work with destiny 2.x.
}
\examples{
DiffusionMap <- DiffusionMapCompat
\dontrun{source('my-old-script.r')}

}
\keyword{internal}
