% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection-dist.r
\name{projection_dist}
\alias{projection_dist}
\title{Projection distance}
\usage{
projection_dist(dm, new_dcs = NULL, ..., new_data, verbose = FALSE)
}
\arguments{
\item{dm}{A \code{\link{DiffusionMap}} object.}

\item{new_dcs}{Diffusion component matrix of which to calculate the distance to the data.}

\item{...}{Passed to \code{\link[proxy:dist]{proxy::dist}} if \code{new_data} was passed.}

\item{new_data}{New data points to project into the diffusion map.
Can be a \link[base]{matrix}, \link[base]{data.frame},
\link[Biobase:class.ExpressionSet]{ExpressionSet},
or \link[SingleCellExperiment]{SingleCellExperiment}.}

\item{verbose}{If \code{\link{TRUE}}, log additional info to the console.}
}
\description{
Projection distance
}
\examples{
data(guo_norm)
g2_32 <- guo_norm[, guo_norm$num_cells < 64]
g64  <- guo_norm[, guo_norm$num_cells == 64]
dm <- DiffusionMap(g2_32)
d <- projection_dist(dm, new_data = g64)

}
