% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LawlorPancreasData.R
\name{LawlorPancreasData}
\alias{LawlorPancreasData}
\title{Obtain the Lawlor pancreas data}
\usage{
LawlorPancreasData(legacy = FALSE)
}
\arguments{
\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of read counts.
}
\description{
Provides the human pancreas single-cell RNA-seq data from Lawlor et al. (2017).
}
\details{
Column metadata is provided in the same form as supplied in GSE86469. 
This contains information such as the cell type labels and patient status.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/lawlor-pancreas}.
}
\examples{
sce <- LawlorPancreasData()

}
\references{
Lawlor N et al. (2017). 
Single-cell transcriptomes identify human islet cell signatures and reveal cell-type-specific expression changes in type 2 diabetes.
\emph{Genome Res.} 27(2), 208-222.
}
\author{
Aaron Lun
}
