% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_utilities.R
\name{.select_to_varnames}
\alias{.select_to_varnames}
\title{Variable selector}
\usage{
.select_to_varnames(
  select,
  data = NULL,
  var_info = NULL,
  arg_name = NULL,
  select_single = FALSE
)
}
\arguments{
\item{select}{A single object selecting variables, e.g. \code{c(age, stage)},
\code{starts_with("age")}}

\item{data}{A data frame to select columns from. Default is NULL}

\item{var_info}{A data frame of variable names and attributes. May also pass
a character vector of variable names. Default is NULL}

\item{arg_name}{Optional string indicating the source argument name. This
helps in the error messaging. Default is NULL.}

\item{select_single}{Logical indicating whether the result must be a single
variable. Default is \code{FALSE}}
}
\value{
A character vector of variable names
}
\description{
Function takes \code{select()}-like inputs and converts the selector to
a character vector of variable names. Functions accepts tidyselect syntax,
and additional selector functions defined within the package
}
