% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adk.R
\name{ad_ksample}
\alias{ad_ksample}
\title{Anderson--Darling K-Sample Test}
\usage{
ad_ksample(data = NULL, x, groups, alpha = 0.025)
}
\arguments{
\item{data}{a data.frame}

\item{x}{the variable in the data.frame on which to perform the
Anderson--Darling k-Sample test (usually strength)}

\item{groups}{a variable in the data.frame that defines the groups}

\item{alpha}{the significance level (default 0.025)}
}
\value{
Returns an object of class \code{adk}. This object has the following fields:
\itemize{
\item \code{call} the expression used to call this function
\item \code{data} the original data used to compute the ADK
\item \code{groups} a vector of the groups used in the computation
\item \code{alpha} the value of alpha specified
\item \code{n} the total number of observations
\item \code{k} the number of groups
\item \code{sigma} the computed standard deviation of the test statistic
\item \code{ad} the value of the Anderson--Darling k-Sample test statistic
\item \code{p} the computed p-value
\item \code{reject_same_dist} a boolean value indicating whether the null
hypothesis that all samples come from the same distribution is rejected
\item \code{raw} the original results returned from
\link[kSamples:ad.test]{ad.test}
}
}
\description{
This function performs an Anderson--Darling k-sample test. This is used to
determine if several samples (groups) share a common (unspecified)
distribution.
}
\details{
This function is a wrapper for the \link[kSamples:ad.test]{ad.test} function from
the package \code{kSamples}. The method "exact" is specified in the call to
\code{ad.test}. Refer to that package's documentation for details.

There is a minor difference in the formulation of the Anderson--Darling
k-Sample test in CMH-17-1G, compared with that in the Scholz and
Stephens (1987). This difference affects the test statistic and the
critical value in the same proportion, and therefore the conclusion of
the test is unaffected. When
comparing the test statistic generated by this function to that generated
by software that uses the CMH-17-1G formulation (such as ASAP, CMH17-STATS,
etc.), the test statistic reported by this function will be greater by
a factor of \eqn{(k - 1)}, with a corresponding change in the critical
value.

For more information about the difference between this function and
the formulation in CMH-17-1G, see the vignette on the subject, which
can be accessed by running \code{vignette("adktest")}
}
\examples{
library(dplyr)

carbon.fabric \%>\%
  filter(test == "WT") \%>\%
  filter(condition == "RTD") \%>\%
  ad_ksample(strength, batch)
##
## Call:
## ad_ksample(data = ., x = strength, groups = batch)
##
## N = 18          k = 3
## ADK = 0.912     p-value = 0.95989
## Conclusion: Samples come from the same distribution ( alpha = 0.025 )

}
\references{
F. W. Scholz and M. Stephens, “K-Sample Anderson--Darling Tests,” Journal
of the American Statistical Association, vol. 82, no. 399. pp. 918–924,
Sep-1987.

“Composite Materials Handbook, Volume 1. Polymer Matrix Composites
Guideline for Characterization of Structural Materials,” SAE International,
CMH-17-1G, Mar. 2012.
}
