% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\name{as.tbl_cube}
\alias{as.tbl_cube}
\alias{as.tbl_cube.array}
\alias{as.tbl_cube.table}
\alias{as.tbl_cube.matrix}
\alias{as.tbl_cube.data.frame}
\title{Coerce an existing data structure into a \code{tbl_cube}}
\usage{
as.tbl_cube(x, ...)

\method{as.tbl_cube}{array}(
  x,
  dim_names = names(dimnames(x)),
  met_name = deparse(substitute(x)),
  ...
)

\method{as.tbl_cube}{table}(x, dim_names = names(dimnames(x)), met_name = "Freq", ...)

\method{as.tbl_cube}{matrix}(
  x,
  dim_names = names(dimnames(x)),
  met_name = deparse(substitute(x)),
  ...
)

\method{as.tbl_cube}{data.frame}(x, dim_names = NULL, met_name = guess_met(x), ...)
}
\arguments{
\item{x}{an object to convert. Built in methods will convert arrays,
tables and data frames.}

\item{...}{Passed on to individual methods; otherwise ignored.}

\item{dim_names}{names of the dimensions. Defaults to the names of
the \code{\link[=dimnames]{dimnames()}}.}

\item{met_name}{a string to use as the name for the measure.}
}
\value{
A \code{tbl_cube}.
}
\description{
Coerce an existing data structure into a \code{tbl_cube}
}
