% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revdep.R
\name{revdep}
\alias{revdep}
\alias{revdep_maintainers}
\title{Reverse dependency tools.}
\usage{
revdep(
  pkg,
  dependencies = c("Depends", "Imports", "Suggests", "LinkingTo"),
  recursive = FALSE,
  ignore = NULL,
  bioconductor = FALSE
)

revdep_maintainers(pkg = ".")
}
\arguments{
\item{pkg}{Package name. This is unlike most devtools packages which
take a path because you might want to determine dependencies for a package
that you don't have installed. If omitted, defaults to the name of the
current package.}

\item{dependencies}{A character vector listing the types of dependencies
to follow.}

\item{recursive}{If \code{TRUE} look for full set of recursive dependencies.}

\item{ignore}{A character vector of package names to ignore. These packages
will not appear in returned vector.}

\item{bioconductor}{If \code{TRUE} also look for dependencies amongst
Bioconductor packages.}
}
\description{
Tools to check and notify maintainers of all CRAN and Bioconductor
packages that depend on the specified package.
}
\details{
The first run in a session will be time-consuming because it must download
all package metadata from CRAN and Bioconductor. Subsequent runs will
be faster.
}
\examples{
\dontrun{
revdep("ggplot2")

revdep("ggplot2", ignore = c("xkcd", "zoo"))
}
}
\seealso{
The \href{https://github.com/r-lib/revdepcheck}{revdepcheck} package can
be used to run R CMD check on all reverse dependencies.
}
