% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataLoader.R
\docType{class}
\name{DataLoader}
\alias{DataLoader}
\title{R6 class for Loading Fitbit data}
\format{A \code{\link{R6Class}} generator object}
\usage{
DataLoader
}
\description{
DataLoader is an R6 Class that connects to the Fitbit API with the  credentials, requests the data, and writes the response to JSON files,
}
\section{Methods}{

\describe{
  \item{\code{connect(appname, key, secret, cache.file)}}{This method connects to the Fitbit API and to your application. 
  \cr \code{appname}: Name of the Fitbit App
  \cr \code{key}: Fitbit API Client key
  \cr \code{secret}: Fibit API Client secret
  \cr \code{cache.file}: Path to a cached token file, instead of providing credentials in the function call}
  \item{\code{request(type = "day", activities = "", start.date = Sys.Date(), end.date = "", path = "./json/"))}}{This method builds the request URLs, sends the requests and writes response to JSON files, in the specified folder.
  \cr \code{type}: Type of time series. Must be 'day' or 'intraday'.
  \cr \code{activities}: A list of the Fitibit activities to be retrieved.
  \cr \code{start.date}: Start date in format YYYY-mm-dd.
  \cr \code{end.date}: End date in format YYYY-mm-dd.
  \cr \code{path}: Folder where the JSON files will be written.}
}
}
\examples{
\dontrun{
testObject <- DataLoader$new()

testObject$connect(appname = "abcd",
                   key = "123ABC",
                   secret = "3089e3h1ac9dde0aa67b54ajc8691j44")

testObject$request(
    type = 'day', 
    activities = list("calories", "steps", "distance", "minutesVeryActive"), 
    start.date = "2016-01-01", 
    end.date = "2016-02-01", 
    path = "~/fitbit-daily/")
}
}
\keyword{data}

