% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto_smooth.R
\name{pareto_khat}
\alias{pareto_khat}
\alias{pareto_khat.default}
\alias{pareto_khat.rvar}
\title{Pareto khat diagnostic}
\usage{
pareto_khat(x, ...)

\method{pareto_khat}{default}(
  x,
  tail = c("both", "right", "left"),
  r_eff = NULL,
  ndraws_tail = NULL,
  verbose = FALSE,
  are_log_weights = FALSE,
  ...
)

\method{pareto_khat}{rvar}(x, ...)
}
\arguments{
\item{x}{(multiple options) One of:
\itemize{
\item A matrix of draws for a single variable (iterations x chains). See
\code{\link[=extract_variable_matrix]{extract_variable_matrix()}}.
\item An \code{\link{rvar}}.
}}

\item{...}{Arguments passed to individual methods (if applicable).}

\item{tail}{(string) The tail to diagnose/smooth:
\itemize{
\item \code{"right"}: diagnose/smooth only the right (upper) tail
\item \code{"left"}: diagnose/smooth only the left (lower) tail
\item \code{"both"}: diagnose/smooth both tails and return the maximum k-hat value
}

The default is \code{"both"}.}

\item{r_eff}{(numeric) relative effective sample size estimate. If
\code{r_eff} is NULL, it will be calculated assuming the draws are
from MCMC. Default is NULL.}

\item{ndraws_tail}{(numeric) number of draws for the tail. If
\code{ndraws_tail} is not specified, it will be calculated as
ceiling(3 * sqrt(length(x) / r_eff)) if length(x) > 225 and
length(x) / 5 otherwise (see Appendix H in Vehtari et
al. (2024)).}

\item{verbose}{(logical) Should diagnostic messages be printed? If
\code{TRUE}, messages related to Pareto diagnostics will be
printed. Default is \code{FALSE}.}

\item{are_log_weights}{(logical) Are the draws log weights? Default is
\code{FALSE}. If \code{TRUE} computation will take into account that the
draws are log weights, and only right tail will be smoothed.}
}
\value{
If the input is an array, returns a single numeric value. If any of the draws
is non-finite, that is, \code{NA}, \code{NaN}, \code{Inf}, or \code{-Inf}, the returned output
will be (numeric) \code{NA}. Also, if all draws within any of the chains of a
variable are the same (constant), the returned output will be (numeric) \code{NA}
as well. The reason for the latter is that, for constant draws, we cannot
distinguish between variables that are supposed to be constant (e.g., a
diagonal element of a correlation matrix is always 1) or variables that just
happened to be constant because of a failure of convergence or other problems
in the sampling process.

If the input is an \code{\link{rvar}}, returns an array of the same dimensions as the
\code{\link{rvar}}, where each element is equal to the value that would be returned by
passing the draws array for that element of the \code{\link{rvar}} to this function.
}
\description{
Estimate Pareto k value by fitting a Generalized Pareto
Distribution to one or two tails of x. This can be used to estimate
the number of fractional moments that is useful for convergence
diagnostics. For further details see Vehtari et al. (2024).
}
\examples{
mu <- extract_variable_matrix(example_draws(), "mu")
pareto_khat(mu)

d <- as_draws_rvars(example_draws("multi_normal"))
pareto_khat(d$Sigma)
}
\references{
Aki Vehtari, Daniel Simpson, Andrew Gelman, Yuling Yao and
Jonah Gabry (2024). Pareto Smoothed Importance Sampling.
\emph{Journal of Machine Learning Research}, 25(72):1-58.
\href{https://jmlr.org/papers/v25/19-556.html}{PDF}
}
\seealso{
\code{\link{pareto_diags}} for additional related diagnostics, and
\code{\link{pareto_smooth}} for Pareto smoothed draws.

Other diagnostics: 
\code{\link{ess_basic}()},
\code{\link{ess_bulk}()},
\code{\link{ess_quantile}()},
\code{\link{ess_sd}()},
\code{\link{ess_tail}()},
\code{\link{mcse_mean}()},
\code{\link{mcse_quantile}()},
\code{\link{mcse_sd}()},
\code{\link{pareto_diags}()},
\code{\link{rhat}()},
\code{\link{rhat_basic}()},
\code{\link{rhat_nested}()},
\code{\link{rstar}()}
}
\concept{diagnostics}
