% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relu.R
\name{step_relu}
\alias{step_relu}
\title{Apply (Smoothed) Rectified Linear Transformation}
\usage{
step_relu(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  shift = 0,
  reverse = FALSE,
  smooth = FALSE,
  prefix = "right_relu_",
  columns = NULL,
  skip = FALSE,
  id = rand_id("relu")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{shift}{A numeric value dictating a translation to apply to the data.}

\item{reverse}{A logical to indicate if the left hinge should be used as
opposed to the right hinge.}

\item{smooth}{A logical indicating if the softplus function, a smooth
approximation to the rectified linear transformation, should be used.}

\item{prefix}{A prefix for generated column names, defaults to "right_relu_"
for right hinge transformation and "left_relu_" for reversed/left hinge
transformations.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_relu} creates a \emph{specification} of a recipe step that
will apply the rectified linear or softplus transformations to numeric
data. The transformed data is added as new columns to the data matrix.
}
\details{
The rectified linear transformation is calculated as
\deqn{max(0, x - c)} and is also known as the ReLu or right hinge function.
If \code{reverse} is true, then the transformation is reflected about the
y-axis, like so: \deqn{max(0, c - x)} Setting the \code{smooth} option
to true will instead calculate a smooth approximation to ReLu
according to \deqn{ln(1 + e^(x - c)} The \code{reverse} argument may
also be applied to this transformation.
}
\section{Connection to MARS}{


The rectified linear transformation is used in Multivariate Adaptive
Regression Splines as a basis function to fit piecewise linear functions to
data in a strategy similar to that employed in tree based models. The
transformation is a popular choice as an activation function in many
neural networks, which could then be seen as a stacked generalization of
MARS when making use of ReLu activations. The hinge function also appears
in the loss function of Support Vector Machines, where it penalizes
residuals only if they are within a certain margin of the decision boundary.
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(biomass, package = "modeldata")

biomass_tr <- biomass[biomass$dataset == "Training", ]
biomass_te <- biomass[biomass$dataset == "Testing", ]

rec <- recipe(
  HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
  data = biomass_tr
)

transformed_te <- rec \%>\%
  step_relu(carbon, shift = 40) \%>\%
  prep(biomass_tr) \%>\%
  bake(biomass_te)

transformed_te
\dontshow{\}) # examplesIf}
}
\seealso{
Other individual transformation steps: 
\code{\link{step_BoxCox}()},
\code{\link{step_YeoJohnson}()},
\code{\link{step_bs}()},
\code{\link{step_harmonic}()},
\code{\link{step_hyperbolic}()},
\code{\link{step_inverse}()},
\code{\link{step_invlogit}()},
\code{\link{step_logit}()},
\code{\link{step_log}()},
\code{\link{step_mutate}()},
\code{\link{step_ns}()},
\code{\link{step_percentile}()},
\code{\link{step_poly}()},
\code{\link{step_sqrt}()}
}
\concept{individual transformation steps}
