% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collate.R
\name{with_collate}
\alias{with_collate}
\alias{local_collate}
\title{Collation Order}
\usage{
with_collate(new, code)

local_collate(new = list(), .local_envir = parent.frame())
}
\arguments{
\item{new}{\verb{[character(1)]}\cr New collation order}

\item{code}{\code{[any]}\cr Code to execute in the temporary environment}

\item{.local_envir}{\verb{[environment]}\cr The environment to use for scoping.}
}
\value{
\code{[any]}\cr The results of the evaluation of the \code{code}
argument.
}
\description{
Temporarily change collation order by changing the value of the
\code{LC_COLLATE} locale.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{# Modify collation order:
x <- c("bernard", "bérénice", "béatrice", "boris")

with_collate("fr_FR", sort(x))
#> [1] "béatrice" "bérénice" "bernard"  "boris"   

with_collate("C", sort(x))
#> [1] "bernard"  "boris"    "béatrice" "bérénice"
}\if{html}{\out{</div>}}
}

\seealso{
\code{\link{withr}} for examples
}
