% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_xlsx.R
\name{write_xlsx}
\alias{write_xlsx}
\alias{writexl}
\title{Export to xlsx}
\usage{
write_xlsx(
  x,
  path = tempfile(fileext = ".xlsx"),
  col_names = TRUE,
  format_headers = TRUE,
  use_zip64 = FALSE
)
}
\arguments{
\item{x}{data frame or named list of data frames that will be sheets in the xlsx}

\item{path}{a file name to write to}

\item{col_names}{write column names at the top of the file?}

\item{format_headers}{make the \code{col_names} in the xlsx centered and bold}

\item{use_zip64}{use \href{https://en.wikipedia.org/wiki/Zip_(file_format)#ZIP64}{zip64}
to enable support for 4GB+ xlsx files. Not all platforms can read this.}
}
\description{
Writes a data frame to an xlsx file. To create an xlsx with (multiple) named
sheets, simply set \code{x} to a named list of data frames.
}
\details{
Currently supports strings, numbers, booleans and dates. Formatting options
may be added in future versions.

\if{html}{
\out{
<link rel="stylesheet" type="text/css" href="https://jeroen.github.io/clippy/clippy.min.css" media="all">
<script src="https://jeroen.github.io/clippy/bundle.js"></script>
}}
}
\examples{
# Roundtrip example with single excel sheet named 'mysheet'
tmp <- write_xlsx(list(mysheet = iris))
readxl::read_xlsx(tmp)
}
