RabbitMQ `3.12.11` is a maintenance release in the `3.12.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from the [3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0)
if upgrading from a version prior to 3.12.0.

This release requires Erlang 25 and supports Erlang versions up to `26.1.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.12.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.11.x (or older releases) on Erlang 25 to 3.12.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.12.x/release-notes).


### Core Broker

#### Bug Fixes

 * Quorum queue declared when one of cluster nodes was down could trigger
   connection exceptions.

   GitHub issue: [#10007](https://github.com/rabbitmq/rabbitmq-server/issues/10007)

 * Avoids a rare exception that could stop TCP socket writes on a client connection.

   GitHub issues: [#9991](https://github.com/rabbitmq/rabbitmq-server/issues/9991), [#9803](https://github.com/rabbitmq/rabbitmq-server/discussions/9803)

 * `queue_deleted` and `queue_created` [internal events](https://rabbitmq.com/logging.html#internal-events) now include queue type as a module name,
   and not an inconsistent (with the other queue and stream types) value `classic`.

   GitHub issue: [#10142](https://github.com/rabbitmq/rabbitmq-server/pull/10142)

#### Enhancements

 * Definition files that are virtual host-specific cannot be imported on boot. Such files will now be
   detected early and the import process will terminate after logging a more informative message.

   Previously the import process would run into an obscure exception.

   GitHub issues: [#10068](https://github.com/rabbitmq/rabbitmq-server/issues/10068), [#10085](https://github.com/rabbitmq/rabbitmq-server/pull/10085)


### AMQP 1.0 Plugin

#### Bug Fixes

 * Several AMQP 1.0 application properties are now more correctly converted
   to AMQP 0-9-1 headers by cross-protocol Shovels.

   The priority property now populates an AMQP 1.0 header with the same name,
   per AMQP 1.0 spec.

   This is a **potentially breaking change**.

   Contributed by @luos (Erlang Solutions).

   GitHub issues: [#10037](https://github.com/rabbitmq/rabbitmq-server/pull/10037), [#7508](https://github.com/rabbitmq/rabbitmq-server/issues/7508)


### Prometheus Plugin

#### Enhancements

 * Metric label values now escape certain non-ASCII characters.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#10196](https://github.com/rabbitmq/rabbitmq-server/pull/10196)


### MQTT Plugin

#### Bug Fixes
               
 * Avoids an exception when an MQTT client that used a QoS 0 subscription reconnects
   and its original connection node is down.

   GitHub issue: [#10205](https://github.com/rabbitmq/rabbitmq-server/pull/10205)

 * Avoids an exception when an MQTT client connection was force-closed via the HTTP API.

   GitHub issue: [#10140](https://github.com/rabbitmq/rabbitmq-server/pull/10140)


### CLI Tools

#### Bug Fixes

 * Certain CLI commands could not be run in a shell script loop, unless the script explicitly
    redirected standard input.

   GitHub issue: [#10131](https://github.com/rabbitmq/rabbitmq-server/pull/10131)

#### Enhancements

 * `rabbitmq-diagnostics cluster_status` now responds much quicker when a cluster node
   has gone down, were shut down, or otherwise has become unreachable by the rest of the cluster.

   GitHub issue: [#10126](https://github.com/rabbitmq/rabbitmq-server/pull/10126)


### Management Plugin

#### Bug Fixes

 * Reverted a change to `DELETE /api/queues/{vhost}/{name}` that allowed removal of
   exclusive queues and introduced unexpected side effects.

   GitHub issue: [#10178](https://github.com/rabbitmq/rabbitmq-server/pull/10178)

 * `DELETE /api/policies/{vhost}/{policy}` returned a 500 response instead of a 404 one
   when target virtual host did not exist.

   GitHub issue: [#9983](https://github.com/rabbitmq/rabbitmq-server/issues/9983)

 * Avoid log noise when an HTTP API request is issued against a booting
   or very freshly booted node.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#10187](https://github.com/rabbitmq/rabbitmq-server/pull/10187)

#### Enhancements

 * HTTP API endpoints that involves contacting multiple nodes now respond much quicker when a cluster node
   has gone down, were shut down, or otherwise has become unreachable by the rest of the cluster
                                                             
   GitHub issue: [#10123](https://github.com/rabbitmq/rabbitmq-server/pull/10123)

 * Definition exported for just one virtual host cannot be imported at node boot time.
   Now such files are detected early with a clear log message and immediate node boot process termination.

   GitHub issues: [#10068](https://github.com/rabbitmq/rabbitmq-server/issues/10068), [#10072](https://github.com/rabbitmq/rabbitmq-server/pull/10072)


### AWS Peer Discovery Plugin

#### Enhancements

 * Type spec and test corrections.
                        
   Contributed by @illotum (AWS).

   GitHub issue: [#10134](https://github.com/rabbitmq/rabbitmq-server/pull/10134)


## Dependency Upgrades

 * `osiris` was updated to [`1.7.2`](https://github.com/rabbitmq/osiris/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.12.11.tar.xz`
instead of the source tarball produced by GitHub.
