// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Accessible;
use crate::AccessibleRole;
use crate::Align;
use crate::Application;
use crate::Buildable;
use crate::ConstraintTarget;
use crate::LayoutManager;
use crate::Native;
use crate::Overflow;
use crate::Root;
use crate::ShortcutManager;
use crate::Widget;
use crate::WindowGroup;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectExt;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkWindow")]
    pub struct Window(Object<ffi::GtkWindow, ffi::GtkWindowClass>) @extends Widget, @implements Accessible, Buildable, ConstraintTarget, Native, Root, ShortcutManager;

    match fn {
        type_ => || ffi::gtk_window_get_type(),
    }
}

impl Window {
    #[doc(alias = "gtk_window_new")]
    pub fn new() -> Window {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_window_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Window`] objects.
    ///
    /// This method returns an instance of [`WindowBuilder`] which can be used to create [`Window`] objects.
    pub fn builder() -> WindowBuilder {
        WindowBuilder::default()
    }

    #[doc(alias = "gtk_window_get_default_icon_name")]
    #[doc(alias = "get_default_icon_name")]
    pub fn default_icon_name() -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_window_get_default_icon_name()) }
    }

    #[doc(alias = "gtk_window_get_toplevels")]
    #[doc(alias = "get_toplevels")]
    pub fn toplevels() -> gio::ListModel {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_window_get_toplevels()) }
    }

    #[doc(alias = "gtk_window_list_toplevels")]
    pub fn list_toplevels() -> Vec<Widget> {
        assert_initialized_main_thread!();
        unsafe { FromGlibPtrContainer::from_glib_container(ffi::gtk_window_list_toplevels()) }
    }

    #[doc(alias = "gtk_window_set_auto_startup_notification")]
    pub fn set_auto_startup_notification(setting: bool) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_window_set_auto_startup_notification(setting.into_glib());
        }
    }

    #[doc(alias = "gtk_window_set_default_icon_name")]
    pub fn set_default_icon_name(name: &str) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_window_set_default_icon_name(name.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_window_set_interactive_debugging")]
    pub fn set_interactive_debugging(enable: bool) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_window_set_interactive_debugging(enable.into_glib());
        }
    }
}

impl Default for Window {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Window`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct WindowBuilder {
    application: Option<Application>,
    child: Option<Widget>,
    decorated: Option<bool>,
    default_height: Option<i32>,
    default_widget: Option<Widget>,
    default_width: Option<i32>,
    deletable: Option<bool>,
    destroy_with_parent: Option<bool>,
    display: Option<gdk::Display>,
    focus_visible: Option<bool>,
    focus_widget: Option<Widget>,
    fullscreened: Option<bool>,
    #[cfg(any(feature = "v4_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_2")))]
    handle_menubar_accel: Option<bool>,
    hide_on_close: Option<bool>,
    icon_name: Option<String>,
    maximized: Option<bool>,
    mnemonics_visible: Option<bool>,
    modal: Option<bool>,
    resizable: Option<bool>,
    startup_id: Option<String>,
    title: Option<String>,
    transient_for: Option<Window>,
    can_focus: Option<bool>,
    can_target: Option<bool>,
    css_classes: Option<Vec<String>>,
    css_name: Option<String>,
    cursor: Option<gdk::Cursor>,
    focus_on_click: Option<bool>,
    focusable: Option<bool>,
    halign: Option<Align>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    layout_manager: Option<LayoutManager>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    opacity: Option<f64>,
    overflow: Option<Overflow>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    accessible_role: Option<AccessibleRole>,
}

impl WindowBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`WindowBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Window`].
    pub fn build(self) -> Window {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref application) = self.application {
            properties.push(("application", application));
        }
        if let Some(ref child) = self.child {
            properties.push(("child", child));
        }
        if let Some(ref decorated) = self.decorated {
            properties.push(("decorated", decorated));
        }
        if let Some(ref default_height) = self.default_height {
            properties.push(("default-height", default_height));
        }
        if let Some(ref default_widget) = self.default_widget {
            properties.push(("default-widget", default_widget));
        }
        if let Some(ref default_width) = self.default_width {
            properties.push(("default-width", default_width));
        }
        if let Some(ref deletable) = self.deletable {
            properties.push(("deletable", deletable));
        }
        if let Some(ref destroy_with_parent) = self.destroy_with_parent {
            properties.push(("destroy-with-parent", destroy_with_parent));
        }
        if let Some(ref display) = self.display {
            properties.push(("display", display));
        }
        if let Some(ref focus_visible) = self.focus_visible {
            properties.push(("focus-visible", focus_visible));
        }
        if let Some(ref focus_widget) = self.focus_widget {
            properties.push(("focus-widget", focus_widget));
        }
        if let Some(ref fullscreened) = self.fullscreened {
            properties.push(("fullscreened", fullscreened));
        }
        #[cfg(any(feature = "v4_2", feature = "dox"))]
        if let Some(ref handle_menubar_accel) = self.handle_menubar_accel {
            properties.push(("handle-menubar-accel", handle_menubar_accel));
        }
        if let Some(ref hide_on_close) = self.hide_on_close {
            properties.push(("hide-on-close", hide_on_close));
        }
        if let Some(ref icon_name) = self.icon_name {
            properties.push(("icon-name", icon_name));
        }
        if let Some(ref maximized) = self.maximized {
            properties.push(("maximized", maximized));
        }
        if let Some(ref mnemonics_visible) = self.mnemonics_visible {
            properties.push(("mnemonics-visible", mnemonics_visible));
        }
        if let Some(ref modal) = self.modal {
            properties.push(("modal", modal));
        }
        if let Some(ref resizable) = self.resizable {
            properties.push(("resizable", resizable));
        }
        if let Some(ref startup_id) = self.startup_id {
            properties.push(("startup-id", startup_id));
        }
        if let Some(ref title) = self.title {
            properties.push(("title", title));
        }
        if let Some(ref transient_for) = self.transient_for {
            properties.push(("transient-for", transient_for));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref can_target) = self.can_target {
            properties.push(("can-target", can_target));
        }
        if let Some(ref css_classes) = self.css_classes {
            properties.push(("css-classes", css_classes));
        }
        if let Some(ref css_name) = self.css_name {
            properties.push(("css-name", css_name));
        }
        if let Some(ref cursor) = self.cursor {
            properties.push(("cursor", cursor));
        }
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref focusable) = self.focusable {
            properties.push(("focusable", focusable));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref layout_manager) = self.layout_manager {
            properties.push(("layout-manager", layout_manager));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref overflow) = self.overflow {
            properties.push(("overflow", overflow));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        if let Some(ref accessible_role) = self.accessible_role {
            properties.push(("accessible-role", accessible_role));
        }
        glib::Object::new::<Window>(&properties).expect("Failed to create an instance of Window")
    }

    pub fn application(mut self, application: &impl IsA<Application>) -> Self {
        self.application = Some(application.clone().upcast());
        self
    }

    pub fn child(mut self, child: &impl IsA<Widget>) -> Self {
        self.child = Some(child.clone().upcast());
        self
    }

    pub fn decorated(mut self, decorated: bool) -> Self {
        self.decorated = Some(decorated);
        self
    }

    pub fn default_height(mut self, default_height: i32) -> Self {
        self.default_height = Some(default_height);
        self
    }

    pub fn default_widget(mut self, default_widget: &impl IsA<Widget>) -> Self {
        self.default_widget = Some(default_widget.clone().upcast());
        self
    }

    pub fn default_width(mut self, default_width: i32) -> Self {
        self.default_width = Some(default_width);
        self
    }

    pub fn deletable(mut self, deletable: bool) -> Self {
        self.deletable = Some(deletable);
        self
    }

    pub fn destroy_with_parent(mut self, destroy_with_parent: bool) -> Self {
        self.destroy_with_parent = Some(destroy_with_parent);
        self
    }

    pub fn display(mut self, display: &impl IsA<gdk::Display>) -> Self {
        self.display = Some(display.clone().upcast());
        self
    }

    pub fn focus_visible(mut self, focus_visible: bool) -> Self {
        self.focus_visible = Some(focus_visible);
        self
    }

    pub fn focus_widget(mut self, focus_widget: &impl IsA<Widget>) -> Self {
        self.focus_widget = Some(focus_widget.clone().upcast());
        self
    }

    pub fn fullscreened(mut self, fullscreened: bool) -> Self {
        self.fullscreened = Some(fullscreened);
        self
    }

    #[cfg(any(feature = "v4_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_2")))]
    pub fn handle_menubar_accel(mut self, handle_menubar_accel: bool) -> Self {
        self.handle_menubar_accel = Some(handle_menubar_accel);
        self
    }

    pub fn hide_on_close(mut self, hide_on_close: bool) -> Self {
        self.hide_on_close = Some(hide_on_close);
        self
    }

    pub fn icon_name(mut self, icon_name: &str) -> Self {
        self.icon_name = Some(icon_name.to_string());
        self
    }

    pub fn maximized(mut self, maximized: bool) -> Self {
        self.maximized = Some(maximized);
        self
    }

    pub fn mnemonics_visible(mut self, mnemonics_visible: bool) -> Self {
        self.mnemonics_visible = Some(mnemonics_visible);
        self
    }

    pub fn modal(mut self, modal: bool) -> Self {
        self.modal = Some(modal);
        self
    }

    pub fn resizable(mut self, resizable: bool) -> Self {
        self.resizable = Some(resizable);
        self
    }

    pub fn startup_id(mut self, startup_id: &str) -> Self {
        self.startup_id = Some(startup_id.to_string());
        self
    }

    pub fn title(mut self, title: &str) -> Self {
        self.title = Some(title.to_string());
        self
    }

    pub fn transient_for(mut self, transient_for: &impl IsA<Window>) -> Self {
        self.transient_for = Some(transient_for.clone().upcast());
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn can_target(mut self, can_target: bool) -> Self {
        self.can_target = Some(can_target);
        self
    }

    pub fn css_classes(mut self, css_classes: Vec<String>) -> Self {
        self.css_classes = Some(css_classes);
        self
    }

    pub fn css_name(mut self, css_name: &str) -> Self {
        self.css_name = Some(css_name.to_string());
        self
    }

    pub fn cursor(mut self, cursor: &gdk::Cursor) -> Self {
        self.cursor = Some(cursor.clone());
        self
    }

    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn focusable(mut self, focusable: bool) -> Self {
        self.focusable = Some(focusable);
        self
    }

    pub fn halign(mut self, halign: Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn layout_manager(mut self, layout_manager: &impl IsA<LayoutManager>) -> Self {
        self.layout_manager = Some(layout_manager.clone().upcast());
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn overflow(mut self, overflow: Overflow) -> Self {
        self.overflow = Some(overflow);
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }

    pub fn accessible_role(mut self, accessible_role: AccessibleRole) -> Self {
        self.accessible_role = Some(accessible_role);
        self
    }
}

pub const NONE_WINDOW: Option<&Window> = None;

pub trait GtkWindowExt: 'static {
    #[doc(alias = "gtk_window_close")]
    fn close(&self);

    #[doc(alias = "gtk_window_destroy")]
    fn destroy(&self);

    #[doc(alias = "gtk_window_fullscreen")]
    fn fullscreen(&self);

    #[doc(alias = "gtk_window_fullscreen_on_monitor")]
    fn fullscreen_on_monitor(&self, monitor: &gdk::Monitor);

    #[doc(alias = "gtk_window_get_application")]
    #[doc(alias = "get_application")]
    fn application(&self) -> Option<Application>;

    #[doc(alias = "gtk_window_get_child")]
    #[doc(alias = "get_child")]
    fn child(&self) -> Option<Widget>;

    #[doc(alias = "gtk_window_get_decorated")]
    #[doc(alias = "get_decorated")]
    fn is_decorated(&self) -> bool;

    #[doc(alias = "gtk_window_get_default_size")]
    #[doc(alias = "get_default_size")]
    fn default_size(&self) -> (i32, i32);

    #[doc(alias = "gtk_window_get_default_widget")]
    #[doc(alias = "get_default_widget")]
    fn default_widget(&self) -> Option<Widget>;

    #[doc(alias = "gtk_window_get_deletable")]
    #[doc(alias = "get_deletable")]
    fn is_deletable(&self) -> bool;

    #[doc(alias = "gtk_window_get_destroy_with_parent")]
    #[doc(alias = "get_destroy_with_parent")]
    fn must_destroy_with_parent(&self) -> bool;

    #[doc(alias = "gtk_window_get_focus_visible")]
    #[doc(alias = "get_focus_visible")]
    fn gets_focus_visible(&self) -> bool;

    #[doc(alias = "gtk_window_get_group")]
    #[doc(alias = "get_group")]
    fn group(&self) -> WindowGroup;

    #[cfg(any(feature = "v4_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_2")))]
    #[doc(alias = "gtk_window_get_handle_menubar_accel")]
    #[doc(alias = "get_handle_menubar_accel")]
    fn is_handle_menubar_accel(&self) -> bool;

    #[doc(alias = "gtk_window_get_hide_on_close")]
    #[doc(alias = "get_hide_on_close")]
    fn hides_on_close(&self) -> bool;

    #[doc(alias = "gtk_window_get_icon_name")]
    #[doc(alias = "get_icon_name")]
    fn icon_name(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_window_get_mnemonics_visible")]
    #[doc(alias = "get_mnemonics_visible")]
    fn is_mnemonics_visible(&self) -> bool;

    #[doc(alias = "gtk_window_get_modal")]
    #[doc(alias = "get_modal")]
    fn is_modal(&self) -> bool;

    #[doc(alias = "gtk_window_get_resizable")]
    #[doc(alias = "get_resizable")]
    fn is_resizable(&self) -> bool;

    #[doc(alias = "gtk_window_get_title")]
    #[doc(alias = "get_title")]
    fn title(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_window_get_titlebar")]
    #[doc(alias = "get_titlebar")]
    fn titlebar(&self) -> Option<Widget>;

    #[doc(alias = "gtk_window_get_transient_for")]
    #[doc(alias = "get_transient_for")]
    fn transient_for(&self) -> Option<Window>;

    #[doc(alias = "gtk_window_has_group")]
    fn has_group(&self) -> bool;

    #[doc(alias = "gtk_window_is_active")]
    fn is_active(&self) -> bool;

    #[doc(alias = "gtk_window_is_fullscreen")]
    fn is_fullscreen(&self) -> bool;

    #[doc(alias = "gtk_window_is_maximized")]
    fn is_maximized(&self) -> bool;

    #[doc(alias = "gtk_window_maximize")]
    fn maximize(&self);

    #[doc(alias = "gtk_window_minimize")]
    fn minimize(&self);

    #[doc(alias = "gtk_window_present")]
    fn present(&self);

    #[doc(alias = "gtk_window_present_with_time")]
    fn present_with_time(&self, timestamp: u32);

    #[doc(alias = "gtk_window_set_application")]
    fn set_application(&self, application: Option<&impl IsA<Application>>);

    #[doc(alias = "gtk_window_set_child")]
    fn set_child(&self, child: Option<&impl IsA<Widget>>);

    #[doc(alias = "gtk_window_set_decorated")]
    fn set_decorated(&self, setting: bool);

    #[doc(alias = "gtk_window_set_default_size")]
    fn set_default_size(&self, width: i32, height: i32);

    #[doc(alias = "gtk_window_set_default_widget")]
    fn set_default_widget(&self, default_widget: Option<&impl IsA<Widget>>);

    #[doc(alias = "gtk_window_set_deletable")]
    fn set_deletable(&self, setting: bool);

    #[doc(alias = "gtk_window_set_destroy_with_parent")]
    fn set_destroy_with_parent(&self, setting: bool);

    #[doc(alias = "gtk_window_set_display")]
    fn set_display(&self, display: &impl IsA<gdk::Display>);

    #[doc(alias = "gtk_window_set_focus_visible")]
    fn set_focus_visible(&self, setting: bool);

    #[cfg(any(feature = "v4_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_2")))]
    #[doc(alias = "gtk_window_set_handle_menubar_accel")]
    fn set_handle_menubar_accel(&self, handle_menubar_accel: bool);

    #[doc(alias = "gtk_window_set_hide_on_close")]
    fn set_hide_on_close(&self, setting: bool);

    #[doc(alias = "gtk_window_set_icon_name")]
    fn set_icon_name(&self, name: Option<&str>);

    #[doc(alias = "gtk_window_set_mnemonics_visible")]
    fn set_mnemonics_visible(&self, setting: bool);

    #[doc(alias = "gtk_window_set_modal")]
    fn set_modal(&self, modal: bool);

    #[doc(alias = "gtk_window_set_resizable")]
    fn set_resizable(&self, resizable: bool);

    #[doc(alias = "gtk_window_set_startup_id")]
    fn set_startup_id(&self, startup_id: &str);

    #[doc(alias = "gtk_window_set_title")]
    fn set_title(&self, title: Option<&str>);

    #[doc(alias = "gtk_window_set_titlebar")]
    fn set_titlebar(&self, titlebar: Option<&impl IsA<Widget>>);

    #[doc(alias = "gtk_window_set_transient_for")]
    fn set_transient_for(&self, parent: Option<&impl IsA<Window>>);

    #[doc(alias = "gtk_window_unfullscreen")]
    fn unfullscreen(&self);

    #[doc(alias = "gtk_window_unmaximize")]
    fn unmaximize(&self);

    #[doc(alias = "gtk_window_unminimize")]
    fn unminimize(&self);

    #[doc(alias = "default-height")]
    fn default_height(&self) -> i32;

    #[doc(alias = "default-height")]
    fn set_default_height(&self, default_height: i32);

    #[doc(alias = "default-width")]
    fn default_width(&self) -> i32;

    #[doc(alias = "default-width")]
    fn set_default_width(&self, default_width: i32);

    #[doc(alias = "focus-widget")]
    fn focus_widget(&self) -> Option<Widget>;

    #[doc(alias = "focus-widget")]
    fn set_focus_widget<P: IsA<Widget>>(&self, focus_widget: Option<&P>);

    fn is_fullscreened(&self) -> bool;

    fn set_fullscreened(&self, fullscreened: bool);

    fn set_maximized(&self, maximized: bool);

    #[doc(alias = "activate-default")]
    fn connect_activate_default<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_activate_default(&self);

    #[doc(alias = "activate-focus")]
    fn connect_activate_focus<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_activate_focus(&self);

    #[doc(alias = "close-request")]
    fn connect_close_request<F: Fn(&Self) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "enable-debugging")]
    fn connect_enable_debugging<F: Fn(&Self, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_enable_debugging(&self, toggle: bool) -> bool;

    #[doc(alias = "keys-changed")]
    fn connect_keys_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "application")]
    fn connect_application_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "child")]
    fn connect_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "decorated")]
    fn connect_decorated_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "default-height")]
    fn connect_default_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "default-widget")]
    fn connect_default_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "default-width")]
    fn connect_default_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "deletable")]
    fn connect_deletable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "destroy-with-parent")]
    fn connect_destroy_with_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "display")]
    fn connect_display_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "focus-visible")]
    fn connect_focus_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "focus-widget")]
    fn connect_focus_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "fullscreened")]
    fn connect_fullscreened_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v4_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_2")))]
    #[doc(alias = "handle-menubar-accel")]
    fn connect_handle_menubar_accel_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "hide-on-close")]
    fn connect_hide_on_close_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "icon-name")]
    fn connect_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "is-active")]
    fn connect_is_active_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "maximized")]
    fn connect_maximized_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "mnemonics-visible")]
    fn connect_mnemonics_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "modal")]
    fn connect_modal_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "resizable")]
    fn connect_resizable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "startup-id")]
    fn connect_startup_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "title")]
    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "transient-for")]
    fn connect_transient_for_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Window>> GtkWindowExt for O {
    fn close(&self) {
        unsafe {
            ffi::gtk_window_close(self.as_ref().to_glib_none().0);
        }
    }

    fn destroy(&self) {
        unsafe {
            ffi::gtk_window_destroy(self.as_ref().to_glib_none().0);
        }
    }

    fn fullscreen(&self) {
        unsafe {
            ffi::gtk_window_fullscreen(self.as_ref().to_glib_none().0);
        }
    }

    fn fullscreen_on_monitor(&self, monitor: &gdk::Monitor) {
        unsafe {
            ffi::gtk_window_fullscreen_on_monitor(
                self.as_ref().to_glib_none().0,
                monitor.to_glib_none().0,
            );
        }
    }

    fn application(&self) -> Option<Application> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_application(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn child(&self) -> Option<Widget> {
        unsafe { from_glib_none(ffi::gtk_window_get_child(self.as_ref().to_glib_none().0)) }
    }

    fn is_decorated(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_decorated(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn default_size(&self) -> (i32, i32) {
        unsafe {
            let mut width = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            ffi::gtk_window_get_default_size(
                self.as_ref().to_glib_none().0,
                width.as_mut_ptr(),
                height.as_mut_ptr(),
            );
            let width = width.assume_init();
            let height = height.assume_init();
            (width, height)
        }
    }

    fn default_widget(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_default_widget(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_deletable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_deletable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn must_destroy_with_parent(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_destroy_with_parent(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn gets_focus_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_focus_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn group(&self) -> WindowGroup {
        unsafe { from_glib_none(ffi::gtk_window_get_group(self.as_ref().to_glib_none().0)) }
    }

    #[cfg(any(feature = "v4_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_2")))]
    fn is_handle_menubar_accel(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_handle_menubar_accel(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn hides_on_close(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_hide_on_close(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn icon_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_icon_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_mnemonics_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_mnemonics_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_modal(&self) -> bool {
        unsafe { from_glib(ffi::gtk_window_get_modal(self.as_ref().to_glib_none().0)) }
    }

    fn is_resizable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_resizable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn title(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gtk_window_get_title(self.as_ref().to_glib_none().0)) }
    }

    fn titlebar(&self) -> Option<Widget> {
        unsafe { from_glib_none(ffi::gtk_window_get_titlebar(self.as_ref().to_glib_none().0)) }
    }

    fn transient_for(&self) -> Option<Window> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_transient_for(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn has_group(&self) -> bool {
        unsafe { from_glib(ffi::gtk_window_has_group(self.as_ref().to_glib_none().0)) }
    }

    fn is_active(&self) -> bool {
        unsafe { from_glib(ffi::gtk_window_is_active(self.as_ref().to_glib_none().0)) }
    }

    fn is_fullscreen(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_is_fullscreen(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_maximized(&self) -> bool {
        unsafe { from_glib(ffi::gtk_window_is_maximized(self.as_ref().to_glib_none().0)) }
    }

    fn maximize(&self) {
        unsafe {
            ffi::gtk_window_maximize(self.as_ref().to_glib_none().0);
        }
    }

    fn minimize(&self) {
        unsafe {
            ffi::gtk_window_minimize(self.as_ref().to_glib_none().0);
        }
    }

    fn present(&self) {
        unsafe {
            ffi::gtk_window_present(self.as_ref().to_glib_none().0);
        }
    }

    fn present_with_time(&self, timestamp: u32) {
        unsafe {
            ffi::gtk_window_present_with_time(self.as_ref().to_glib_none().0, timestamp);
        }
    }

    fn set_application(&self, application: Option<&impl IsA<Application>>) {
        unsafe {
            ffi::gtk_window_set_application(
                self.as_ref().to_glib_none().0,
                application.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_child(&self, child: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_window_set_child(
                self.as_ref().to_glib_none().0,
                child.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_decorated(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_decorated(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    fn set_default_size(&self, width: i32, height: i32) {
        unsafe {
            ffi::gtk_window_set_default_size(self.as_ref().to_glib_none().0, width, height);
        }
    }

    fn set_default_widget(&self, default_widget: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_window_set_default_widget(
                self.as_ref().to_glib_none().0,
                default_widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_deletable(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_deletable(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    fn set_destroy_with_parent(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_destroy_with_parent(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    fn set_display(&self, display: &impl IsA<gdk::Display>) {
        unsafe {
            ffi::gtk_window_set_display(
                self.as_ref().to_glib_none().0,
                display.as_ref().to_glib_none().0,
            );
        }
    }

    fn set_focus_visible(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_focus_visible(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    #[cfg(any(feature = "v4_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_2")))]
    fn set_handle_menubar_accel(&self, handle_menubar_accel: bool) {
        unsafe {
            ffi::gtk_window_set_handle_menubar_accel(
                self.as_ref().to_glib_none().0,
                handle_menubar_accel.into_glib(),
            );
        }
    }

    fn set_hide_on_close(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_hide_on_close(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    fn set_icon_name(&self, name: Option<&str>) {
        unsafe {
            ffi::gtk_window_set_icon_name(self.as_ref().to_glib_none().0, name.to_glib_none().0);
        }
    }

    fn set_mnemonics_visible(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_mnemonics_visible(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    fn set_modal(&self, modal: bool) {
        unsafe {
            ffi::gtk_window_set_modal(self.as_ref().to_glib_none().0, modal.into_glib());
        }
    }

    fn set_resizable(&self, resizable: bool) {
        unsafe {
            ffi::gtk_window_set_resizable(self.as_ref().to_glib_none().0, resizable.into_glib());
        }
    }

    fn set_startup_id(&self, startup_id: &str) {
        unsafe {
            ffi::gtk_window_set_startup_id(
                self.as_ref().to_glib_none().0,
                startup_id.to_glib_none().0,
            );
        }
    }

    fn set_title(&self, title: Option<&str>) {
        unsafe {
            ffi::gtk_window_set_title(self.as_ref().to_glib_none().0, title.to_glib_none().0);
        }
    }

    fn set_titlebar(&self, titlebar: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_window_set_titlebar(
                self.as_ref().to_glib_none().0,
                titlebar.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_transient_for(&self, parent: Option<&impl IsA<Window>>) {
        unsafe {
            ffi::gtk_window_set_transient_for(
                self.as_ref().to_glib_none().0,
                parent.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn unfullscreen(&self) {
        unsafe {
            ffi::gtk_window_unfullscreen(self.as_ref().to_glib_none().0);
        }
    }

    fn unmaximize(&self) {
        unsafe {
            ffi::gtk_window_unmaximize(self.as_ref().to_glib_none().0);
        }
    }

    fn unminimize(&self) {
        unsafe {
            ffi::gtk_window_unminimize(self.as_ref().to_glib_none().0);
        }
    }

    fn default_height(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"default-height\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `default-height` getter")
        }
    }

    fn set_default_height(&self, default_height: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"default-height\0".as_ptr() as *const _,
                default_height.to_value().to_glib_none().0,
            );
        }
    }

    fn default_width(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"default-width\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `default-width` getter")
        }
    }

    fn set_default_width(&self, default_width: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"default-width\0".as_ptr() as *const _,
                default_width.to_value().to_glib_none().0,
            );
        }
    }

    fn focus_widget(&self) -> Option<Widget> {
        unsafe {
            let mut value = glib::Value::from_type(<Widget as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"focus-widget\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `focus-widget` getter")
        }
    }

    fn set_focus_widget<P: IsA<Widget>>(&self, focus_widget: Option<&P>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"focus-widget\0".as_ptr() as *const _,
                focus_widget.to_value().to_glib_none().0,
            );
        }
    }

    fn is_fullscreened(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"fullscreened\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `fullscreened` getter")
        }
    }

    fn set_fullscreened(&self, fullscreened: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"fullscreened\0".as_ptr() as *const _,
                fullscreened.to_value().to_glib_none().0,
            );
        }
    }

    fn set_maximized(&self, maximized: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"maximized\0".as_ptr() as *const _,
                maximized.to_value().to_glib_none().0,
            );
        }
    }

    fn connect_activate_default<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activate_default_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-default\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    activate_default_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_activate_default(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("activate-default", &[])
                .unwrap()
        };
    }

    fn connect_activate_focus<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activate_focus_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    activate_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_activate_focus(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("activate-focus", &[])
                .unwrap()
        };
    }

    fn connect_close_request<F: Fn(&Self) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn close_request_trampoline<
            P: IsA<Window>,
            F: Fn(&P) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkWindow,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"close-request\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    close_request_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_enable_debugging<F: Fn(&Self, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn enable_debugging_trampoline<
            P: IsA<Window>,
            F: Fn(&P, bool) -> bool + 'static,
        >(
            this: *mut ffi::GtkWindow,
            toggle: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Window::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(toggle),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"enable-debugging\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    enable_debugging_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_enable_debugging(&self, toggle: bool) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("enable-debugging", &[&toggle])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_enable_debugging`")
    }

    fn connect_keys_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn keys_changed_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"keys-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    keys_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_application_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_application_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::application\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_application_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_child_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_child_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_decorated_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_decorated_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::decorated\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_decorated_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_default_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_height_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_default_height_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_default_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_widget_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-widget\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_default_widget_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_default_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_width_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_default_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_deletable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_deletable_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::deletable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_deletable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_destroy_with_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_destroy_with_parent_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::destroy-with-parent\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_destroy_with_parent_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_display_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_display_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::display\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_display_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_focus_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_focus_visible_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::focus-visible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_focus_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_focus_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_focus_widget_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::focus-widget\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_focus_widget_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_fullscreened_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fullscreened_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fullscreened\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_fullscreened_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v4_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_2")))]
    fn connect_handle_menubar_accel_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_handle_menubar_accel_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::handle-menubar-accel\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_handle_menubar_accel_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_hide_on_close_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hide_on_close_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hide-on-close\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hide_on_close_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_name_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::icon-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_icon_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_is_active_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_active_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::is-active\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_is_active_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_maximized_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_maximized_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::maximized\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_maximized_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_mnemonics_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_mnemonics_visible_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::mnemonics-visible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_mnemonics_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_modal_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_modal_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::modal\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_modal_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_resizable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_resizable_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::resizable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_resizable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_startup_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_startup_id_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::startup-id\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_startup_id_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<P: IsA<Window>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::title\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_title_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_transient_for_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_transient_for_trampoline<
            P: IsA<Window>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::transient-for\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_transient_for_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Window {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Window")
    }
}
