[vset VERSION 1.0.5]
[manpage_begin ripemd160 n [vset VERSION]]
[see_also md4]
[see_also md5]
[see_also ripemd128]
[see_also sha1]
[keywords hashing]
[keywords md4]
[keywords message-digest]
[keywords {rfc 1320}]
[keywords {rfc 1321}]
[keywords {rfc 2104}]
[keywords RIPEMD]
[keywords security]
[moddesc   {RIPEMD Message-Digest Algorithm}]
[copyright {2004, Pat Thoyts <patthoyts@users.sourceforge.net>}]
[titledesc {RIPEMD-160 Message-Digest Algorithm}]
[category  {Hashes, checksums, and encryption}]
[require Tcl 8.2]
[require ripemd160 [opt [vset VERSION]]]
[description]
[para]

This package is an implementation in Tcl of the RIPEMD-160 message-digest
algorithm (1). This algorithm takes an arbitrary quantity of data and
generates a 160-bit message digest from the input. The RIPEMD-160
algorithm is based upon the MD4 algorithm (2, 4) but has been
cryptographically strengthened against weaknesses that have been found
in MD4 (4).

[para]

This package will use [package cryptkit] or [package Trf] to
accelerate the digest computation if either package is available. In
the absence of an accelerator package the pure-Tcl implementation will
be used.

[section {COMMANDS}]

[list_begin definitions]

[call [cmd "::ripemd::ripemd160"] \
        [opt "[arg -hex]"] \
        [lb] [arg "-channel channel"] | \
        [arg "-file filename"] | [arg "string"] [rb]]

Calculate the RIPEMD-160 digest of the data given in string. This is
returned as a binary string by default. Giving the [arg "-hex"] option
will return a hexadecimal encoded version of the digest.

[para]

The data to be hashed can be specified either as a string argument to
the ripemd160 command, or as a filename or a pre-opened channel. If the
[arg "-filename"] argument is given then the file is opened, the data read
and hashed and the file is closed. If the [arg "-channel"] argument is
given then data is read from the channel until the end of file. The
channel is not closed.

[para]

Only one of [arg "-file"], [arg "-channel"] or [arg "string"] should be given.

[call [cmd "::ripemd::hmac160"] \
        [opt "[arg -hex]"] \
        [arg "-key key"]  \
        [lb] [arg "-channel channel"] | \
        [arg "-file filename"] | [arg "string"] [rb]]

Calculate an Hashed Message Authentication digest (HMAC) using the
RIPEMD-160 digest algorithm. HMACs are described in RFC 2104 (5) and
provide a RIPEMD-160 digest that includes a key. All options other
than [arg -key] are as for the [cmd "::ripemd::ripemd160"] command.

[list_end]

[section {PROGRAMMING INTERFACE}]

For the programmer, hash functions can be viewed as a bucket into which
one pours data. When you have finished, you extract a value that is
uniquely derived from the data that was poured into the bucket. The
programming interface to the hash operates on a token (equivalent to the
bucket). You call [cmd RIPEMD160Init] to obtain a token and then call
[cmd RIPEMD160Update] as many times as required to add data to the hash. To
release any resources and obtain the hash value, you then call
[cmd RIPEMD160Final]. An equivalent set of functions gives you a keyed
digest (HMAC).

[list_begin definitions]

[call [cmd "::ripemd::RIPEMD160Init"]]

Begins a new RIPEMD-160 hash. Returns a token ID that must be used for the
remaining functions.

[call [cmd "::ripemd::RIPEMD160Update"] [arg "token"] [arg "data"]]

Add data to the hash identified by token. Calling
[emph {RIPEMD160Update $token "abcd"}] is equivalent to calling
[emph {RIPEMD160Update $token "ab"}] followed by
[emph {RIPEMD160Update $token "cb"}]. See [sectref {EXAMPLES}].

[call [cmd "::ripemd::RIPEMD160Final"] [arg "token"]]

Returns the hash value and releases any resources held by this
token. Once this command completes the token will be invalid. The
result is a binary string of 16 bytes representing the 160 bit
RIPEMD-160 digest value.

[call [cmd "::ripemd::RIPEHMAC160Init"] [arg "key"]]

This is equivalent to the [cmd "::ripemd::RIPEMD160Init"] command
except that it requires the key that will be included in the HMAC.

[call [cmd "::ripemd::RIPEHMAC160Update"] [arg "token"] [arg "data"]]
[call [cmd "::ripemd::RIPEHMAC160Final"] [arg "token"]]

These commands are identical to the RIPEMD160 equivalent commands.

[list_end]

[section {EXAMPLES}]

[example {
% ripemd::ripemd160 -hex "Tcl does RIPEMD-160"
0829dea75a1a7074c702896723fe37763481a0a7
}]

[example {
% ripemd::hmac160 -hex -key Sekret "Tcl does RIPEMD-160"
bf0c927231733686731dddb470b64a9c23f7f53b
}]

[example {
% set tok [ripemd::RIPEMD160Init]
::ripemd::1
% ripemd::RIPEMD160Update $tok "Tcl "
% ripemd::RIPEMD160Update $tok "does "
% ripemd::RIPEMD160Update $tok "RIPEMD-160"
% ripemd::Hex [ripemd::RIPEMD160Final $tok]
0829dea75a1a7074c702896723fe37763481a0a7
}]

[section {REFERENCES}]

[list_begin enumerated]

[enum]
        H. Dobbertin, A. Bosselaers, B. Preneel,
        "RIPEMD-160, a strengthened version of RIPEMD"
        [uri http://www.esat.kuleuven.ac.be/~cosicart/pdf/AB-9601/AB-9601.pdf]

[enum]
       Rivest, R., "The MD4 Message Digest Algorithm", RFC 1320, MIT,
       April 1992. ([uri http://www.rfc-editor.org/rfc/rfc1320.txt])

[enum]
       Rivest, R., "The MD4 message digest algorithm", in A.J.  Menezes
       and S.A. Vanstone, editors, Advances in Cryptology - CRYPTO '90
       Proceedings, pages 303-311, Springer-Verlag, 1991.

[enum]
        Dobbertin, H., "Cryptanalysis of MD4", Journal of Cryptology
        vol 11 (4), pp. 253-271 (1998)

[enum]
      Krawczyk, H., Bellare, M. and Canetti, R. "HMAC: Keyed-Hashing for
      Message Authentication", RFC 2104, February 1997.
	([uri http://www.rfc-editor.org/rfc/rfc2104.txt])

[list_end]

[vset CATEGORY ripemd]
[include ../common-text/feedback.inc]
[manpage_end]
