## TFSA-2019-002: Heap buffer overflow in `UnsortedSegmentSum`

### CVE Number

CVE-2019-16778

### Issue Description

A heap buffer overflow in `UnsortedSegmentSum` can be produced when the `Index`
template argument is `int32`. In this case `data_size` and `num_segments` fields
are truncated from `int64` to `int32` and can produce negative numbers,
resulting in accessing out of bounds heap memory.

### Impact

This is unlikely to be exploitable and was detected and fixed internally. We are
making the security advisory only to notify users that it is better to update to
TensorFlow 1.15 or 2.0 or later as these versions already have this fixed.

### Vulnerable Versions

TensorFlow 1.0.0, 1.0.1, 1.1.0, 1.2.0, 1.2.1, 1.3.0, 1.3.1, 1.4.0, 1.4.1, 1.5.0,
1.5.1, 1.6.0, 1.7.0, 1.7.1, 1.8.0, 1.9.0, 1.10.0, 1.10.1, 1.11.0, 1.12.0,
1.12.1, 1.12.2, 1.12.3, 1.13.0, 1.13.1, 1.13.2, 1.14.0.

### Mitigation

We have patched the vulnerability in GitHub commit
[db4f971](https://github.com/tensorflow/tensorflow/commit/db4f9717c41bccc3ce10099ab61996b246099892).

We encourage users to switch to TensorFlow 1.15 or 2.0 as these versions contain
the fix. If switching is undesirable, consider cherry-picking the above commit
and building from source.
