## TFSA-2022-046: `CHECK`-failures in binary ops due to type confusion

### CVE Number
CVE-2022-23583

### Impact
A malicious user can cause a denial of service by altering a `SavedModel` such that [any binary op](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/kernels/cwise_ops_common.h#L88-L137) would trigger `CHECK` failures. This occurs when the protobuf part corresponding to the tensor arguments is modified such that the `dtype` no longer matches the `dtype` expected by the op. In that case, calling the templated binary operator for the binary op would receive corrupted data, due to the type confusion involved:

```cc
functor::BinaryFunctor<Device, Functor, 1>()(
    eigen_device, out->template flat<Tout>(),
    input_0.template flat<Tin>(), input_1.template flat<Tin>(),
    error_ptr);
```

If `Tin` and `Tout` don't match the type of data in `out` and `input_*` tensors then `flat<*>` would interpret it wrongly. In most cases, this would be a silent failure, but we have noticed scenarios where this results in a `CHECK` crash, hence a denial of service.

### Patches
We have patched the issue in GitHub commit [a7c02f1a9bbc35473969618a09ee5f9f5d3e52d9](https://github.com/tensorflow/tensorflow/commit/a7c02f1a9bbc35473969618a09ee5f9f5d3e52d9).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
