## TFSA-2022-057: Multiple crashes, heap OOB accesses in TFG dialect (MLIR)

### CVE Number
CVE-2022-23594

### Impact
The [TFG dialect of TensorFlow (MLIR)](https://github.com/tensorflow/tensorflow/tree/274df9b02330b790aa8de1cee164b70f72b9b244/tensorflow/core/ir/importexport) makes several assumptions about the incoming `GraphDef` before converting it to the MLIR-based dialect.

If an attacker changes the `SavedModel` format on disk to invalidate these assumptions and the `GraphDef` is then converted to MLIR-based IR then they can cause a crash in the Python interpreter. Under certain scenarios, heap OOB read/writes are possible.

These issues have been discovered via fuzzing and it is possible that more weaknesses exist. We will patch them as they are discovered.

### Patches
We have patched the issue in multiple GitHub commits and these will be included in TensorFlow 2.8.0 and TensorFlow 2.7.1, as both are affected.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
