/*
 * @(#)Dino2dP.h
 *
 * Copyright 1995 - 2008  David A. Bagley, bagleyd AT verizon.net
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for Dino2d */

#ifndef _Dino2dP_h
#define _Dino2dP_h

#include "Dino2d.h"

#ifndef WINVER
/* This gets around C's inability to do inheritance */
typedef struct _Dino2DClassPart {
	int ignore;
} Dino2DClassPart;

typedef struct _Dino2DClassRec {
	CoreClassPart coreClass;
	DinoClassPart dinoClass;
	Dino2DClassPart dino2dClass;
} Dino2DClassRec;

extern Dino2DClassRec dino2dClassRec;
#endif

#define FRONT_LOC 0
#define BACK_LOC 11
#define COORD2D 8
#define MAXX 3
#define MAXY 4
#define MAXXY 4			/* (MAX(MAXX,MAXY)) */
#define MAX_RECT (MAXX*MAXY)

typedef struct _Dino2DPart {
	Position    diamondLength, triangleLength, triangleWidth;
	Position    faceLength;
	Position    viewLength;
} Dino2DPart;

typedef struct _Dino2DRec {
	CorePart    core;
	DinoPart    dino;
	Dino2DPart  dino2d;
} Dino2DRec;

extern Boolean selectPieces2D(Dino2DWidget w, int x, int y,
	int *face, int *position);
extern Boolean narrowSelection2D(Dino2DWidget w, int *face, int *direction);
extern void drawFrame2D(Dino2DWidget w, Boolean focus);
extern void drawTriangle2D(Dino2DWidget w, int face, int position, int offset);
#ifdef WINVER
extern void initializePuzzle2D(Dino2DWidget w);
extern void resizePuzzle2D(Dino2DWidget w);
extern void exposePuzzle2D(Dino2DWidget w);
#endif

#endif /* _Dino2dP_h */
