/* thumb2-sha256-asm
 *
 * Copyright (C) 2006-2023 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */

/* Generated using (from wolfssl):
 *   cd ../scripts
 *   ruby ./sha2/sha256.rb thumb2 ../wolfssl/wolfcrypt/src/port/arm/thumb2-sha256-asm.c
 */

#ifdef HAVE_CONFIG_H
    #include <config.h>
#endif /* HAVE_CONFIG_H */
#include <wolfssl/wolfcrypt/settings.h>

#ifdef WOLFSSL_ARMASM
#if !defined(__aarch64__) && defined(__thumb__)
#include <stdint.h>
#ifdef HAVE_CONFIG_H
    #include <config.h>
#endif /* HAVE_CONFIG_H */
#include <wolfssl/wolfcrypt/settings.h>
#ifdef WOLFSSL_ARMASM_INLINE

#ifdef WOLFSSL_ARMASM
#if !defined(__aarch64__) && defined(__thumb__)

#ifdef __IAR_SYSTEMS_ICC__
#define __asm__        asm
#define __volatile__   volatile
#define WOLFSSL_NO_VAR_ASSIGN_REG
#endif /* __IAR_SYSTEMS_ICC__ */
#ifdef __KEIL__
#define __asm__        __asm
#define __volatile__   volatile
#endif /* __KEIL__ */
#ifndef NO_SHA256
#include <wolfssl/wolfcrypt/sha256.h>

#ifdef WOLFSSL_ARMASM_NO_NEON
XALIGNED(16) static const uint32_t L_SHA256_transform_len_k[] = {
    0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5,
    0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
    0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3,
    0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
    0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc,
    0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
    0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7,
    0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
    0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13,
    0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
    0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3,
    0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
    0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5,
    0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
    0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208,
    0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2,
};

void Transform_Sha256_Len(wc_Sha256* sha256, const byte* data, word32 len);
#ifndef WOLFSSL_NO_VAR_ASSIGN_REG
void Transform_Sha256_Len(wc_Sha256* sha256_p, const byte* data_p, word32 len_p)
#else
void Transform_Sha256_Len(wc_Sha256* sha256, const byte* data, word32 len)
#endif /* !WOLFSSL_NO_VAR_ASSIGN_REG */
{
#ifndef WOLFSSL_NO_VAR_ASSIGN_REG
    register wc_Sha256* sha256 __asm__ ("r0") = (wc_Sha256*)sha256_p;
    register const byte* data __asm__ ("r1") = (const byte*)data_p;
    register word32 len __asm__ ("r2") = (word32)len_p;
    register uint32_t* L_SHA256_transform_len_k_c __asm__ ("r3") = (uint32_t*)&L_SHA256_transform_len_k;
#endif /* !WOLFSSL_NO_VAR_ASSIGN_REG */

    __asm__ __volatile__ (
        "SUB	sp, sp, #0xc0\n\t"
        "MOV	r3, %[L_SHA256_transform_len_k]\n\t"
        /* Copy digest to add in at end */
        "LDRD	r4, r5, [%[sha256]]\n\t"
        "LDRD	r6, r7, [%[sha256], #8]\n\t"
        "LDRD	r8, r9, [%[sha256], #16]\n\t"
        "LDRD	r10, r11, [%[sha256], #24]\n\t"
        "STRD	r4, r5, [sp, #64]\n\t"
        "STRD	r6, r7, [sp, #72]\n\t"
        "STRD	r8, r9, [sp, #80]\n\t"
        "STRD	r10, r11, [sp, #88]\n\t"
        /* Start of loop processing a block */
        "\n"
    "L_SHA256_transform_len_begin:\n\t"
        /* Load, Reverse and Store W - 64 bytes */
        "LDR	r4, [%[data]]\n\t"
        "LDR	r5, [%[data], #4]\n\t"
        "LDR	r6, [%[data], #8]\n\t"
        "LDR	r7, [%[data], #12]\n\t"
        "LDR	r8, [%[data], #16]\n\t"
        "LDR	r9, [%[data], #20]\n\t"
        "LDR	r10, [%[data], #24]\n\t"
        "LDR	r11, [%[data], #28]\n\t"
        "REV	r4, r4\n\t"
        "REV	r5, r5\n\t"
        "REV	r6, r6\n\t"
        "REV	r7, r7\n\t"
        "REV	r8, r8\n\t"
        "REV	r9, r9\n\t"
        "REV	r10, r10\n\t"
        "REV	r11, r11\n\t"
        "STRD	r4, r5, [sp]\n\t"
        "STRD	r6, r7, [sp, #8]\n\t"
        "STRD	r8, r9, [sp, #16]\n\t"
        "STRD	r10, r11, [sp, #24]\n\t"
        "LDR	r4, [%[data], #32]\n\t"
        "LDR	r5, [%[data], #36]\n\t"
        "LDR	r6, [%[data], #40]\n\t"
        "LDR	r7, [%[data], #44]\n\t"
        "LDR	r8, [%[data], #48]\n\t"
        "LDR	r9, [%[data], #52]\n\t"
        "LDR	r10, [%[data], #56]\n\t"
        "LDR	r11, [%[data], #60]\n\t"
        "REV	r4, r4\n\t"
        "REV	r5, r5\n\t"
        "REV	r6, r6\n\t"
        "REV	r7, r7\n\t"
        "REV	r8, r8\n\t"
        "REV	r9, r9\n\t"
        "REV	r10, r10\n\t"
        "REV	r11, r11\n\t"
        "STRD	r4, r5, [sp, #32]\n\t"
        "STRD	r6, r7, [sp, #40]\n\t"
        "STRD	r8, r9, [sp, #48]\n\t"
        "STRD	r10, r11, [sp, #56]\n\t"
        "LDR	r11, [%[sha256], #4]\n\t"
        "LDR	r4, [%[sha256], #8]\n\t"
        "EOR	r11, r11, r4\n\t"
        "MOV	r12, #0x3\n\t"
        /* Start of 16 rounds */
        "\n"
    "L_SHA256_transform_len_start:\n\t"
        /* Round 0 */
        "LDR	r5, [%[sha256], #16]\n\t"
        "LDR	r6, [%[sha256], #20]\n\t"
        "LDR	r7, [%[sha256], #24]\n\t"
        "LDR	r9, [%[sha256], #28]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp]\n\t"
        "LDR	r6, [r3]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256]]\n\t"
        "LDR	r6, [%[sha256], #4]\n\t"
        "LDR	r7, [%[sha256], #8]\n\t"
        "LDR	r8, [%[sha256], #12]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r10, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r11, r11, r10\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r11, r11, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r11\n\t"
        "STR	r8, [%[sha256], #12]\n\t"
        "STR	r9, [%[sha256], #28]\n\t"
        /* Calc new W[0] */
        "LDR	r6, [sp, #56]\n\t"
        "LDR	r7, [sp, #36]\n\t"
        "LDR	r8, [sp, #4]\n\t"
        "LDR	r9, [sp]\n\t"
        "ROR	r4, r6, #17\n\t"
        "ROR	r5, r8, #7\n\t"
        "EOR	r4, r4, r6, ROR #19\n\t"
        "EOR	r5, r5, r8, ROR #18\n\t"
        "EOR	r4, r4, r6, LSR #10\n\t"
        "EOR	r5, r5, r8, LSR #3\n\t"
        "ADD	r9, r9, r7\n\t"
        "ADD	r4, r4, r5\n\t"
        "ADD	r9, r9, r4\n\t"
        "STR	r9, [sp]\n\t"
        /* Round 1 */
        "LDR	r5, [%[sha256], #12]\n\t"
        "LDR	r6, [%[sha256], #16]\n\t"
        "LDR	r7, [%[sha256], #20]\n\t"
        "LDR	r9, [%[sha256], #24]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #4]\n\t"
        "LDR	r6, [r3, #4]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #28]\n\t"
        "LDR	r6, [%[sha256]]\n\t"
        "LDR	r7, [%[sha256], #4]\n\t"
        "LDR	r8, [%[sha256], #8]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r11, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r10, r10, r11\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r10, r10, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r10\n\t"
        "STR	r8, [%[sha256], #8]\n\t"
        "STR	r9, [%[sha256], #24]\n\t"
        /* Calc new W[1] */
        "LDR	r6, [sp, #60]\n\t"
        "LDR	r7, [sp, #40]\n\t"
        "LDR	r8, [sp, #8]\n\t"
        "LDR	r9, [sp, #4]\n\t"
        "ROR	r4, r6, #17\n\t"
        "ROR	r5, r8, #7\n\t"
        "EOR	r4, r4, r6, ROR #19\n\t"
        "EOR	r5, r5, r8, ROR #18\n\t"
        "EOR	r4, r4, r6, LSR #10\n\t"
        "EOR	r5, r5, r8, LSR #3\n\t"
        "ADD	r9, r9, r7\n\t"
        "ADD	r4, r4, r5\n\t"
        "ADD	r9, r9, r4\n\t"
        "STR	r9, [sp, #4]\n\t"
        /* Round 2 */
        "LDR	r5, [%[sha256], #8]\n\t"
        "LDR	r6, [%[sha256], #12]\n\t"
        "LDR	r7, [%[sha256], #16]\n\t"
        "LDR	r9, [%[sha256], #20]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #8]\n\t"
        "LDR	r6, [r3, #8]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #24]\n\t"
        "LDR	r6, [%[sha256], #28]\n\t"
        "LDR	r7, [%[sha256]]\n\t"
        "LDR	r8, [%[sha256], #4]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r10, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r11, r11, r10\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r11, r11, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r11\n\t"
        "STR	r8, [%[sha256], #4]\n\t"
        "STR	r9, [%[sha256], #20]\n\t"
        /* Calc new W[2] */
        "LDR	r6, [sp]\n\t"
        "LDR	r7, [sp, #44]\n\t"
        "LDR	r8, [sp, #12]\n\t"
        "LDR	r9, [sp, #8]\n\t"
        "ROR	r4, r6, #17\n\t"
        "ROR	r5, r8, #7\n\t"
        "EOR	r4, r4, r6, ROR #19\n\t"
        "EOR	r5, r5, r8, ROR #18\n\t"
        "EOR	r4, r4, r6, LSR #10\n\t"
        "EOR	r5, r5, r8, LSR #3\n\t"
        "ADD	r9, r9, r7\n\t"
        "ADD	r4, r4, r5\n\t"
        "ADD	r9, r9, r4\n\t"
        "STR	r9, [sp, #8]\n\t"
        /* Round 3 */
        "LDR	r5, [%[sha256], #4]\n\t"
        "LDR	r6, [%[sha256], #8]\n\t"
        "LDR	r7, [%[sha256], #12]\n\t"
        "LDR	r9, [%[sha256], #16]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #12]\n\t"
        "LDR	r6, [r3, #12]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #20]\n\t"
        "LDR	r6, [%[sha256], #24]\n\t"
        "LDR	r7, [%[sha256], #28]\n\t"
        "LDR	r8, [%[sha256]]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r11, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r10, r10, r11\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r10, r10, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r10\n\t"
        "STR	r8, [%[sha256]]\n\t"
        "STR	r9, [%[sha256], #16]\n\t"
        /* Calc new W[3] */
        "LDR	r6, [sp, #4]\n\t"
        "LDR	r7, [sp, #48]\n\t"
        "LDR	r8, [sp, #16]\n\t"
        "LDR	r9, [sp, #12]\n\t"
        "ROR	r4, r6, #17\n\t"
        "ROR	r5, r8, #7\n\t"
        "EOR	r4, r4, r6, ROR #19\n\t"
        "EOR	r5, r5, r8, ROR #18\n\t"
        "EOR	r4, r4, r6, LSR #10\n\t"
        "EOR	r5, r5, r8, LSR #3\n\t"
        "ADD	r9, r9, r7\n\t"
        "ADD	r4, r4, r5\n\t"
        "ADD	r9, r9, r4\n\t"
        "STR	r9, [sp, #12]\n\t"
        /* Round 4 */
        "LDR	r5, [%[sha256]]\n\t"
        "LDR	r6, [%[sha256], #4]\n\t"
        "LDR	r7, [%[sha256], #8]\n\t"
        "LDR	r9, [%[sha256], #12]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #16]\n\t"
        "LDR	r6, [r3, #16]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #16]\n\t"
        "LDR	r6, [%[sha256], #20]\n\t"
        "LDR	r7, [%[sha256], #24]\n\t"
        "LDR	r8, [%[sha256], #28]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r10, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r11, r11, r10\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r11, r11, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r11\n\t"
        "STR	r8, [%[sha256], #28]\n\t"
        "STR	r9, [%[sha256], #12]\n\t"
        /* Calc new W[4] */
        "LDR	r6, [sp, #8]\n\t"
        "LDR	r7, [sp, #52]\n\t"
        "LDR	r8, [sp, #20]\n\t"
        "LDR	r9, [sp, #16]\n\t"
        "ROR	r4, r6, #17\n\t"
        "ROR	r5, r8, #7\n\t"
        "EOR	r4, r4, r6, ROR #19\n\t"
        "EOR	r5, r5, r8, ROR #18\n\t"
        "EOR	r4, r4, r6, LSR #10\n\t"
        "EOR	r5, r5, r8, LSR #3\n\t"
        "ADD	r9, r9, r7\n\t"
        "ADD	r4, r4, r5\n\t"
        "ADD	r9, r9, r4\n\t"
        "STR	r9, [sp, #16]\n\t"
        /* Round 5 */
        "LDR	r5, [%[sha256], #28]\n\t"
        "LDR	r6, [%[sha256]]\n\t"
        "LDR	r7, [%[sha256], #4]\n\t"
        "LDR	r9, [%[sha256], #8]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #20]\n\t"
        "LDR	r6, [r3, #20]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #12]\n\t"
        "LDR	r6, [%[sha256], #16]\n\t"
        "LDR	r7, [%[sha256], #20]\n\t"
        "LDR	r8, [%[sha256], #24]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r11, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r10, r10, r11\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r10, r10, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r10\n\t"
        "STR	r8, [%[sha256], #24]\n\t"
        "STR	r9, [%[sha256], #8]\n\t"
        /* Calc new W[5] */
        "LDR	r6, [sp, #12]\n\t"
        "LDR	r7, [sp, #56]\n\t"
        "LDR	r8, [sp, #24]\n\t"
        "LDR	r9, [sp, #20]\n\t"
        "ROR	r4, r6, #17\n\t"
        "ROR	r5, r8, #7\n\t"
        "EOR	r4, r4, r6, ROR #19\n\t"
        "EOR	r5, r5, r8, ROR #18\n\t"
        "EOR	r4, r4, r6, LSR #10\n\t"
        "EOR	r5, r5, r8, LSR #3\n\t"
        "ADD	r9, r9, r7\n\t"
        "ADD	r4, r4, r5\n\t"
        "ADD	r9, r9, r4\n\t"
        "STR	r9, [sp, #20]\n\t"
        /* Round 6 */
        "LDR	r5, [%[sha256], #24]\n\t"
        "LDR	r6, [%[sha256], #28]\n\t"
        "LDR	r7, [%[sha256]]\n\t"
        "LDR	r9, [%[sha256], #4]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #24]\n\t"
        "LDR	r6, [r3, #24]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #8]\n\t"
        "LDR	r6, [%[sha256], #12]\n\t"
        "LDR	r7, [%[sha256], #16]\n\t"
        "LDR	r8, [%[sha256], #20]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r10, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r11, r11, r10\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r11, r11, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r11\n\t"
        "STR	r8, [%[sha256], #20]\n\t"
        "STR	r9, [%[sha256], #4]\n\t"
        /* Calc new W[6] */
        "LDR	r6, [sp, #16]\n\t"
        "LDR	r7, [sp, #60]\n\t"
        "LDR	r8, [sp, #28]\n\t"
        "LDR	r9, [sp, #24]\n\t"
        "ROR	r4, r6, #17\n\t"
        "ROR	r5, r8, #7\n\t"
        "EOR	r4, r4, r6, ROR #19\n\t"
        "EOR	r5, r5, r8, ROR #18\n\t"
        "EOR	r4, r4, r6, LSR #10\n\t"
        "EOR	r5, r5, r8, LSR #3\n\t"
        "ADD	r9, r9, r7\n\t"
        "ADD	r4, r4, r5\n\t"
        "ADD	r9, r9, r4\n\t"
        "STR	r9, [sp, #24]\n\t"
        /* Round 7 */
        "LDR	r5, [%[sha256], #20]\n\t"
        "LDR	r6, [%[sha256], #24]\n\t"
        "LDR	r7, [%[sha256], #28]\n\t"
        "LDR	r9, [%[sha256]]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #28]\n\t"
        "LDR	r6, [r3, #28]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #4]\n\t"
        "LDR	r6, [%[sha256], #8]\n\t"
        "LDR	r7, [%[sha256], #12]\n\t"
        "LDR	r8, [%[sha256], #16]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r11, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r10, r10, r11\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r10, r10, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r10\n\t"
        "STR	r8, [%[sha256], #16]\n\t"
        "STR	r9, [%[sha256]]\n\t"
        /* Calc new W[7] */
        "LDR	r6, [sp, #20]\n\t"
        "LDR	r7, [sp]\n\t"
        "LDR	r8, [sp, #32]\n\t"
        "LDR	r9, [sp, #28]\n\t"
        "ROR	r4, r6, #17\n\t"
        "ROR	r5, r8, #7\n\t"
        "EOR	r4, r4, r6, ROR #19\n\t"
        "EOR	r5, r5, r8, ROR #18\n\t"
        "EOR	r4, r4, r6, LSR #10\n\t"
        "EOR	r5, r5, r8, LSR #3\n\t"
        "ADD	r9, r9, r7\n\t"
        "ADD	r4, r4, r5\n\t"
        "ADD	r9, r9, r4\n\t"
        "STR	r9, [sp, #28]\n\t"
        /* Round 8 */
        "LDR	r5, [%[sha256], #16]\n\t"
        "LDR	r6, [%[sha256], #20]\n\t"
        "LDR	r7, [%[sha256], #24]\n\t"
        "LDR	r9, [%[sha256], #28]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #32]\n\t"
        "LDR	r6, [r3, #32]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256]]\n\t"
        "LDR	r6, [%[sha256], #4]\n\t"
        "LDR	r7, [%[sha256], #8]\n\t"
        "LDR	r8, [%[sha256], #12]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r10, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r11, r11, r10\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r11, r11, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r11\n\t"
        "STR	r8, [%[sha256], #12]\n\t"
        "STR	r9, [%[sha256], #28]\n\t"
        /* Calc new W[8] */
        "LDR	r6, [sp, #24]\n\t"
        "LDR	r7, [sp, #4]\n\t"
        "LDR	r8, [sp, #36]\n\t"
        "LDR	r9, [sp, #32]\n\t"
        "ROR	r4, r6, #17\n\t"
        "ROR	r5, r8, #7\n\t"
        "EOR	r4, r4, r6, ROR #19\n\t"
        "EOR	r5, r5, r8, ROR #18\n\t"
        "EOR	r4, r4, r6, LSR #10\n\t"
        "EOR	r5, r5, r8, LSR #3\n\t"
        "ADD	r9, r9, r7\n\t"
        "ADD	r4, r4, r5\n\t"
        "ADD	r9, r9, r4\n\t"
        "STR	r9, [sp, #32]\n\t"
        /* Round 9 */
        "LDR	r5, [%[sha256], #12]\n\t"
        "LDR	r6, [%[sha256], #16]\n\t"
        "LDR	r7, [%[sha256], #20]\n\t"
        "LDR	r9, [%[sha256], #24]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #36]\n\t"
        "LDR	r6, [r3, #36]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #28]\n\t"
        "LDR	r6, [%[sha256]]\n\t"
        "LDR	r7, [%[sha256], #4]\n\t"
        "LDR	r8, [%[sha256], #8]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r11, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r10, r10, r11\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r10, r10, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r10\n\t"
        "STR	r8, [%[sha256], #8]\n\t"
        "STR	r9, [%[sha256], #24]\n\t"
        /* Calc new W[9] */
        "LDR	r6, [sp, #28]\n\t"
        "LDR	r7, [sp, #8]\n\t"
        "LDR	r8, [sp, #40]\n\t"
        "LDR	r9, [sp, #36]\n\t"
        "ROR	r4, r6, #17\n\t"
        "ROR	r5, r8, #7\n\t"
        "EOR	r4, r4, r6, ROR #19\n\t"
        "EOR	r5, r5, r8, ROR #18\n\t"
        "EOR	r4, r4, r6, LSR #10\n\t"
        "EOR	r5, r5, r8, LSR #3\n\t"
        "ADD	r9, r9, r7\n\t"
        "ADD	r4, r4, r5\n\t"
        "ADD	r9, r9, r4\n\t"
        "STR	r9, [sp, #36]\n\t"
        /* Round 10 */
        "LDR	r5, [%[sha256], #8]\n\t"
        "LDR	r6, [%[sha256], #12]\n\t"
        "LDR	r7, [%[sha256], #16]\n\t"
        "LDR	r9, [%[sha256], #20]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #40]\n\t"
        "LDR	r6, [r3, #40]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #24]\n\t"
        "LDR	r6, [%[sha256], #28]\n\t"
        "LDR	r7, [%[sha256]]\n\t"
        "LDR	r8, [%[sha256], #4]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r10, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r11, r11, r10\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r11, r11, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r11\n\t"
        "STR	r8, [%[sha256], #4]\n\t"
        "STR	r9, [%[sha256], #20]\n\t"
        /* Calc new W[10] */
        "LDR	r6, [sp, #32]\n\t"
        "LDR	r7, [sp, #12]\n\t"
        "LDR	r8, [sp, #44]\n\t"
        "LDR	r9, [sp, #40]\n\t"
        "ROR	r4, r6, #17\n\t"
        "ROR	r5, r8, #7\n\t"
        "EOR	r4, r4, r6, ROR #19\n\t"
        "EOR	r5, r5, r8, ROR #18\n\t"
        "EOR	r4, r4, r6, LSR #10\n\t"
        "EOR	r5, r5, r8, LSR #3\n\t"
        "ADD	r9, r9, r7\n\t"
        "ADD	r4, r4, r5\n\t"
        "ADD	r9, r9, r4\n\t"
        "STR	r9, [sp, #40]\n\t"
        /* Round 11 */
        "LDR	r5, [%[sha256], #4]\n\t"
        "LDR	r6, [%[sha256], #8]\n\t"
        "LDR	r7, [%[sha256], #12]\n\t"
        "LDR	r9, [%[sha256], #16]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #44]\n\t"
        "LDR	r6, [r3, #44]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #20]\n\t"
        "LDR	r6, [%[sha256], #24]\n\t"
        "LDR	r7, [%[sha256], #28]\n\t"
        "LDR	r8, [%[sha256]]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r11, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r10, r10, r11\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r10, r10, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r10\n\t"
        "STR	r8, [%[sha256]]\n\t"
        "STR	r9, [%[sha256], #16]\n\t"
        /* Calc new W[11] */
        "LDR	r6, [sp, #36]\n\t"
        "LDR	r7, [sp, #16]\n\t"
        "LDR	r8, [sp, #48]\n\t"
        "LDR	r9, [sp, #44]\n\t"
        "ROR	r4, r6, #17\n\t"
        "ROR	r5, r8, #7\n\t"
        "EOR	r4, r4, r6, ROR #19\n\t"
        "EOR	r5, r5, r8, ROR #18\n\t"
        "EOR	r4, r4, r6, LSR #10\n\t"
        "EOR	r5, r5, r8, LSR #3\n\t"
        "ADD	r9, r9, r7\n\t"
        "ADD	r4, r4, r5\n\t"
        "ADD	r9, r9, r4\n\t"
        "STR	r9, [sp, #44]\n\t"
        /* Round 12 */
        "LDR	r5, [%[sha256]]\n\t"
        "LDR	r6, [%[sha256], #4]\n\t"
        "LDR	r7, [%[sha256], #8]\n\t"
        "LDR	r9, [%[sha256], #12]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #48]\n\t"
        "LDR	r6, [r3, #48]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #16]\n\t"
        "LDR	r6, [%[sha256], #20]\n\t"
        "LDR	r7, [%[sha256], #24]\n\t"
        "LDR	r8, [%[sha256], #28]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r10, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r11, r11, r10\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r11, r11, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r11\n\t"
        "STR	r8, [%[sha256], #28]\n\t"
        "STR	r9, [%[sha256], #12]\n\t"
        /* Calc new W[12] */
        "LDR	r6, [sp, #40]\n\t"
        "LDR	r7, [sp, #20]\n\t"
        "LDR	r8, [sp, #52]\n\t"
        "LDR	r9, [sp, #48]\n\t"
        "ROR	r4, r6, #17\n\t"
        "ROR	r5, r8, #7\n\t"
        "EOR	r4, r4, r6, ROR #19\n\t"
        "EOR	r5, r5, r8, ROR #18\n\t"
        "EOR	r4, r4, r6, LSR #10\n\t"
        "EOR	r5, r5, r8, LSR #3\n\t"
        "ADD	r9, r9, r7\n\t"
        "ADD	r4, r4, r5\n\t"
        "ADD	r9, r9, r4\n\t"
        "STR	r9, [sp, #48]\n\t"
        /* Round 13 */
        "LDR	r5, [%[sha256], #28]\n\t"
        "LDR	r6, [%[sha256]]\n\t"
        "LDR	r7, [%[sha256], #4]\n\t"
        "LDR	r9, [%[sha256], #8]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #52]\n\t"
        "LDR	r6, [r3, #52]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #12]\n\t"
        "LDR	r6, [%[sha256], #16]\n\t"
        "LDR	r7, [%[sha256], #20]\n\t"
        "LDR	r8, [%[sha256], #24]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r11, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r10, r10, r11\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r10, r10, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r10\n\t"
        "STR	r8, [%[sha256], #24]\n\t"
        "STR	r9, [%[sha256], #8]\n\t"
        /* Calc new W[13] */
        "LDR	r6, [sp, #44]\n\t"
        "LDR	r7, [sp, #24]\n\t"
        "LDR	r8, [sp, #56]\n\t"
        "LDR	r9, [sp, #52]\n\t"
        "ROR	r4, r6, #17\n\t"
        "ROR	r5, r8, #7\n\t"
        "EOR	r4, r4, r6, ROR #19\n\t"
        "EOR	r5, r5, r8, ROR #18\n\t"
        "EOR	r4, r4, r6, LSR #10\n\t"
        "EOR	r5, r5, r8, LSR #3\n\t"
        "ADD	r9, r9, r7\n\t"
        "ADD	r4, r4, r5\n\t"
        "ADD	r9, r9, r4\n\t"
        "STR	r9, [sp, #52]\n\t"
        /* Round 14 */
        "LDR	r5, [%[sha256], #24]\n\t"
        "LDR	r6, [%[sha256], #28]\n\t"
        "LDR	r7, [%[sha256]]\n\t"
        "LDR	r9, [%[sha256], #4]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #56]\n\t"
        "LDR	r6, [r3, #56]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #8]\n\t"
        "LDR	r6, [%[sha256], #12]\n\t"
        "LDR	r7, [%[sha256], #16]\n\t"
        "LDR	r8, [%[sha256], #20]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r10, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r11, r11, r10\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r11, r11, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r11\n\t"
        "STR	r8, [%[sha256], #20]\n\t"
        "STR	r9, [%[sha256], #4]\n\t"
        /* Calc new W[14] */
        "LDR	r6, [sp, #48]\n\t"
        "LDR	r7, [sp, #28]\n\t"
        "LDR	r8, [sp, #60]\n\t"
        "LDR	r9, [sp, #56]\n\t"
        "ROR	r4, r6, #17\n\t"
        "ROR	r5, r8, #7\n\t"
        "EOR	r4, r4, r6, ROR #19\n\t"
        "EOR	r5, r5, r8, ROR #18\n\t"
        "EOR	r4, r4, r6, LSR #10\n\t"
        "EOR	r5, r5, r8, LSR #3\n\t"
        "ADD	r9, r9, r7\n\t"
        "ADD	r4, r4, r5\n\t"
        "ADD	r9, r9, r4\n\t"
        "STR	r9, [sp, #56]\n\t"
        /* Round 15 */
        "LDR	r5, [%[sha256], #20]\n\t"
        "LDR	r6, [%[sha256], #24]\n\t"
        "LDR	r7, [%[sha256], #28]\n\t"
        "LDR	r9, [%[sha256]]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #60]\n\t"
        "LDR	r6, [r3, #60]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #4]\n\t"
        "LDR	r6, [%[sha256], #8]\n\t"
        "LDR	r7, [%[sha256], #12]\n\t"
        "LDR	r8, [%[sha256], #16]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r11, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r10, r10, r11\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r10, r10, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r10\n\t"
        "STR	r8, [%[sha256], #16]\n\t"
        "STR	r9, [%[sha256]]\n\t"
        /* Calc new W[15] */
        "LDR	r6, [sp, #52]\n\t"
        "LDR	r7, [sp, #32]\n\t"
        "LDR	r8, [sp]\n\t"
        "LDR	r9, [sp, #60]\n\t"
        "ROR	r4, r6, #17\n\t"
        "ROR	r5, r8, #7\n\t"
        "EOR	r4, r4, r6, ROR #19\n\t"
        "EOR	r5, r5, r8, ROR #18\n\t"
        "EOR	r4, r4, r6, LSR #10\n\t"
        "EOR	r5, r5, r8, LSR #3\n\t"
        "ADD	r9, r9, r7\n\t"
        "ADD	r4, r4, r5\n\t"
        "ADD	r9, r9, r4\n\t"
        "STR	r9, [sp, #60]\n\t"
        "ADD	r3, r3, #0x40\n\t"
        "SUBS	r12, r12, #0x1\n\t"
#ifdef __GNUC__
        "BNE	L_SHA256_transform_len_start\n\t"
#else
        "BNE.W	L_SHA256_transform_len_start\n\t"
#endif
        /* Round 0 */
        "LDR	r5, [%[sha256], #16]\n\t"
        "LDR	r6, [%[sha256], #20]\n\t"
        "LDR	r7, [%[sha256], #24]\n\t"
        "LDR	r9, [%[sha256], #28]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp]\n\t"
        "LDR	r6, [r3]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256]]\n\t"
        "LDR	r6, [%[sha256], #4]\n\t"
        "LDR	r7, [%[sha256], #8]\n\t"
        "LDR	r8, [%[sha256], #12]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r10, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r11, r11, r10\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r11, r11, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r11\n\t"
        "STR	r8, [%[sha256], #12]\n\t"
        "STR	r9, [%[sha256], #28]\n\t"
        /* Round 1 */
        "LDR	r5, [%[sha256], #12]\n\t"
        "LDR	r6, [%[sha256], #16]\n\t"
        "LDR	r7, [%[sha256], #20]\n\t"
        "LDR	r9, [%[sha256], #24]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #4]\n\t"
        "LDR	r6, [r3, #4]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #28]\n\t"
        "LDR	r6, [%[sha256]]\n\t"
        "LDR	r7, [%[sha256], #4]\n\t"
        "LDR	r8, [%[sha256], #8]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r11, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r10, r10, r11\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r10, r10, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r10\n\t"
        "STR	r8, [%[sha256], #8]\n\t"
        "STR	r9, [%[sha256], #24]\n\t"
        /* Round 2 */
        "LDR	r5, [%[sha256], #8]\n\t"
        "LDR	r6, [%[sha256], #12]\n\t"
        "LDR	r7, [%[sha256], #16]\n\t"
        "LDR	r9, [%[sha256], #20]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #8]\n\t"
        "LDR	r6, [r3, #8]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #24]\n\t"
        "LDR	r6, [%[sha256], #28]\n\t"
        "LDR	r7, [%[sha256]]\n\t"
        "LDR	r8, [%[sha256], #4]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r10, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r11, r11, r10\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r11, r11, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r11\n\t"
        "STR	r8, [%[sha256], #4]\n\t"
        "STR	r9, [%[sha256], #20]\n\t"
        /* Round 3 */
        "LDR	r5, [%[sha256], #4]\n\t"
        "LDR	r6, [%[sha256], #8]\n\t"
        "LDR	r7, [%[sha256], #12]\n\t"
        "LDR	r9, [%[sha256], #16]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #12]\n\t"
        "LDR	r6, [r3, #12]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #20]\n\t"
        "LDR	r6, [%[sha256], #24]\n\t"
        "LDR	r7, [%[sha256], #28]\n\t"
        "LDR	r8, [%[sha256]]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r11, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r10, r10, r11\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r10, r10, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r10\n\t"
        "STR	r8, [%[sha256]]\n\t"
        "STR	r9, [%[sha256], #16]\n\t"
        /* Round 4 */
        "LDR	r5, [%[sha256]]\n\t"
        "LDR	r6, [%[sha256], #4]\n\t"
        "LDR	r7, [%[sha256], #8]\n\t"
        "LDR	r9, [%[sha256], #12]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #16]\n\t"
        "LDR	r6, [r3, #16]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #16]\n\t"
        "LDR	r6, [%[sha256], #20]\n\t"
        "LDR	r7, [%[sha256], #24]\n\t"
        "LDR	r8, [%[sha256], #28]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r10, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r11, r11, r10\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r11, r11, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r11\n\t"
        "STR	r8, [%[sha256], #28]\n\t"
        "STR	r9, [%[sha256], #12]\n\t"
        /* Round 5 */
        "LDR	r5, [%[sha256], #28]\n\t"
        "LDR	r6, [%[sha256]]\n\t"
        "LDR	r7, [%[sha256], #4]\n\t"
        "LDR	r9, [%[sha256], #8]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #20]\n\t"
        "LDR	r6, [r3, #20]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #12]\n\t"
        "LDR	r6, [%[sha256], #16]\n\t"
        "LDR	r7, [%[sha256], #20]\n\t"
        "LDR	r8, [%[sha256], #24]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r11, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r10, r10, r11\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r10, r10, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r10\n\t"
        "STR	r8, [%[sha256], #24]\n\t"
        "STR	r9, [%[sha256], #8]\n\t"
        /* Round 6 */
        "LDR	r5, [%[sha256], #24]\n\t"
        "LDR	r6, [%[sha256], #28]\n\t"
        "LDR	r7, [%[sha256]]\n\t"
        "LDR	r9, [%[sha256], #4]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #24]\n\t"
        "LDR	r6, [r3, #24]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #8]\n\t"
        "LDR	r6, [%[sha256], #12]\n\t"
        "LDR	r7, [%[sha256], #16]\n\t"
        "LDR	r8, [%[sha256], #20]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r10, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r11, r11, r10\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r11, r11, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r11\n\t"
        "STR	r8, [%[sha256], #20]\n\t"
        "STR	r9, [%[sha256], #4]\n\t"
        /* Round 7 */
        "LDR	r5, [%[sha256], #20]\n\t"
        "LDR	r6, [%[sha256], #24]\n\t"
        "LDR	r7, [%[sha256], #28]\n\t"
        "LDR	r9, [%[sha256]]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #28]\n\t"
        "LDR	r6, [r3, #28]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #4]\n\t"
        "LDR	r6, [%[sha256], #8]\n\t"
        "LDR	r7, [%[sha256], #12]\n\t"
        "LDR	r8, [%[sha256], #16]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r11, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r10, r10, r11\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r10, r10, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r10\n\t"
        "STR	r8, [%[sha256], #16]\n\t"
        "STR	r9, [%[sha256]]\n\t"
        /* Round 8 */
        "LDR	r5, [%[sha256], #16]\n\t"
        "LDR	r6, [%[sha256], #20]\n\t"
        "LDR	r7, [%[sha256], #24]\n\t"
        "LDR	r9, [%[sha256], #28]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #32]\n\t"
        "LDR	r6, [r3, #32]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256]]\n\t"
        "LDR	r6, [%[sha256], #4]\n\t"
        "LDR	r7, [%[sha256], #8]\n\t"
        "LDR	r8, [%[sha256], #12]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r10, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r11, r11, r10\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r11, r11, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r11\n\t"
        "STR	r8, [%[sha256], #12]\n\t"
        "STR	r9, [%[sha256], #28]\n\t"
        /* Round 9 */
        "LDR	r5, [%[sha256], #12]\n\t"
        "LDR	r6, [%[sha256], #16]\n\t"
        "LDR	r7, [%[sha256], #20]\n\t"
        "LDR	r9, [%[sha256], #24]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #36]\n\t"
        "LDR	r6, [r3, #36]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #28]\n\t"
        "LDR	r6, [%[sha256]]\n\t"
        "LDR	r7, [%[sha256], #4]\n\t"
        "LDR	r8, [%[sha256], #8]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r11, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r10, r10, r11\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r10, r10, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r10\n\t"
        "STR	r8, [%[sha256], #8]\n\t"
        "STR	r9, [%[sha256], #24]\n\t"
        /* Round 10 */
        "LDR	r5, [%[sha256], #8]\n\t"
        "LDR	r6, [%[sha256], #12]\n\t"
        "LDR	r7, [%[sha256], #16]\n\t"
        "LDR	r9, [%[sha256], #20]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #40]\n\t"
        "LDR	r6, [r3, #40]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #24]\n\t"
        "LDR	r6, [%[sha256], #28]\n\t"
        "LDR	r7, [%[sha256]]\n\t"
        "LDR	r8, [%[sha256], #4]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r10, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r11, r11, r10\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r11, r11, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r11\n\t"
        "STR	r8, [%[sha256], #4]\n\t"
        "STR	r9, [%[sha256], #20]\n\t"
        /* Round 11 */
        "LDR	r5, [%[sha256], #4]\n\t"
        "LDR	r6, [%[sha256], #8]\n\t"
        "LDR	r7, [%[sha256], #12]\n\t"
        "LDR	r9, [%[sha256], #16]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #44]\n\t"
        "LDR	r6, [r3, #44]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #20]\n\t"
        "LDR	r6, [%[sha256], #24]\n\t"
        "LDR	r7, [%[sha256], #28]\n\t"
        "LDR	r8, [%[sha256]]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r11, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r10, r10, r11\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r10, r10, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r10\n\t"
        "STR	r8, [%[sha256]]\n\t"
        "STR	r9, [%[sha256], #16]\n\t"
        /* Round 12 */
        "LDR	r5, [%[sha256]]\n\t"
        "LDR	r6, [%[sha256], #4]\n\t"
        "LDR	r7, [%[sha256], #8]\n\t"
        "LDR	r9, [%[sha256], #12]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #48]\n\t"
        "LDR	r6, [r3, #48]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #16]\n\t"
        "LDR	r6, [%[sha256], #20]\n\t"
        "LDR	r7, [%[sha256], #24]\n\t"
        "LDR	r8, [%[sha256], #28]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r10, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r11, r11, r10\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r11, r11, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r11\n\t"
        "STR	r8, [%[sha256], #28]\n\t"
        "STR	r9, [%[sha256], #12]\n\t"
        /* Round 13 */
        "LDR	r5, [%[sha256], #28]\n\t"
        "LDR	r6, [%[sha256]]\n\t"
        "LDR	r7, [%[sha256], #4]\n\t"
        "LDR	r9, [%[sha256], #8]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #52]\n\t"
        "LDR	r6, [r3, #52]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #12]\n\t"
        "LDR	r6, [%[sha256], #16]\n\t"
        "LDR	r7, [%[sha256], #20]\n\t"
        "LDR	r8, [%[sha256], #24]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r11, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r10, r10, r11\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r10, r10, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r10\n\t"
        "STR	r8, [%[sha256], #24]\n\t"
        "STR	r9, [%[sha256], #8]\n\t"
        /* Round 14 */
        "LDR	r5, [%[sha256], #24]\n\t"
        "LDR	r6, [%[sha256], #28]\n\t"
        "LDR	r7, [%[sha256]]\n\t"
        "LDR	r9, [%[sha256], #4]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #56]\n\t"
        "LDR	r6, [r3, #56]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #8]\n\t"
        "LDR	r6, [%[sha256], #12]\n\t"
        "LDR	r7, [%[sha256], #16]\n\t"
        "LDR	r8, [%[sha256], #20]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r10, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r11, r11, r10\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r11, r11, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r11\n\t"
        "STR	r8, [%[sha256], #20]\n\t"
        "STR	r9, [%[sha256], #4]\n\t"
        /* Round 15 */
        "LDR	r5, [%[sha256], #20]\n\t"
        "LDR	r6, [%[sha256], #24]\n\t"
        "LDR	r7, [%[sha256], #28]\n\t"
        "LDR	r9, [%[sha256]]\n\t"
        "ROR	r4, r5, #6\n\t"
        "EOR	r6, r6, r7\n\t"
        "EOR	r4, r4, r5, ROR #11\n\t"
        "AND	r6, r6, r5\n\t"
        "EOR	r4, r4, r5, ROR #25\n\t"
        "EOR	r6, r6, r7\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [sp, #60]\n\t"
        "LDR	r6, [r3, #60]\n\t"
        "ADD	r9, r9, r5\n\t"
        "ADD	r9, r9, r6\n\t"
        "LDR	r5, [%[sha256], #4]\n\t"
        "LDR	r6, [%[sha256], #8]\n\t"
        "LDR	r7, [%[sha256], #12]\n\t"
        "LDR	r8, [%[sha256], #16]\n\t"
        "ROR	r4, r5, #2\n\t"
        "EOR	r11, r5, r6\n\t"
        "EOR	r4, r4, r5, ROR #13\n\t"
        "AND	r10, r10, r11\n\t"
        "EOR	r4, r4, r5, ROR #22\n\t"
        "EOR	r10, r10, r6\n\t"
        "ADD	r8, r8, r9\n\t"
        "ADD	r9, r9, r4\n\t"
        "ADD	r9, r9, r10\n\t"
        "STR	r8, [%[sha256], #16]\n\t"
        "STR	r9, [%[sha256]]\n\t"
        /* Add in digest from start */
        "LDRD	r4, r5, [%[sha256]]\n\t"
        "LDRD	r6, r7, [%[sha256], #8]\n\t"
        "LDRD	r8, r9, [sp, #64]\n\t"
        "LDRD	r10, r11, [sp, #72]\n\t"
        "ADD	r4, r4, r8\n\t"
        "ADD	r5, r5, r9\n\t"
        "ADD	r6, r6, r10\n\t"
        "ADD	r7, r7, r11\n\t"
        "STRD	r4, r5, [%[sha256]]\n\t"
        "STRD	r6, r7, [%[sha256], #8]\n\t"
        "STRD	r4, r5, [sp, #64]\n\t"
        "STRD	r6, r7, [sp, #72]\n\t"
        "LDRD	r4, r5, [%[sha256], #16]\n\t"
        "LDRD	r6, r7, [%[sha256], #24]\n\t"
        "LDRD	r8, r9, [sp, #80]\n\t"
        "LDRD	r10, r11, [sp, #88]\n\t"
        "ADD	r4, r4, r8\n\t"
        "ADD	r5, r5, r9\n\t"
        "ADD	r6, r6, r10\n\t"
        "ADD	r7, r7, r11\n\t"
        "STRD	r4, r5, [%[sha256], #16]\n\t"
        "STRD	r6, r7, [%[sha256], #24]\n\t"
        "STRD	r4, r5, [sp, #80]\n\t"
        "STRD	r6, r7, [sp, #88]\n\t"
        "SUBS	%[len], %[len], #0x40\n\t"
        "SUB	r3, r3, #0xc0\n\t"
        "ADD	%[data], %[data], #0x40\n\t"
#ifdef __GNUC__
        "BNE	L_SHA256_transform_len_begin\n\t"
#else
        "BNE.W	L_SHA256_transform_len_begin\n\t"
#endif
        "ADD	sp, sp, #0xc0\n\t"
#ifndef WOLFSSL_NO_VAR_ASSIGN_REG
        : [sha256] "+r" (sha256), [data] "+r" (data), [len] "+r" (len),
          [L_SHA256_transform_len_k] "+r" (L_SHA256_transform_len_k_c)
        :
        : "memory", "r4", "r5", "r6", "r7", "r8", "r9", "r10", "r11", "r12", "cc"
#else
        : [sha256] "+r" (sha256), [data] "+r" (data), [len] "+r" (len)
        : [L_SHA256_transform_len_k] "r" (L_SHA256_transform_len_k)
        : "memory", "r4", "r5", "r6", "r7", "r8", "r9", "r10", "r11", "r12", "cc"
#endif /* WOLFSSL_NO_VAR_ASSIGN_REG */
    );
}

#endif /* WOLFSSL_ARMASM_NO_NEON */
#endif /* !NO_SHA256 */
#endif /* !__aarch64__ && __thumb__ */
#endif /* WOLFSSL_ARMASM */
#endif /* !defined(__aarch64__) && defined(__thumb__) */
#endif /* WOLFSSL_ARMASM */

#endif /* WOLFSSL_ARMASM_INLINE */
