/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.util.Timer;
import java.util.concurrent.atomic.AtomicInteger;
import org.postgresql.core.Logger;

public class SharedTimer {
    private static AtomicInteger timerCount = new AtomicInteger(0);
    private Logger log;
    private volatile Timer timer = null;
    private AtomicInteger refCount = new AtomicInteger(0);

    public SharedTimer(Logger log) {
        this.log = log;
    }

    public int getRefCount() {
        return this.refCount.get();
    }

    public synchronized Timer getTimer() {
        if (this.timer == null) {
            int index = timerCount.incrementAndGet();
            this.timer = new Timer("PostgreSQL-JDBC-SharedTimer-" + index, true);
        }
        this.refCount.incrementAndGet();
        return this.timer;
    }

    public synchronized void releaseTimer() {
        int count = this.refCount.decrementAndGet();
        if (count > 0) {
            this.log.debug("Outstanding references still exist so not closing shared Timer");
        } else if (count == 0) {
            this.log.debug("No outstanding references to shared Timer, will cancel and close it");
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        } else {
            this.log.debug("releaseTimer() called too many times; there is probably a bug in the calling code");
            this.refCount.set(0);
        }
    }
}

