// SPDX-License-Identifier: GPL-2.0
/*
 * SH-X3 prototype CPU pinmux
 *
 * Copyright (C) 2010  Paul Mundt
 */
#include <linux/init.h>
#include <linux/kernel.h>
#include <cpu/shx3.h>

#include "sh_pfc.h"

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	PA7_DATA, PA6_DATA, PA5_DATA, PA4_DATA,
	PA3_DATA, PA2_DATA, PA1_DATA, PA0_DATA,
	PB7_DATA, PB6_DATA, PB5_DATA, PB4_DATA,
	PB3_DATA, PB2_DATA, PB1_DATA, PB0_DATA,
	PC7_DATA, PC6_DATA, PC5_DATA, PC4_DATA,
	PC3_DATA, PC2_DATA, PC1_DATA, PC0_DATA,
	PD7_DATA, PD6_DATA, PD5_DATA, PD4_DATA,
	PD3_DATA, PD2_DATA, PD1_DATA, PD0_DATA,
	PE7_DATA, PE6_DATA, PE5_DATA, PE4_DATA,
	PE3_DATA, PE2_DATA, PE1_DATA, PE0_DATA,
	PF7_DATA, PF6_DATA, PF5_DATA, PF4_DATA,
	PF3_DATA, PF2_DATA, PF1_DATA, PF0_DATA,
	PG7_DATA, PG6_DATA, PG5_DATA, PG4_DATA,
	PG3_DATA, PG2_DATA, PG1_DATA, PG0_DATA,

	PH5_DATA, PH4_DATA,
	PH3_DATA, PH2_DATA, PH1_DATA, PH0_DATA,
	PINMUX_DATA_END,

	PINMUX_INPUT_BEGIN,
	PA7_IN, PA6_IN, PA5_IN, PA4_IN,
	PA3_IN, PA2_IN, PA1_IN, PA0_IN,
	PB7_IN, PB6_IN, PB5_IN, PB4_IN,
	PB3_IN, PB2_IN, PB1_IN, PB0_IN,
	PC7_IN, PC6_IN, PC5_IN, PC4_IN,
	PC3_IN, PC2_IN, PC1_IN, PC0_IN,
	PD7_IN, PD6_IN, PD5_IN, PD4_IN,
	PD3_IN, PD2_IN, PD1_IN, PD0_IN,
	PE7_IN, PE6_IN, PE5_IN, PE4_IN,
	PE3_IN, PE2_IN, PE1_IN, PE0_IN,
	PF7_IN, PF6_IN, PF5_IN, PF4_IN,
	PF3_IN, PF2_IN, PF1_IN, PF0_IN,
	PG7_IN, PG6_IN, PG5_IN, PG4_IN,
	PG3_IN, PG2_IN, PG1_IN, PG0_IN,

	PH5_IN, PH4_IN,
	PH3_IN, PH2_IN, PH1_IN, PH0_IN,
	PINMUX_INPUT_END,

	PINMUX_OUTPUT_BEGIN,
	PA7_OUT, PA6_OUT, PA5_OUT, PA4_OUT,
	PA3_OUT, PA2_OUT, PA1_OUT, PA0_OUT,
	PB7_OUT, PB6_OUT, PB5_OUT, PB4_OUT,
	PB3_OUT, PB2_OUT, PB1_OUT, PB0_OUT,
	PC7_OUT, PC6_OUT, PC5_OUT, PC4_OUT,
	PC3_OUT, PC2_OUT, PC1_OUT, PC0_OUT,
	PD7_OUT, PD6_OUT, PD5_OUT, PD4_OUT,
	PD3_OUT, PD2_OUT, PD1_OUT, PD0_OUT,
	PE7_OUT, PE6_OUT, PE5_OUT, PE4_OUT,
	PE3_OUT, PE2_OUT, PE1_OUT, PE0_OUT,
	PF7_OUT, PF6_OUT, PF5_OUT, PF4_OUT,
	PF3_OUT, PF2_OUT, PF1_OUT, PF0_OUT,
	PG7_OUT, PG6_OUT, PG5_OUT, PG4_OUT,
	PG3_OUT, PG2_OUT, PG1_OUT, PG0_OUT,

	PH5_OUT, PH4_OUT,
	PH3_OUT, PH2_OUT, PH1_OUT, PH0_OUT,
	PINMUX_OUTPUT_END,

	PINMUX_FUNCTION_BEGIN,
	PA7_FN, PA6_FN, PA5_FN, PA4_FN,
	PA3_FN, PA2_FN, PA1_FN, PA0_FN,
	PB7_FN, PB6_FN, PB5_FN, PB4_FN,
	PB3_FN, PB2_FN, PB1_FN, PB0_FN,
	PC7_FN, PC6_FN, PC5_FN, PC4_FN,
	PC3_FN, PC2_FN, PC1_FN, PC0_FN,
	PD7_FN, PD6_FN, PD5_FN, PD4_FN,
	PD3_FN, PD2_FN, PD1_FN, PD0_FN,
	PE7_FN, PE6_FN, PE5_FN, PE4_FN,
	PE3_FN, PE2_FN, PE1_FN, PE0_FN,
	PF7_FN, PF6_FN, PF5_FN, PF4_FN,
	PF3_FN, PF2_FN, PF1_FN, PF0_FN,
	PG7_FN, PG6_FN, PG5_FN, PG4_FN,
	PG3_FN, PG2_FN, PG1_FN, PG0_FN,

	PH5_FN, PH4_FN,
	PH3_FN, PH2_FN, PH1_FN, PH0_FN,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,

	D31_MARK, D30_MARK, D29_MARK, D28_MARK, D27_MARK, D26_MARK,
	D25_MARK, D24_MARK, D23_MARK, D22_MARK, D21_MARK, D20_MARK,
	D19_MARK, D18_MARK, D17_MARK, D16_MARK,

	BACK_MARK, BREQ_MARK,
	WE3_MARK, WE2_MARK,
	CS6_MARK, CS5_MARK, CS4_MARK,
	CLKOUTENB_MARK,

	DACK3_MARK, DACK2_MARK, DACK1_MARK, DACK0_MARK,
	DREQ3_MARK, DREQ2_MARK, DREQ1_MARK, DREQ0_MARK,

	IRQ3_MARK, IRQ2_MARK, IRQ1_MARK, IRQ0_MARK,

	DRAK3_MARK, DRAK2_MARK, DRAK1_MARK, DRAK0_MARK,

	SCK3_MARK, SCK2_MARK, SCK1_MARK, SCK0_MARK,
	IRL3_MARK, IRL2_MARK, IRL1_MARK, IRL0_MARK,
	TXD3_MARK, TXD2_MARK, TXD1_MARK, TXD0_MARK,
	RXD3_MARK, RXD2_MARK, RXD1_MARK, RXD0_MARK,

	CE2B_MARK, CE2A_MARK, IOIS16_MARK,
	STATUS1_MARK, STATUS0_MARK,

	IRQOUT_MARK,

	PINMUX_MARK_END,
};

static const u16 pinmux_data[] = {
	/* PA GPIO */
	PINMUX_DATA(PA7_DATA, PA7_IN, PA7_OUT),
	PINMUX_DATA(PA6_DATA, PA6_IN, PA6_OUT),
	PINMUX_DATA(PA5_DATA, PA5_IN, PA5_OUT),
	PINMUX_DATA(PA4_DATA, PA4_IN, PA4_OUT),
	PINMUX_DATA(PA3_DATA, PA3_IN, PA3_OUT),
	PINMUX_DATA(PA2_DATA, PA2_IN, PA2_OUT),
	PINMUX_DATA(PA1_DATA, PA1_IN, PA1_OUT),
	PINMUX_DATA(PA0_DATA, PA0_IN, PA0_OUT),

	/* PB GPIO */
	PINMUX_DATA(PB7_DATA, PB7_IN, PB7_OUT),
	PINMUX_DATA(PB6_DATA, PB6_IN, PB6_OUT),
	PINMUX_DATA(PB5_DATA, PB5_IN, PB5_OUT),
	PINMUX_DATA(PB4_DATA, PB4_IN, PB4_OUT),
	PINMUX_DATA(PB3_DATA, PB3_IN, PB3_OUT),
	PINMUX_DATA(PB2_DATA, PB2_IN, PB2_OUT),
	PINMUX_DATA(PB1_DATA, PB1_IN, PB1_OUT),
	PINMUX_DATA(PB0_DATA, PB0_IN, PB0_OUT),

	/* PC GPIO */
	PINMUX_DATA(PC7_DATA, PC7_IN, PC7_OUT),
	PINMUX_DATA(PC6_DATA, PC6_IN, PC6_OUT),
	PINMUX_DATA(PC5_DATA, PC5_IN, PC5_OUT),
	PINMUX_DATA(PC4_DATA, PC4_IN, PC4_OUT),
	PINMUX_DATA(PC3_DATA, PC3_IN, PC3_OUT),
	PINMUX_DATA(PC2_DATA, PC2_IN, PC2_OUT),
	PINMUX_DATA(PC1_DATA, PC1_IN, PC1_OUT),
	PINMUX_DATA(PC0_DATA, PC0_IN, PC0_OUT),

	/* PD GPIO */
	PINMUX_DATA(PD7_DATA, PD7_IN, PD7_OUT),
	PINMUX_DATA(PD6_DATA, PD6_IN, PD6_OUT),
	PINMUX_DATA(PD5_DATA, PD5_IN, PD5_OUT),
	PINMUX_DATA(PD4_DATA, PD4_IN, PD4_OUT),
	PINMUX_DATA(PD3_DATA, PD3_IN, PD3_OUT),
	PINMUX_DATA(PD2_DATA, PD2_IN, PD2_OUT),
	PINMUX_DATA(PD1_DATA, PD1_IN, PD1_OUT),
	PINMUX_DATA(PD0_DATA, PD0_IN, PD0_OUT),

	/* PE GPIO */
	PINMUX_DATA(PE7_DATA, PE7_IN, PE7_OUT),
	PINMUX_DATA(PE6_DATA, PE6_IN, PE6_OUT),
	PINMUX_DATA(PE5_DATA, PE5_IN, PE5_OUT),
	PINMUX_DATA(PE4_DATA, PE4_IN, PE4_OUT),
	PINMUX_DATA(PE3_DATA, PE3_IN, PE3_OUT),
	PINMUX_DATA(PE2_DATA, PE2_IN, PE2_OUT),
	PINMUX_DATA(PE1_DATA, PE1_IN, PE1_OUT),
	PINMUX_DATA(PE0_DATA, PE0_IN, PE0_OUT),

	/* PF GPIO */
	PINMUX_DATA(PF7_DATA, PF7_IN, PF7_OUT),
	PINMUX_DATA(PF6_DATA, PF6_IN, PF6_OUT),
	PINMUX_DATA(PF5_DATA, PF5_IN, PF5_OUT),
	PINMUX_DATA(PF4_DATA, PF4_IN, PF4_OUT),
	PINMUX_DATA(PF3_DATA, PF3_IN, PF3_OUT),
	PINMUX_DATA(PF2_DATA, PF2_IN, PF2_OUT),
	PINMUX_DATA(PF1_DATA, PF1_IN, PF1_OUT),
	PINMUX_DATA(PF0_DATA, PF0_IN, PF0_OUT),

	/* PG GPIO */
	PINMUX_DATA(PG7_DATA, PG7_IN, PG7_OUT),
	PINMUX_DATA(PG6_DATA, PG6_IN, PG6_OUT),
	PINMUX_DATA(PG5_DATA, PG5_IN, PG5_OUT),
	PINMUX_DATA(PG4_DATA, PG4_IN, PG4_OUT),
	PINMUX_DATA(PG3_DATA, PG3_IN, PG3_OUT),
	PINMUX_DATA(PG2_DATA, PG2_IN, PG2_OUT),
	PINMUX_DATA(PG1_DATA, PG1_IN, PG1_OUT),
	PINMUX_DATA(PG0_DATA, PG0_IN, PG0_OUT),

	/* PH GPIO */
	PINMUX_DATA(PH5_DATA, PH5_IN, PH5_OUT),
	PINMUX_DATA(PH4_DATA, PH4_IN, PH4_OUT),
	PINMUX_DATA(PH3_DATA, PH3_IN, PH3_OUT),
	PINMUX_DATA(PH2_DATA, PH2_IN, PH2_OUT),
	PINMUX_DATA(PH1_DATA, PH1_IN, PH1_OUT),
	PINMUX_DATA(PH0_DATA, PH0_IN, PH0_OUT),

	/* PA FN */
	PINMUX_DATA(D31_MARK, PA7_FN),
	PINMUX_DATA(D30_MARK, PA6_FN),
	PINMUX_DATA(D29_MARK, PA5_FN),
	PINMUX_DATA(D28_MARK, PA4_FN),
	PINMUX_DATA(D27_MARK, PA3_FN),
	PINMUX_DATA(D26_MARK, PA2_FN),
	PINMUX_DATA(D25_MARK, PA1_FN),
	PINMUX_DATA(D24_MARK, PA0_FN),

	/* PB FN */
	PINMUX_DATA(D23_MARK, PB7_FN),
	PINMUX_DATA(D22_MARK, PB6_FN),
	PINMUX_DATA(D21_MARK, PB5_FN),
	PINMUX_DATA(D20_MARK, PB4_FN),
	PINMUX_DATA(D19_MARK, PB3_FN),
	PINMUX_DATA(D18_MARK, PB2_FN),
	PINMUX_DATA(D17_MARK, PB1_FN),
	PINMUX_DATA(D16_MARK, PB0_FN),

	/* PC FN */
	PINMUX_DATA(BACK_MARK,		PC7_FN),
	PINMUX_DATA(BREQ_MARK,		PC6_FN),
	PINMUX_DATA(WE3_MARK,		PC5_FN),
	PINMUX_DATA(WE2_MARK,		PC4_FN),
	PINMUX_DATA(CS6_MARK,		PC3_FN),
	PINMUX_DATA(CS5_MARK,		PC2_FN),
	PINMUX_DATA(CS4_MARK,		PC1_FN),
	PINMUX_DATA(CLKOUTENB_MARK,	PC0_FN),

	/* PD FN */
	PINMUX_DATA(DACK3_MARK,	PD7_FN),
	PINMUX_DATA(DACK2_MARK, PD6_FN),
	PINMUX_DATA(DACK1_MARK, PD5_FN),
	PINMUX_DATA(DACK0_MARK, PD4_FN),
	PINMUX_DATA(DREQ3_MARK, PD3_FN),
	PINMUX_DATA(DREQ2_MARK, PD2_FN),
	PINMUX_DATA(DREQ1_MARK, PD1_FN),
	PINMUX_DATA(DREQ0_MARK, PD0_FN),

	/* PE FN */
	PINMUX_DATA(IRQ3_MARK,	PE7_FN),
	PINMUX_DATA(IRQ2_MARK,	PE6_FN),
	PINMUX_DATA(IRQ1_MARK,	PE5_FN),
	PINMUX_DATA(IRQ0_MARK,	PE4_FN),
	PINMUX_DATA(DRAK3_MARK, PE3_FN),
	PINMUX_DATA(DRAK2_MARK, PE2_FN),
	PINMUX_DATA(DRAK1_MARK, PE1_FN),
	PINMUX_DATA(DRAK0_MARK, PE0_FN),

	/* PF FN */
	PINMUX_DATA(SCK3_MARK, PF7_FN),
	PINMUX_DATA(SCK2_MARK, PF6_FN),
	PINMUX_DATA(SCK1_MARK, PF5_FN),
	PINMUX_DATA(SCK0_MARK, PF4_FN),
	PINMUX_DATA(IRL3_MARK, PF3_FN),
	PINMUX_DATA(IRL2_MARK, PF2_FN),
	PINMUX_DATA(IRL1_MARK, PF1_FN),
	PINMUX_DATA(IRL0_MARK, PF0_FN),

	/* PG FN */
	PINMUX_DATA(TXD3_MARK, PG7_FN),
	PINMUX_DATA(TXD2_MARK, PG6_FN),
	PINMUX_DATA(TXD1_MARK, PG5_FN),
	PINMUX_DATA(TXD0_MARK, PG4_FN),
	PINMUX_DATA(RXD3_MARK, PG3_FN),
	PINMUX_DATA(RXD2_MARK, PG2_FN),
	PINMUX_DATA(RXD1_MARK, PG1_FN),
	PINMUX_DATA(RXD0_MARK, PG0_FN),

	/* PH FN */
	PINMUX_DATA(CE2B_MARK,		PH5_FN),
	PINMUX_DATA(CE2A_MARK,		PH4_FN),
	PINMUX_DATA(IOIS16_MARK,	PH3_FN),
	PINMUX_DATA(STATUS1_MARK,	PH2_FN),
	PINMUX_DATA(STATUS0_MARK,	PH1_FN),
	PINMUX_DATA(IRQOUT_MARK,	PH0_FN),
};

static const struct sh_pfc_pin pinmux_pins[] = {
	/* PA */
	PINMUX_GPIO(PA7),
	PINMUX_GPIO(PA6),
	PINMUX_GPIO(PA5),
	PINMUX_GPIO(PA4),
	PINMUX_GPIO(PA3),
	PINMUX_GPIO(PA2),
	PINMUX_GPIO(PA1),
	PINMUX_GPIO(PA0),

	/* PB */
	PINMUX_GPIO(PB7),
	PINMUX_GPIO(PB6),
	PINMUX_GPIO(PB5),
	PINMUX_GPIO(PB4),
	PINMUX_GPIO(PB3),
	PINMUX_GPIO(PB2),
	PINMUX_GPIO(PB1),
	PINMUX_GPIO(PB0),

	/* PC */
	PINMUX_GPIO(PC7),
	PINMUX_GPIO(PC6),
	PINMUX_GPIO(PC5),
	PINMUX_GPIO(PC4),
	PINMUX_GPIO(PC3),
	PINMUX_GPIO(PC2),
	PINMUX_GPIO(PC1),
	PINMUX_GPIO(PC0),

	/* PD */
	PINMUX_GPIO(PD7),
	PINMUX_GPIO(PD6),
	PINMUX_GPIO(PD5),
	PINMUX_GPIO(PD4),
	PINMUX_GPIO(PD3),
	PINMUX_GPIO(PD2),
	PINMUX_GPIO(PD1),
	PINMUX_GPIO(PD0),

	/* PE */
	PINMUX_GPIO(PE7),
	PINMUX_GPIO(PE6),
	PINMUX_GPIO(PE5),
	PINMUX_GPIO(PE4),
	PINMUX_GPIO(PE3),
	PINMUX_GPIO(PE2),
	PINMUX_GPIO(PE1),
	PINMUX_GPIO(PE0),

	/* PF */
	PINMUX_GPIO(PF7),
	PINMUX_GPIO(PF6),
	PINMUX_GPIO(PF5),
	PINMUX_GPIO(PF4),
	PINMUX_GPIO(PF3),
	PINMUX_GPIO(PF2),
	PINMUX_GPIO(PF1),
	PINMUX_GPIO(PF0),

	/* PG */
	PINMUX_GPIO(PG7),
	PINMUX_GPIO(PG6),
	PINMUX_GPIO(PG5),
	PINMUX_GPIO(PG4),
	PINMUX_GPIO(PG3),
	PINMUX_GPIO(PG2),
	PINMUX_GPIO(PG1),
	PINMUX_GPIO(PG0),

	/* PH */
	PINMUX_GPIO(PH5),
	PINMUX_GPIO(PH4),
	PINMUX_GPIO(PH3),
	PINMUX_GPIO(PH2),
	PINMUX_GPIO(PH1),
	PINMUX_GPIO(PH0),
};

#define PINMUX_FN_BASE	ARRAY_SIZE(pinmux_pins)

static const struct pinmux_func pinmux_func_gpios[] = {
	/* FN */
	GPIO_FN(D31),
	GPIO_FN(D30),
	GPIO_FN(D29),
	GPIO_FN(D28),
	GPIO_FN(D27),
	GPIO_FN(D26),
	GPIO_FN(D25),
	GPIO_FN(D24),
	GPIO_FN(D23),
	GPIO_FN(D22),
	GPIO_FN(D21),
	GPIO_FN(D20),
	GPIO_FN(D19),
	GPIO_FN(D18),
	GPIO_FN(D17),
	GPIO_FN(D16),
	GPIO_FN(BACK),
	GPIO_FN(BREQ),
	GPIO_FN(WE3),
	GPIO_FN(WE2),
	GPIO_FN(CS6),
	GPIO_FN(CS5),
	GPIO_FN(CS4),
	GPIO_FN(CLKOUTENB),
	GPIO_FN(DACK3),
	GPIO_FN(DACK2),
	GPIO_FN(DACK1),
	GPIO_FN(DACK0),
	GPIO_FN(DREQ3),
	GPIO_FN(DREQ2),
	GPIO_FN(DREQ1),
	GPIO_FN(DREQ0),
	GPIO_FN(IRQ3),
	GPIO_FN(IRQ2),
	GPIO_FN(IRQ1),
	GPIO_FN(IRQ0),
	GPIO_FN(DRAK3),
	GPIO_FN(DRAK2),
	GPIO_FN(DRAK1),
	GPIO_FN(DRAK0),
	GPIO_FN(SCK3),
	GPIO_FN(SCK2),
	GPIO_FN(SCK1),
	GPIO_FN(SCK0),
	GPIO_FN(IRL3),
	GPIO_FN(IRL2),
	GPIO_FN(IRL1),
	GPIO_FN(IRL0),
	GPIO_FN(TXD3),
	GPIO_FN(TXD2),
	GPIO_FN(TXD1),
	GPIO_FN(TXD0),
	GPIO_FN(RXD3),
	GPIO_FN(RXD2),
	GPIO_FN(RXD1),
	GPIO_FN(RXD0),
	GPIO_FN(CE2B),
	GPIO_FN(CE2A),
	GPIO_FN(IOIS16),
	GPIO_FN(STATUS1),
	GPIO_FN(STATUS0),
	GPIO_FN(IRQOUT),
};

static const struct pinmux_cfg_reg pinmux_config_regs[] = {
	{ PINMUX_CFG_REG("PABCR", 0xffc70000, 32, 2) {
		PA7_FN, PA7_OUT, PA7_IN, 0,
		PA6_FN, PA6_OUT, PA6_IN, 0,
		PA5_FN, PA5_OUT, PA5_IN, 0,
		PA4_FN, PA4_OUT, PA4_IN, 0,
		PA3_FN, PA3_OUT, PA3_IN, 0,
		PA2_FN, PA2_OUT, PA2_IN, 0,
		PA1_FN, PA1_OUT, PA1_IN, 0,
		PA0_FN, PA0_OUT, PA0_IN, 0,
		PB7_FN, PB7_OUT, PB7_IN, 0,
		PB6_FN, PB6_OUT, PB6_IN, 0,
		PB5_FN, PB5_OUT, PB5_IN, 0,
		PB4_FN, PB4_OUT, PB4_IN, 0,
		PB3_FN, PB3_OUT, PB3_IN, 0,
		PB2_FN, PB2_OUT, PB2_IN, 0,
		PB1_FN, PB1_OUT, PB1_IN, 0,
		PB0_FN, PB0_OUT, PB0_IN, 0, },
	},
	{ PINMUX_CFG_REG("PCDCR", 0xffc70004, 32, 2) {
		PC7_FN, PC7_OUT, PC7_IN, 0,
		PC6_FN, PC6_OUT, PC6_IN, 0,
		PC5_FN, PC5_OUT, PC5_IN, 0,
		PC4_FN, PC4_OUT, PC4_IN, 0,
		PC3_FN, PC3_OUT, PC3_IN, 0,
		PC2_FN, PC2_OUT, PC2_IN, 0,
		PC1_FN, PC1_OUT, PC1_IN, 0,
		PC0_FN, PC0_OUT, PC0_IN, 0,
		PD7_FN, PD7_OUT, PD7_IN, 0,
		PD6_FN, PD6_OUT, PD6_IN, 0,
		PD5_FN, PD5_OUT, PD5_IN, 0,
		PD4_FN, PD4_OUT, PD4_IN, 0,
		PD3_FN, PD3_OUT, PD3_IN, 0,
		PD2_FN, PD2_OUT, PD2_IN, 0,
		PD1_FN, PD1_OUT, PD1_IN, 0,
		PD0_FN, PD0_OUT, PD0_IN, 0, },
	},
	{ PINMUX_CFG_REG("PEFCR", 0xffc70008, 32, 2) {
		PE7_FN, PE7_OUT, PE7_IN, 0,
		PE6_FN, PE6_OUT, PE6_IN, 0,
		PE5_FN, PE5_OUT, PE5_IN, 0,
		PE4_FN, PE4_OUT, PE4_IN, 0,
		PE3_FN, PE3_OUT, PE3_IN, 0,
		PE2_FN, PE2_OUT, PE2_IN, 0,
		PE1_FN, PE1_OUT, PE1_IN, 0,
		PE0_FN, PE0_OUT, PE0_IN, 0,
		PF7_FN, PF7_OUT, PF7_IN, 0,
		PF6_FN, PF6_OUT, PF6_IN, 0,
		PF5_FN, PF5_OUT, PF5_IN, 0,
		PF4_FN, PF4_OUT, PF4_IN, 0,
		PF3_FN, PF3_OUT, PF3_IN, 0,
		PF2_FN, PF2_OUT, PF2_IN, 0,
		PF1_FN, PF1_OUT, PF1_IN, 0,
		PF0_FN, PF0_OUT, PF0_IN, 0, },
	},
	{ PINMUX_CFG_REG("PGHCR", 0xffc7000c, 32, 2) {
		PG7_FN, PG7_OUT, PG7_IN, 0,
		PG6_FN, PG6_OUT, PG6_IN, 0,
		PG5_FN, PG5_OUT, PG5_IN, 0,
		PG4_FN, PG4_OUT, PG4_IN, 0,
		PG3_FN, PG3_OUT, PG3_IN, 0,
		PG2_FN, PG2_OUT, PG2_IN, 0,
		PG1_FN, PG1_OUT, PG1_IN, 0,
		PG0_FN, PG0_OUT, PG0_IN, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		PH5_FN, PH5_OUT, PH5_IN, 0,
		PH4_FN, PH4_OUT, PH4_IN, 0,
		PH3_FN, PH3_OUT, PH3_IN, 0,
		PH2_FN, PH2_OUT, PH2_IN, 0,
		PH1_FN, PH1_OUT, PH1_IN, 0,
		PH0_FN, PH0_OUT, PH0_IN, 0, },
	},
	{ },
};

static const struct pinmux_data_reg pinmux_data_regs[] = {
	{ PINMUX_DATA_REG("PABDR", 0xffc70010, 32) {
		0, 0, 0, 0, 0, 0, 0, 0,
		PA7_DATA, PA6_DATA, PA5_DATA, PA4_DATA,
		PA3_DATA, PA2_DATA, PA1_DATA, PA0_DATA,
		0, 0, 0, 0, 0, 0, 0, 0,
		PB7_DATA, PB6_DATA, PB5_DATA, PB4_DATA,
		PB3_DATA, PB2_DATA, PB1_DATA, PB0_DATA, },
	},
	{ PINMUX_DATA_REG("PCDDR", 0xffc70014, 32) {
		0, 0, 0, 0, 0, 0, 0, 0,
		PC7_DATA, PC6_DATA, PC5_DATA, PC4_DATA,
		PC3_DATA, PC2_DATA, PC1_DATA, PC0_DATA,
		0, 0, 0, 0, 0, 0, 0, 0,
		PD7_DATA, PD6_DATA, PD5_DATA, PD4_DATA,
		PD3_DATA, PD2_DATA, PD1_DATA, PD0_DATA, },
	},
	{ PINMUX_DATA_REG("PEFDR", 0xffc70018, 32) {
		0, 0, 0, 0, 0, 0, 0, 0,
		PE7_DATA, PE6_DATA, PE5_DATA, PE4_DATA,
		PE3_DATA, PE2_DATA, PE1_DATA, PE0_DATA,
		0, 0, 0, 0, 0, 0, 0, 0,
		PF7_DATA, PF6_DATA, PF5_DATA, PF4_DATA,
		PF3_DATA, PF2_DATA, PF1_DATA, PF0_DATA, },
	},
	{ PINMUX_DATA_REG("PGHDR", 0xffc7001c, 32) {
		0, 0, 0, 0, 0, 0, 0, 0,
		PG7_DATA, PG6_DATA, PG5_DATA, PG4_DATA,
		PG3_DATA, PG2_DATA, PG1_DATA, PG0_DATA,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, PH5_DATA, PH4_DATA,
		PH3_DATA, PH2_DATA, PH1_DATA, PH0_DATA, },
	},
	{ },
};

const struct sh_pfc_soc_info shx3_pinmux_info = {
	.name		= "shx3_pfc",
	.input		= { PINMUX_INPUT_BEGIN,	   PINMUX_INPUT_END },
	.output		= { PINMUX_OUTPUT_BEGIN,   PINMUX_OUTPUT_END },
	.function	= { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },
	.pins		= pinmux_pins,
	.nr_pins	= ARRAY_SIZE(pinmux_pins),
	.func_gpios	= pinmux_func_gpios,
	.nr_func_gpios	= ARRAY_SIZE(pinmux_func_gpios),
	.pinmux_data	= pinmux_data,
	.pinmux_data_size = ARRAY_SIZE(pinmux_data),
	.cfg_regs	= pinmux_config_regs,
	.data_regs	= pinmux_data_regs,
};
