/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IdentifiedArrayReferenceValue;
import proguard.evaluation.value.InitialValueFactory;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.util.ArrayUtil;

class DetailedArrayReferenceValue
extends IdentifiedArrayReferenceValue {
    private static final int MAXIMUM_STORED_ARRAY_LENGTH = 32;
    private final Value[] values;

    public DetailedArrayReferenceValue(String string, Clazz clazz, boolean bl, IntegerValue integerValue, ValueFactory valueFactory, int n) {
        super(string, clazz, bl, integerValue, valueFactory, n);
        if (integerValue.isParticular() && integerValue.value() >= 0 && integerValue.value() <= 32) {
            InitialValueFactory initialValueFactory = new InitialValueFactory(valueFactory);
            String string2 = ClassUtil.isInternalArrayType(string) ? string.substring(1) : string;
            this.values = new Value[integerValue.value()];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = initialValueFactory.createValue(string2);
            }
        } else {
            this.values = null;
        }
    }

    @Override
    public IntegerValue integerArrayLoad(IntegerValue integerValue, ValueFactory valueFactory) {
        Value value = this.arrayLoad(integerValue, valueFactory);
        return value != null ? value.integerValue() : super.integerArrayLoad(integerValue, valueFactory);
    }

    @Override
    public LongValue longArrayLoad(IntegerValue integerValue, ValueFactory valueFactory) {
        Value value = this.arrayLoad(integerValue, valueFactory);
        return value != null ? value.longValue() : super.longArrayLoad(integerValue, valueFactory);
    }

    @Override
    public FloatValue floatArrayLoad(IntegerValue integerValue, ValueFactory valueFactory) {
        Value value = this.arrayLoad(integerValue, valueFactory);
        return value != null ? value.floatValue() : super.floatArrayLoad(integerValue, valueFactory);
    }

    @Override
    public DoubleValue doubleArrayLoad(IntegerValue integerValue, ValueFactory valueFactory) {
        Value value = this.arrayLoad(integerValue, valueFactory);
        return value != null ? value.doubleValue() : super.doubleArrayLoad(integerValue, valueFactory);
    }

    @Override
    public ReferenceValue referenceArrayLoad(IntegerValue integerValue, ValueFactory valueFactory) {
        Value value = this.arrayLoad(integerValue, valueFactory);
        return value != null ? value.referenceValue() : super.referenceArrayLoad(integerValue, valueFactory);
    }

    private Value arrayLoad(IntegerValue integerValue, ValueFactory valueFactory) {
        int n;
        if (this.values != null && integerValue.isParticular() && (n = integerValue.value()) >= 0 && n < this.values.length) {
            return this.values[n];
        }
        return null;
    }

    @Override
    public void arrayStore(IntegerValue integerValue, Value value) {
        if (this.values != null) {
            if (integerValue.isParticular()) {
                int n = integerValue.value();
                if (n >= 0 && n < this.values.length) {
                    this.values[n] = value;
                }
            } else {
                for (int i = 0; i < this.values.length; ++i) {
                    this.values[i].generalize(value);
                }
            }
        }
    }

    @Override
    public ReferenceValue generalize(ReferenceValue referenceValue) {
        return referenceValue.generalize(this);
    }

    @Override
    public int equal(ReferenceValue referenceValue) {
        return referenceValue.equal(this);
    }

    @Override
    public boolean isParticular() {
        if (this.values == null) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].isParticular()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        DetailedArrayReferenceValue detailedArrayReferenceValue = (DetailedArrayReferenceValue)object;
        return ArrayUtil.equalOrNull(this.values, detailedArrayReferenceValue.values);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ ArrayUtil.hashCodeOrNull(this.values);
    }

    @Override
    public String toString() {
        if (this.values == null) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append('{');
        for (int i = 0; i < this.values.length; ++i) {
            stringBuffer.append(this.values[i]);
            stringBuffer.append(i < this.values.length - 1 ? (char)',' : '}');
        }
        return stringBuffer.toString();
    }
}

