      SUBROUTINE PAGE2 (LINES)
C
C     2ND MASTER PAGING ROUTINE FOR NASTRAN
C
C     IABS(LINES) = NO. OF LINES TO BE ADDED FOR OUTPUT
C     IF CURRENT PAGE CAN NOT ACCOMODATE THE INCOMING LINES, A NEW PAGE
C     IS INITIATED WITH PROPER HEADINGS.
C
C     IF LINES IS NEGATIVE, A 6-LINE HEADER IS PRINTED.
C     IF LINES IS POSITIVE, A 3-LINE HEADER IS PRINTED AND FOLLOWED BY
C        3 BLANK LINES.
C
C     ENTRY POINT PAGE3 -
C     A 3-LINE HEADER IS PRINTED, NO BLANK LINES FOLLOWED. LINES CAN BE
C     NEGATIVE OR POSITIVE.
C
C     SIMPLIFIED BY G.CHAN/UNISYS, AND PAGE3 ADDED  12/92
C
      IMPLICIT INTEGER (A-Z)
      INTEGER         TITLEX(18),NAME(2),FCHAR
      CHARACTER       MONTH(12)*3,AHEAD*30,MCHNAM*11,MACHOS*7
      COMMON /CHMACH/ MCHNAM, MACHOS
      COMMON /MACHIN/ MACH(4)
      COMMON /SYSTEM/ IBUF,NOUT,DUM6(6),SYM,ST,PAGE,LINE,TLINE,MAXLIN,
     1                DATE(3),DUM15(15),OFP,DUM8(8),CRDATE(3)
      COMMON /OUTPUT/ TITLE(32),SUBTIT(32),LABEL(32),HEAD1(32),
     1                HEAD2(32),HEAD3(32)
      EQUIVALENCE     (TITLEX(1),TITLE(1))
      DATA    MONTH /'JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 
     1               'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'/
      DATA    NAME  / 4H PAG, 4HE2  /
C
      FLAG  = 2
C
   10 IF (LINES .EQ. 0) GO TO 100
      LL    = IABS(LINES)
      IF (SYM-LINE.LT.LL .OR. OFP.NE.0) GO TO 30
   20 LINE  = LINE + LL
      GO TO 100
C
   30 PAGE  = PAGE  + 1
      TLINE = TLINE + LINE
      LINE  = 0
      IF (TLINE .GT. MAXLIN) GO TO 90
      IN    = DATE(1)
C
C   ASSEMBLE PAGE HEADING
C
      AHEAD = ' '
      NCMNAM = INDEX(MCHNAM,' ') - 1
      IF (NCMNAM .LE. -1) NCMNAM = 11
      NCMOS  = INDEX(MACHOS,' ') - 1
      IF (NCMOS .LE. -1) NCMOS = 7
      FCHAR = (18 - NCMNAM - NCMOS)/2 + 1
      WRITE (AHEAD(FCHAR:FCHAR+1),35) CRDATE(3)
   35 FORMAT (A2)
      FCHAR = FCHAR + 3
      AHEAD(FCHAR:30) = MCHNAM(1:NCMNAM) // ' ' // MACHOS(1:NCMOS) //
     1 ' NASTRAN'
C
      WRITE  (NOUT,40) TITLEX, AHEAD, MONTH(IN),DATE(2),DATE(3),PAGE
   40 FORMAT (1H1,4X,17A4,A2,' /',A30,'/ ',A3,1X,I2,', ',I2, 
     1        ' / PAGE',I6)
      WRITE  (NOUT,50) SUBTIT
   50 FORMAT ( 5X,31A4,A3)
      WRITE  (NOUT,60) LABEL
   60 FORMAT (/5X,31A4,A3)
      LINE  = LINE + 4
      IF (FLAG  .LT. 0) GO TO 20
      IF (LINES .GT. 0) GO TO 70
C
      WRITE (NOUT,60) (HEAD1(I),I=1,32)
      WRITE (NOUT,50) (HEAD2(I),I=1,32)
      WRITE (NOUT,50) (HEAD3(I),I=1,32)
      LINE  = LINE + 4
      GO TO 20
C
   70 WRITE  (NOUT,80)
   80 FORMAT (///)
      LINE  = LINE + 4
      GO TO 20
C
C     MAX LINES EXCEEDED.  BUMP MAXLINES BY 3000 AND CALL MESAGE
C
   90 MAXLIN = MAXLIN + 3000
      CALL MESAGE (-19,TLINE,NAME)
C
  100 OFP  = 0
      RETURN
C
C
      ENTRY PAGE3 (LINES)
C     ===================
C
      FLAG = -3
      GO TO 10
C
      END
