## About

dcm2niix can convert Canon (né Toshiba) DICOM format images to NIfTI. This page notes vendor specific conversion details.

## Avoid Classic DICOM

Users of Canon MRI equipment are strongly advised to export data from their scanners as enhanced DICOM (with all images from the series stored as a single file) rather than classic DICOM (each 2D slice stored as a separate file). Limitations of the Canon classic DICOMs are described [here](https://github.com/rordenlab/dcm2niix/issues/495) and [here](https://github.com/neurolabusc/dcm_qa_canon).

## Avoid Enhanced DICOM

Users of Canon MRI equipment are strongly advised to export data from their scanners as classic DICOM (with each slice from the series stored as a separate files) rather than enhanced DICOM. The enhanced 4D sequences such as fMRI incorrectly sets the public tag TemporalPositionIndex (0020,9128) as 1 for all volumes: both (0020,9157) and (0020,9128). This is a violation of the DICOM standard and interferes with attempts to sort data into the correct temporal order. Any software or user who assumes these tags are truthful will fail.

## The Enhanced versus Classic DICOM dilemma

The prior two sections provide conflicting advice, due to limitations in both the classic and enhanced datasets generated by Canon instruments. Users of Canon equipment should lobby the manufacturer to honor their DICOM conformance statement. DICOM data from Canon instruments may not be handled correctly by any software tool including dcm2niix. This reflects a limitation in the source DICOM data, not dcm2niix.

## Diffusion Weighted Imaging Notes

In contrast to several other vendors, Toshiba used public tags to report diffusion properties. Specifically, [DiffusionBValue (0018,9087)](http://dicomlookup.com/lookup.asp?sw=Tnumber&q=(0018,9087)) and [DiffusionGradientOrientation (0018,9089)](http://dicomlookup.com/lookup.asp?sw=Tnumber&q=(0018,9089)). Be aware that these tags are only populated for images where a diffusion gradient is applied. Consider a typical diffusion series where some volumes are acquired with B=0 while others have B=1000. In this case, only the volumes with B>0 will report a DiffusionBValue. These coordinates are with respect to the scanner bore, not image space.

Be aware that Canon software V6.0 stored diffusion directions in the ASCII Image Comments tag when exporting to classic DICOM. For detailed discussion and a validation dataset that exhibits these attributes please see [dcm_qa_canon](https://github.com/neurolabusc/dcm_qa_canon). A Canon classic DICOM DWI image may report:

```
 (0018,9087) FD 1500                                     #   8, 1 DiffusionBValue
 (0020,4000) LT [b=1500(0.445,0.000,0.895)]              #  26, 1 ImageComments
```

In contrast, Canon software [V6.1](https://github.com/neurolabusc/dcm_qa_canon_61) uses pulbic tags for both classic and enhanced DICOMs. A Canon V6.1 DICOM DWI image may report:

```
(0018,9087) FD 1500                                     #   8, 1 DiffusionBValue
(0018,9089) FD 0.29387456178665161\-0.95365142822265625\-0.064700603485107422 #  24, 3 DiffusionGradientOrientation
```

## Unknown Properties

The [BIDS format](https://bids.neuroimaging.io) can record several sequence properties that are useful for processing MRI data. The DICOM headers created by Toshiba scanners are very clean and minimalistic, and do not report several of these advanced properties. Therefore, dcm2niix is unable to populate these properties of the JSON file. This reflects a limitation of the DICOM images, not of dcm2niix.

 - SliceTiming is not recorded. This can be useful for slice time correction.
 - Phase encoding polarity is not recorded. This is useful for undistortion with [TOPUP](https://fsl.fmrib.ox.ac.uk/fsl/fslwiki/topup). Clément Debacker notes that this parameter can be encoded into a XML field called `<VG>` inserted in the private tag 700D,1119. However, this requires the user to explicitly request these details and uses XML rather than DICOM so it is not easily parsed. To enable this, you must have the option "Private tag for MRI image" activated on the scanner. You can ask your local clinical scientist/application specialist to enable it.

## Sample Datasets

 - [Toshiba Aquilion](https://www.aliza-dicom-viewer.com/download/datasets).
 - [Toshiba 3T Galan Diffusion Dataset](https://github.com/neurolabusc/dcm_qa_toshiba).
 - [Canon 3T Galan Diffusion Dataset](https://github.com/neurolabusc/dcm_qa_canon).
