/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/dump_test_suite.ts.cpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta]
 */


#include <diagnostics/util/dump_test_suite.ts.hpp>

#include <diagnostics/unittest/test_system/list_test_suite_traversal.hpp>

#include <diagnostics/unittest/test_system/test_list_result.hpp>

#include <sstream>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;

::std::string dump_test_suite(::diagnostics::unittest::Test_Suite * test_suite,
			      ::std::string const & mask, 
			      ::diagnostics::Level_t const level)
{
    typedef ::diagnostics::unittest::List_Test_Suite_Traversal::Test_List_Results_t Results_t;
    Results_t results;
    ::diagnostics::unittest::List_Test_Suite_Traversal trav(results);
    trav.traverse(*test_suite,mask,level);
    Results_t::const_iterator cur(results.begin());
    Results_t::const_iterator const end(results.end());
    ::std::ostringstream stream;
    for(;cur!=end;++cur) {
	stream << **cur << '\n';
	delete *cur;
    }
    return stream.str();
}

TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;


// vim:ts=4:sw=4
