/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __LISTENERS
#define __LISTENERS

#include "curve_listener.h"

struct din;

struct wave_listener : curve_listener {
  enum {DIN_BOARD, KEYBOARD_KEYBOARD, DRONE};
  int which;
  wave_listener (int w) : which (w) {}
  void edited (curve_editor* ed, int i);
};

struct drone_listener : curve_listener {
  din* d;
  drone_listener (din* dd);
  void edited (curve_editor* ed, int i);

};

struct mod_listener : curve_listener {

  din* d;
  mod_listener (din* dd);
  void edited (curve_editor* ed, int i);

};

struct beat2value;
struct beat2value_listener : curve_listener {
  beat2value* beat2value0;
  beat2value_listener (beat2value* g);
  void edited (curve_editor* ed, int i);
};

struct morse_code_listener : curve_listener {

  void edited (curve_editor* ed, int i);

};

struct solver;
struct delay;
struct delay_listener : curve_listener {

  delay* dly;
  solver* sol;
  float* result;

  delay_listener (delay* d, solver* s, float* r) : dly(d), sol (s), result (r) {}
  void edited (curve_editor* ed, int i);

};

struct keyboard_keyboard;

struct attack_listener : curve_listener {
  keyboard_keyboard* k;
  attack_listener (keyboard_keyboard*);
  void edited (curve_editor* ed, int i);
};

struct decay_listener : curve_listener {
  keyboard_keyboard* k;
  decay_listener (keyboard_keyboard*);
  void edited (curve_editor* ed, int i);
};

struct velocity_listener : curve_listener {
  keyboard_keyboard* k;
  velocity_listener (keyboard_keyboard* kk) : k(kk) {}
  void edited (curve_editor* ed, int i);
};

#endif
