# Copyright (C) 2009 Sun Microsystems, Inc. All rights reserved.  Use
# is subject to license terms.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301
# USA

# Do a simple run of scripts to see that they're sound
#
package Metadata;
use base qw(Test::Unit::TestCase);
use lib 'lib';
use GenTest::Executor;

sub new {
    my $self = shift()->SUPER::new(@_);
    # your state for fixture here
    return $self;
}

my $executor;
sub set_up {
    $executor = new GenTest::Executor->newFromDSN('dummy');    
    $executor->cacheMetaData();
}

sub tear_down {
}

sub test_metadata {
    my ($self) = @_;
    my $data = $executor->metaCollations();
    my $data = $executor->metaCharactersets();
    my $data = $executor->metaSchemas();
    my $data = $executor->metaColumns('tab','schema');
    my $data = $executor->metaColumnsType('indexed','tab','schema');
    my $data = $executor->metaColumnsTypeNot('pk','tab','schema');
}

sub test_missingmetadata {
    my ($self) = @_;
    my $data;
    
    eval {
        $data = $executor->metaColumns('foo','bar');
    };
    $self->assert_equals(-1,$#$data);
    
    eval {
        $data = $executor->metaColumnsType('indexed','foo','bar');
    };
    $self->assert_equals(-1,$#$data);
    
    eval {
        $data = $executor->metaColumnsTypeNot('pk','foo','bar');
    };
    $self->assert_equals(-1,$#$data);
    
}

1;
