
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCameraZoomControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCameraZoomControl>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCameraZoomControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCameraZoomControl::staticMetaObject);
}


// double QCameraZoomControl::currentDigitalZoom()


static void _init_f_currentDigitalZoom_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_currentDigitalZoom_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl *)cls)->currentDigitalZoom ());
}


// void QCameraZoomControl::currentDigitalZoomChanged(double digitalZoom)


static void _init_f_currentDigitalZoomChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("digitalZoom");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_currentDigitalZoomChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl *)cls)->currentDigitalZoomChanged (arg1);
}


// double QCameraZoomControl::currentOpticalZoom()


static void _init_f_currentOpticalZoom_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_currentOpticalZoom_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl *)cls)->currentOpticalZoom ());
}


// void QCameraZoomControl::currentOpticalZoomChanged(double opticalZoom)


static void _init_f_currentOpticalZoomChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opticalZoom");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_currentOpticalZoomChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl *)cls)->currentOpticalZoomChanged (arg1);
}


// double QCameraZoomControl::maximumDigitalZoom()


static void _init_f_maximumDigitalZoom_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_maximumDigitalZoom_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl *)cls)->maximumDigitalZoom ());
}


// void QCameraZoomControl::maximumDigitalZoomChanged(double)


static void _init_f_maximumDigitalZoomChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_maximumDigitalZoomChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl *)cls)->maximumDigitalZoomChanged (arg1);
}


// double QCameraZoomControl::maximumOpticalZoom()


static void _init_f_maximumOpticalZoom_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_maximumOpticalZoom_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl *)cls)->maximumOpticalZoom ());
}


// void QCameraZoomControl::maximumOpticalZoomChanged(double)


static void _init_f_maximumOpticalZoomChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_maximumOpticalZoomChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl *)cls)->maximumOpticalZoomChanged (arg1);
}


// double QCameraZoomControl::requestedDigitalZoom()


static void _init_f_requestedDigitalZoom_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_requestedDigitalZoom_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl *)cls)->requestedDigitalZoom ());
}


// void QCameraZoomControl::requestedDigitalZoomChanged(double digitalZoom)


static void _init_f_requestedDigitalZoomChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("digitalZoom");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_requestedDigitalZoomChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl *)cls)->requestedDigitalZoomChanged (arg1);
}


// double QCameraZoomControl::requestedOpticalZoom()


static void _init_f_requestedOpticalZoom_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_requestedOpticalZoom_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl *)cls)->requestedOpticalZoom ());
}


// void QCameraZoomControl::requestedOpticalZoomChanged(double opticalZoom)


static void _init_f_requestedOpticalZoomChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opticalZoom");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_requestedOpticalZoomChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl *)cls)->requestedOpticalZoomChanged (arg1);
}


// void QCameraZoomControl::zoomTo(double optical, double digital)


static void _init_f_zoomTo_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("optical");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("digital");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_zoomTo_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl *)cls)->zoomTo (arg1, arg2);
}


// static QString QCameraZoomControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraZoomControl::tr (arg1, arg2, arg3));
}


// static QString QCameraZoomControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraZoomControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QCameraZoomControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("currentDigitalZoom", "@brief Method double QCameraZoomControl::currentDigitalZoom()\n", true, &_init_f_currentDigitalZoom_c0, &_call_f_currentDigitalZoom_c0);
  methods += new qt_gsi::GenericMethod ("currentDigitalZoomChanged", "@brief Method void QCameraZoomControl::currentDigitalZoomChanged(double digitalZoom)\n", false, &_init_f_currentDigitalZoomChanged_1071, &_call_f_currentDigitalZoomChanged_1071);
  methods += new qt_gsi::GenericMethod ("currentOpticalZoom", "@brief Method double QCameraZoomControl::currentOpticalZoom()\n", true, &_init_f_currentOpticalZoom_c0, &_call_f_currentOpticalZoom_c0);
  methods += new qt_gsi::GenericMethod ("currentOpticalZoomChanged", "@brief Method void QCameraZoomControl::currentOpticalZoomChanged(double opticalZoom)\n", false, &_init_f_currentOpticalZoomChanged_1071, &_call_f_currentOpticalZoomChanged_1071);
  methods += new qt_gsi::GenericMethod ("maximumDigitalZoom", "@brief Method double QCameraZoomControl::maximumDigitalZoom()\n", true, &_init_f_maximumDigitalZoom_c0, &_call_f_maximumDigitalZoom_c0);
  methods += new qt_gsi::GenericMethod ("maximumDigitalZoomChanged", "@brief Method void QCameraZoomControl::maximumDigitalZoomChanged(double)\n", false, &_init_f_maximumDigitalZoomChanged_1071, &_call_f_maximumDigitalZoomChanged_1071);
  methods += new qt_gsi::GenericMethod ("maximumOpticalZoom", "@brief Method double QCameraZoomControl::maximumOpticalZoom()\n", true, &_init_f_maximumOpticalZoom_c0, &_call_f_maximumOpticalZoom_c0);
  methods += new qt_gsi::GenericMethod ("maximumOpticalZoomChanged", "@brief Method void QCameraZoomControl::maximumOpticalZoomChanged(double)\n", false, &_init_f_maximumOpticalZoomChanged_1071, &_call_f_maximumOpticalZoomChanged_1071);
  methods += new qt_gsi::GenericMethod ("requestedDigitalZoom", "@brief Method double QCameraZoomControl::requestedDigitalZoom()\n", true, &_init_f_requestedDigitalZoom_c0, &_call_f_requestedDigitalZoom_c0);
  methods += new qt_gsi::GenericMethod ("requestedDigitalZoomChanged", "@brief Method void QCameraZoomControl::requestedDigitalZoomChanged(double digitalZoom)\n", false, &_init_f_requestedDigitalZoomChanged_1071, &_call_f_requestedDigitalZoomChanged_1071);
  methods += new qt_gsi::GenericMethod ("requestedOpticalZoom", "@brief Method double QCameraZoomControl::requestedOpticalZoom()\n", true, &_init_f_requestedOpticalZoom_c0, &_call_f_requestedOpticalZoom_c0);
  methods += new qt_gsi::GenericMethod ("requestedOpticalZoomChanged", "@brief Method void QCameraZoomControl::requestedOpticalZoomChanged(double opticalZoom)\n", false, &_init_f_requestedOpticalZoomChanged_1071, &_call_f_requestedOpticalZoomChanged_1071);
  methods += new qt_gsi::GenericMethod ("zoomTo", "@brief Method void QCameraZoomControl::zoomTo(double optical, double digital)\n", false, &_init_f_zoomTo_2034, &_call_f_zoomTo_2034);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCameraZoomControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCameraZoomControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QCameraZoomControl> decl_QCameraZoomControl (qtdecl_QMediaControl (), "QtMultimedia", "QCameraZoomControl_Native",
  methods_QCameraZoomControl (),
  "@hide\n@alias QCameraZoomControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QCameraZoomControl> &qtdecl_QCameraZoomControl () { return decl_QCameraZoomControl; }

}


class QCameraZoomControl_Adaptor : public QCameraZoomControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCameraZoomControl_Adaptor();

  //  [adaptor ctor] QCameraZoomControl::QCameraZoomControl()
  QCameraZoomControl_Adaptor() : QCameraZoomControl()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QCameraZoomControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QCameraZoomControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QCameraZoomControl::isSignalConnected(signal);
  }

  //  [expose] int QCameraZoomControl::receivers(const char *signal)
  int fp_QCameraZoomControl_receivers_c1731 (const char *signal) const {
    return QCameraZoomControl::receivers(signal);
  }

  //  [expose] QObject *QCameraZoomControl::sender()
  QObject * fp_QCameraZoomControl_sender_c0 () const {
    return QCameraZoomControl::sender();
  }

  //  [expose] int QCameraZoomControl::senderSignalIndex()
  int fp_QCameraZoomControl_senderSignalIndex_c0 () const {
    return QCameraZoomControl::senderSignalIndex();
  }

  //  [adaptor impl] double QCameraZoomControl::currentDigitalZoom()
  double cbs_currentDigitalZoom_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("currentDigitalZoom");
  }

  virtual double currentDigitalZoom() const
  {
    if (cb_currentDigitalZoom_c0_0.can_issue()) {
      return cb_currentDigitalZoom_c0_0.issue<QCameraZoomControl_Adaptor, double>(&QCameraZoomControl_Adaptor::cbs_currentDigitalZoom_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("currentDigitalZoom");
    }
  }

  //  [adaptor impl] double QCameraZoomControl::currentOpticalZoom()
  double cbs_currentOpticalZoom_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("currentOpticalZoom");
  }

  virtual double currentOpticalZoom() const
  {
    if (cb_currentOpticalZoom_c0_0.can_issue()) {
      return cb_currentOpticalZoom_c0_0.issue<QCameraZoomControl_Adaptor, double>(&QCameraZoomControl_Adaptor::cbs_currentOpticalZoom_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("currentOpticalZoom");
    }
  }

  //  [adaptor impl] bool QCameraZoomControl::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QCameraZoomControl::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCameraZoomControl_Adaptor, bool, QEvent *>(&QCameraZoomControl_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QCameraZoomControl::event(arg1);
    }
  }

  //  [adaptor impl] bool QCameraZoomControl::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QCameraZoomControl::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCameraZoomControl_Adaptor, bool, QObject *, QEvent *>(&QCameraZoomControl_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QCameraZoomControl::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] double QCameraZoomControl::maximumDigitalZoom()
  double cbs_maximumDigitalZoom_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("maximumDigitalZoom");
  }

  virtual double maximumDigitalZoom() const
  {
    if (cb_maximumDigitalZoom_c0_0.can_issue()) {
      return cb_maximumDigitalZoom_c0_0.issue<QCameraZoomControl_Adaptor, double>(&QCameraZoomControl_Adaptor::cbs_maximumDigitalZoom_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("maximumDigitalZoom");
    }
  }

  //  [adaptor impl] double QCameraZoomControl::maximumOpticalZoom()
  double cbs_maximumOpticalZoom_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("maximumOpticalZoom");
  }

  virtual double maximumOpticalZoom() const
  {
    if (cb_maximumOpticalZoom_c0_0.can_issue()) {
      return cb_maximumOpticalZoom_c0_0.issue<QCameraZoomControl_Adaptor, double>(&QCameraZoomControl_Adaptor::cbs_maximumOpticalZoom_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("maximumOpticalZoom");
    }
  }

  //  [adaptor impl] double QCameraZoomControl::requestedDigitalZoom()
  double cbs_requestedDigitalZoom_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("requestedDigitalZoom");
  }

  virtual double requestedDigitalZoom() const
  {
    if (cb_requestedDigitalZoom_c0_0.can_issue()) {
      return cb_requestedDigitalZoom_c0_0.issue<QCameraZoomControl_Adaptor, double>(&QCameraZoomControl_Adaptor::cbs_requestedDigitalZoom_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("requestedDigitalZoom");
    }
  }

  //  [adaptor impl] double QCameraZoomControl::requestedOpticalZoom()
  double cbs_requestedOpticalZoom_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("requestedOpticalZoom");
  }

  virtual double requestedOpticalZoom() const
  {
    if (cb_requestedOpticalZoom_c0_0.can_issue()) {
      return cb_requestedOpticalZoom_c0_0.issue<QCameraZoomControl_Adaptor, double>(&QCameraZoomControl_Adaptor::cbs_requestedOpticalZoom_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("requestedOpticalZoom");
    }
  }

  //  [adaptor impl] void QCameraZoomControl::zoomTo(double optical, double digital)
  void cbs_zoomTo_2034_0(double optical, double digital)
  {
    __SUPPRESS_UNUSED_WARNING (optical);
    __SUPPRESS_UNUSED_WARNING (digital);
    throw qt_gsi::AbstractMethodCalledException("zoomTo");
  }

  virtual void zoomTo(double optical, double digital)
  {
    if (cb_zoomTo_2034_0.can_issue()) {
      cb_zoomTo_2034_0.issue<QCameraZoomControl_Adaptor, double, double>(&QCameraZoomControl_Adaptor::cbs_zoomTo_2034_0, optical, digital);
    } else {
      throw qt_gsi::AbstractMethodCalledException("zoomTo");
    }
  }

  //  [adaptor impl] void QCameraZoomControl::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QCameraZoomControl::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCameraZoomControl_Adaptor, QChildEvent *>(&QCameraZoomControl_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QCameraZoomControl::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QCameraZoomControl::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QCameraZoomControl::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCameraZoomControl_Adaptor, QEvent *>(&QCameraZoomControl_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QCameraZoomControl::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QCameraZoomControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QCameraZoomControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QCameraZoomControl_Adaptor, const QMetaMethod &>(&QCameraZoomControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QCameraZoomControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QCameraZoomControl::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QCameraZoomControl::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCameraZoomControl_Adaptor, QTimerEvent *>(&QCameraZoomControl_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QCameraZoomControl::timerEvent(arg1);
    }
  }

  gsi::Callback cb_currentDigitalZoom_c0_0;
  gsi::Callback cb_currentOpticalZoom_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_maximumDigitalZoom_c0_0;
  gsi::Callback cb_maximumOpticalZoom_c0_0;
  gsi::Callback cb_requestedDigitalZoom_c0_0;
  gsi::Callback cb_requestedOpticalZoom_c0_0;
  gsi::Callback cb_zoomTo_2034_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCameraZoomControl_Adaptor::~QCameraZoomControl_Adaptor() { }

//  Constructor QCameraZoomControl::QCameraZoomControl() (adaptor class)

static void _init_ctor_QCameraZoomControl_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QCameraZoomControl_Adaptor> ();
}

static void _call_ctor_QCameraZoomControl_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCameraZoomControl_Adaptor *> (new QCameraZoomControl_Adaptor ());
}


// void QCameraZoomControl::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// double QCameraZoomControl::currentDigitalZoom()

static void _init_cbs_currentDigitalZoom_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_currentDigitalZoom_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl_Adaptor *)cls)->cbs_currentDigitalZoom_c0_0 ());
}

static void _set_callback_cbs_currentDigitalZoom_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_currentDigitalZoom_c0_0 = cb;
}


// double QCameraZoomControl::currentOpticalZoom()

static void _init_cbs_currentOpticalZoom_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_currentOpticalZoom_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl_Adaptor *)cls)->cbs_currentOpticalZoom_c0_0 ());
}

static void _set_callback_cbs_currentOpticalZoom_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_currentOpticalZoom_c0_0 = cb;
}


// void QCameraZoomControl::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QCameraZoomControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QCameraZoomControl::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraZoomControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCameraZoomControl::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraZoomControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QCameraZoomControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QCameraZoomControl_Adaptor *)cls)->fp_QCameraZoomControl_isSignalConnected_c2394 (arg1));
}


// double QCameraZoomControl::maximumDigitalZoom()

static void _init_cbs_maximumDigitalZoom_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_maximumDigitalZoom_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl_Adaptor *)cls)->cbs_maximumDigitalZoom_c0_0 ());
}

static void _set_callback_cbs_maximumDigitalZoom_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_maximumDigitalZoom_c0_0 = cb;
}


// double QCameraZoomControl::maximumOpticalZoom()

static void _init_cbs_maximumOpticalZoom_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_maximumOpticalZoom_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl_Adaptor *)cls)->cbs_maximumOpticalZoom_c0_0 ());
}

static void _set_callback_cbs_maximumOpticalZoom_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_maximumOpticalZoom_c0_0 = cb;
}


// exposed int QCameraZoomControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QCameraZoomControl_Adaptor *)cls)->fp_QCameraZoomControl_receivers_c1731 (arg1));
}


// double QCameraZoomControl::requestedDigitalZoom()

static void _init_cbs_requestedDigitalZoom_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_requestedDigitalZoom_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl_Adaptor *)cls)->cbs_requestedDigitalZoom_c0_0 ());
}

static void _set_callback_cbs_requestedDigitalZoom_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_requestedDigitalZoom_c0_0 = cb;
}


// double QCameraZoomControl::requestedOpticalZoom()

static void _init_cbs_requestedOpticalZoom_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_requestedOpticalZoom_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl_Adaptor *)cls)->cbs_requestedOpticalZoom_c0_0 ());
}

static void _set_callback_cbs_requestedOpticalZoom_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_requestedOpticalZoom_c0_0 = cb;
}


// exposed QObject *QCameraZoomControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCameraZoomControl_Adaptor *)cls)->fp_QCameraZoomControl_sender_c0 ());
}


// exposed int QCameraZoomControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCameraZoomControl_Adaptor *)cls)->fp_QCameraZoomControl_senderSignalIndex_c0 ());
}


// void QCameraZoomControl::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QCameraZoomControl::zoomTo(double optical, double digital)

static void _init_cbs_zoomTo_2034_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("optical");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("digital");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_zoomTo_2034_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  double arg2 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl_Adaptor *)cls)->cbs_zoomTo_2034_0 (arg1, arg2);
}

static void _set_callback_cbs_zoomTo_2034_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_zoomTo_2034_0 = cb;
}


namespace gsi
{

gsi::Class<QCameraZoomControl> &qtdecl_QCameraZoomControl ();

static gsi::Methods methods_QCameraZoomControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCameraZoomControl::QCameraZoomControl()\nThis method creates an object of class QCameraZoomControl.", &_init_ctor_QCameraZoomControl_Adaptor_0, &_call_ctor_QCameraZoomControl_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCameraZoomControl::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("currentDigitalZoom", "@brief Virtual method double QCameraZoomControl::currentDigitalZoom()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_currentDigitalZoom_c0_0, &_call_cbs_currentDigitalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("currentDigitalZoom", "@hide", true, &_init_cbs_currentDigitalZoom_c0_0, &_call_cbs_currentDigitalZoom_c0_0, &_set_callback_cbs_currentDigitalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("currentOpticalZoom", "@brief Virtual method double QCameraZoomControl::currentOpticalZoom()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_currentOpticalZoom_c0_0, &_call_cbs_currentOpticalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("currentOpticalZoom", "@hide", true, &_init_cbs_currentOpticalZoom_c0_0, &_call_cbs_currentOpticalZoom_c0_0, &_set_callback_cbs_currentOpticalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCameraZoomControl::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCameraZoomControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QCameraZoomControl::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCameraZoomControl::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QCameraZoomControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("maximumDigitalZoom", "@brief Virtual method double QCameraZoomControl::maximumDigitalZoom()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_maximumDigitalZoom_c0_0, &_call_cbs_maximumDigitalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("maximumDigitalZoom", "@hide", true, &_init_cbs_maximumDigitalZoom_c0_0, &_call_cbs_maximumDigitalZoom_c0_0, &_set_callback_cbs_maximumDigitalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("maximumOpticalZoom", "@brief Virtual method double QCameraZoomControl::maximumOpticalZoom()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_maximumOpticalZoom_c0_0, &_call_cbs_maximumOpticalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("maximumOpticalZoom", "@hide", true, &_init_cbs_maximumOpticalZoom_c0_0, &_call_cbs_maximumOpticalZoom_c0_0, &_set_callback_cbs_maximumOpticalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCameraZoomControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("requestedDigitalZoom", "@brief Virtual method double QCameraZoomControl::requestedDigitalZoom()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_requestedDigitalZoom_c0_0, &_call_cbs_requestedDigitalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("requestedDigitalZoom", "@hide", true, &_init_cbs_requestedDigitalZoom_c0_0, &_call_cbs_requestedDigitalZoom_c0_0, &_set_callback_cbs_requestedDigitalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("requestedOpticalZoom", "@brief Virtual method double QCameraZoomControl::requestedOpticalZoom()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_requestedOpticalZoom_c0_0, &_call_cbs_requestedOpticalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("requestedOpticalZoom", "@hide", true, &_init_cbs_requestedOpticalZoom_c0_0, &_call_cbs_requestedOpticalZoom_c0_0, &_set_callback_cbs_requestedOpticalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCameraZoomControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QCameraZoomControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCameraZoomControl::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("zoomTo", "@brief Virtual method void QCameraZoomControl::zoomTo(double optical, double digital)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_zoomTo_2034_0, &_call_cbs_zoomTo_2034_0);
  methods += new qt_gsi::GenericMethod ("zoomTo", "@hide", false, &_init_cbs_zoomTo_2034_0, &_call_cbs_zoomTo_2034_0, &_set_callback_cbs_zoomTo_2034_0);
  return methods;
}

gsi::Class<QCameraZoomControl_Adaptor> decl_QCameraZoomControl_Adaptor (qtdecl_QCameraZoomControl (), "QtMultimedia", "QCameraZoomControl",
  methods_QCameraZoomControl_Adaptor (),
  "@qt\n@brief Binding of QCameraZoomControl");

}

