/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef CONNECTIONDIALOG_H
#define CONNECTIONDIALOG_H

#include <QtGui/QDialog>

#include "connectioninfomanager.h"

class QComboBox;
class QLineEdit;
class QListWidget;
class QPushButton;
class QSpinBox;

class ConnectionDialog : public QDialog
{
  Q_OBJECT

  public:
    ConnectionDialog( QWidget *parent = 0 );

  public Q_SLOTS:
    virtual void accept();
    void configure();

  private:
    void updateButtonState();
    void updateConnectionBox();

    QComboBox *mConnection;
    QLineEdit *mUser;
    QLineEdit *mPassword;
    QPushButton *mOkButton;

    ConnectionInfoManager mConnectionInfoManager;
};

class ConfigureDialog : public QDialog
{
  Q_OBJECT

  public:
    ConfigureDialog( ConnectionInfoManager *manager, QWidget *parent = 0 );

  private Q_SLOTS:
    void add();
    void edit();
    void remove();

  private:
    QListWidget *mWidget;
    ConnectionInfoManager *mManager;
};

class ConnectionInfoDialog : public QDialog
{
  Q_OBJECT

  public:
    ConnectionInfoDialog( QWidget *parent = 0 );

    void setConnectionInfo( const ConnectionInfo &connectionInfo );
    ConnectionInfo connectionInfo() const;

  public Q_SLOTS:
    virtual void accept();

  private:
    QLineEdit *mName;
    QLineEdit *mHost;
    QSpinBox *mPort;
    QLineEdit *mBaseDn;
    QLineEdit *mUser;
    QLineEdit *mPassword;
};

#endif
