/***************************************************************************
 *   Copyright (C) 2009-2013 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <QListWidget>

#include <KDebug>
#include <KLocale>

#include "komparatordynamicerrordialog.h"

KomparatorDynamicErrorDialog::KomparatorDynamicErrorDialog( QWidget *_parent ) :
	KDialog( _parent ), m_list_widget( new QListWidget( this ) )
{
	setCaption( i18n( "File compare dialog" ) );
	KDialog::setButtons( KDialog::Ok );

	setCaption( i18n( "Komparator4" ) );

	setMainWidget( m_list_widget );
}

KomparatorDynamicErrorDialog::~KomparatorDynamicErrorDialog()
{
}

void KomparatorDynamicErrorDialog::slotAddErrorMessage( const QString &message )
{
	m_list_widget->addItem( message );
	KDialog::show();
}

void KomparatorDynamicErrorDialog::slotButtonClicked( int button )
{
	if ( button == KDialog::Ok )
	{
		KDialog::accept();
		KDialog::hide();
		m_list_widget->clear();
	}
	else
	{
		KDialog::slotButtonClicked( button );
	}
}
