/*
  File autogenerated by gengetopt version 2.22.1
  generated with the following command:
  /usr/local/bin/gengetopt 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "This program computes zeros and values of L-function.";

const char *gengetopt_args_info_usage = "Usage: lcalc [OPTIONS]...";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "  -v, --value                   compute L-function at x+iy. Should be used in \n                                  conjuction with x and y options  \n                                  (default=off)",
  "  -x, --x=Double                Used with value,value-line-segment, and \n                                  zeros-interval options  (default=`.5')",
  "  -y, --y=Double                Used with value,value-line-segment, and \n                                  zeros-interval options  (default=`0')",
  "      --value-file=filename     compute L-function at points specified in file",
  "      --value-line-segment      compute L-function along a line segment \n                                  connecting (x,y) to (X,Y) at number-sample \n                                  points  (default=off)",
  "      --use-dirichlet-series=INT\n                                compute values of the L-function using \n                                  specified number of terms of the Dirichlet \n                                  series rather than an approximate functional \n                                  equation.",
  "      --hardy                   compute the Hardy Z function, i.e. the \n                                  L-function rotated to be real on the critical \n                                  line  (default=off)",
  "  -X, --X=Double                Used with value-line-segment  (default=`.5')",
  "  -Y, --Y=Double                Used with value-line-segment  (default=`100')",
  "  -n, --number-samples=INT      Used with value-line-segment, and interpolate \n                                  options  (default=`1000')",
  "  -z, --zeros=INT               number of zeros to find",
  "      --explicit                test the explicit formula (beta-still in \n                                  development)  (default=off)",
  "  -Z, --zeros-interval          number of zeros to find in an interval \n                                  (1/2+ix,1/2+iy) using steps of size stepsize. \n                                  Use with the x,y, and stepsize options  \n                                  (default=off)",
  "      --stepsize=Double         Used with zeros-interval",
  "  -d, --derivative=INT          compute derivative. use -d -1 to specify \n                                  logarithmic derivative.",
  "  -e, --elliptic-curve          specify an elliptic curve over Q. Use with the \n                                  a1 a2 a3 a4 a6 options  (default=off)",
  "      --a1=rational_number      Used with the elliptic-curve option",
  "      --a2=rational_number      Used with the elliptic-curve option",
  "      --a3=rational_number      Used with the elliptic-curve option",
  "      --a4=rational_number      Used with the elliptic-curve option",
  "      --a6=rational_number      Used with the elliptic-curve option",
  "  -F, --file-input=filename     input a file with basic L-function data",
  "  -u, --url=url                 input a web based file with basic L-function \n                                  data. Specify the url of the file",
  "  -i, --interpolate=filename2   interpolate between two L-functions and find \n                                  their zeros. Should be used in conjunction \n                                  with file-input",
  "  -C, --output-character=STRING if twisting, output the character  (possible \n                                  values=\"1\", \"2\" default=`1')",
  "  -o, --output-data=number Dirichlet coeffs\n                                output basic data for the underlying L-function \n                                   (default=`10')",
  "      --verbose=INT             verbosity > 0 outputs extra info  (default=`0')",
  "  -P, --precision=INT           number digits precision  (default=`14')",
  "  -S, --sacrifice=INT           number digits to sacrifice  (default=`2')",
  "  -r, --rank-compute            compute the rank  (default=off)",
  "      --rank-verify=INT         verify if specified rank is correct",
  "  -l, --rank-limit=INT          when doing quadratic twists limit to \n                                  L-functions with specified rank",
  "  -t, --tau                     Ramanujan tau L-function (weight 12, full \n                                  level)  (default=off)",
  "  -q, --twist-quadratic         twist by fundamental quadratic characters, \n                                  start <= discriminant <= finish. Use with \n                                  start and finish options.  (default=off)",
  "  -s, --start=integer           Used with various twisting options",
  "  -f, --finish=integer          Used with various twisting options. Default has \n                                  finish=start",
  "      --twist-quadratic-even    twist by fundamental quadratic characters, even \n                                  functional eqn, start <= discriminant <= \n                                  finish  (default=off)",
  "  -p, --twist-primitive         twist by all primitive Dirichlet characters \n                                  with start <= conductor <= finish. For \n                                  L-functions with complex Dirichlet \n                                  coefficients, conjugate characters are \n                                  considered equivalent  (default=off)",
  "  -A, --twist-all               twist by all Dirichlet characters with start <= \n                                  conductor <= finish.  (default=off)",
  "  -a, --twist-all-no-conj-pairs twist by all Dirichlet characters with start <= \n                                  conductor <= finish. For L-functions with \n                                  complex Dirichlet coefficients, conjugate \n                                  pairs of characters are considered equivalent \n                                   (default=off)",
  "  -c, --twist-complex-no-conj-pairs\n                                twist by all complex primitive Dirichlet \n                                  characters with start <= conductor <= finish. \n                                  For L-functions with complex Dirichlet \n                                  coefficients, conjugate pairs of characters \n                                  are considered equivalent  (default=off)",
  "  -g, --twist-generic           twist by a generic complex Dirichlet characters \n                                  with start <= conductor <= finish.  \n                                  (default=off)",
  "  -D, --degree=degree           can only be used in conjuction with \n                                  twist-primitive (?). Select characters of \n                                  specified degree. Not yet implemented",
  "  -O, --openmp=INT              whether to use openmp parallelization (beta- \n                                  very little parallelization currently \n                                  implemented) . Specify the number of threads \n                                  to use.",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);


char *cmdline_parser_output_character_values[] = {"1", "2", 0} ;	/* Possible values for output-character.  */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->value_given = 0 ;
  args_info->x_given = 0 ;
  args_info->y_given = 0 ;
  args_info->value_file_given = 0 ;
  args_info->value_line_segment_given = 0 ;
  args_info->use_dirichlet_series_given = 0 ;
  args_info->hardy_given = 0 ;
  args_info->X_given = 0 ;
  args_info->Y_given = 0 ;
  args_info->number_samples_given = 0 ;
  args_info->zeros_given = 0 ;
  args_info->explicit_given = 0 ;
  args_info->zeros_interval_given = 0 ;
  args_info->stepsize_given = 0 ;
  args_info->derivative_given = 0 ;
  args_info->elliptic_curve_given = 0 ;
  args_info->a1_given = 0 ;
  args_info->a2_given = 0 ;
  args_info->a3_given = 0 ;
  args_info->a4_given = 0 ;
  args_info->a6_given = 0 ;
  args_info->file_input_given = 0 ;
  args_info->url_given = 0 ;
  args_info->interpolate_given = 0 ;
  args_info->output_character_given = 0 ;
  args_info->output_data_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->precision_given = 0 ;
  args_info->sacrifice_given = 0 ;
  args_info->rank_compute_given = 0 ;
  args_info->rank_verify_given = 0 ;
  args_info->rank_limit_given = 0 ;
  args_info->tau_given = 0 ;
  args_info->twist_quadratic_given = 0 ;
  args_info->start_given = 0 ;
  args_info->finish_given = 0 ;
  args_info->twist_quadratic_even_given = 0 ;
  args_info->twist_primitive_given = 0 ;
  args_info->twist_all_given = 0 ;
  args_info->twist_all_no_conj_pairs_given = 0 ;
  args_info->twist_complex_no_conj_pairs_given = 0 ;
  args_info->twist_generic_given = 0 ;
  args_info->degree_given = 0 ;
  args_info->openmp_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->value_flag = 0;
  args_info->x_arg = gengetopt_strdup (".5");
  args_info->x_orig = NULL;
  args_info->y_arg = gengetopt_strdup ("0");
  args_info->y_orig = NULL;
  args_info->value_file_arg = NULL;
  args_info->value_file_orig = NULL;
  args_info->value_line_segment_flag = 0;
  args_info->use_dirichlet_series_orig = NULL;
  args_info->hardy_flag = 0;
  args_info->X_arg = gengetopt_strdup (".5");
  args_info->X_orig = NULL;
  args_info->Y_arg = gengetopt_strdup ("100");
  args_info->Y_orig = NULL;
  args_info->number_samples_arg = 1000;
  args_info->number_samples_orig = NULL;
  args_info->zeros_orig = NULL;
  args_info->explicit_flag = 0;
  args_info->zeros_interval_flag = 0;
  args_info->stepsize_arg = NULL;
  args_info->stepsize_orig = NULL;
  args_info->derivative_orig = NULL;
  args_info->elliptic_curve_flag = 0;
  args_info->a1_arg = NULL;
  args_info->a1_orig = NULL;
  args_info->a2_arg = NULL;
  args_info->a2_orig = NULL;
  args_info->a3_arg = NULL;
  args_info->a3_orig = NULL;
  args_info->a4_arg = NULL;
  args_info->a4_orig = NULL;
  args_info->a6_arg = NULL;
  args_info->a6_orig = NULL;
  args_info->file_input_arg = NULL;
  args_info->file_input_orig = NULL;
  args_info->url_arg = NULL;
  args_info->url_orig = NULL;
  args_info->interpolate_arg = NULL;
  args_info->interpolate_orig = NULL;
  args_info->output_character_arg = gengetopt_strdup ("1");
  args_info->output_character_orig = NULL;
  args_info->output_data_arg = 10;
  args_info->output_data_orig = NULL;
  args_info->verbose_arg = 0;
  args_info->verbose_orig = NULL;
  args_info->precision_arg = 14;
  args_info->precision_orig = NULL;
  args_info->sacrifice_arg = 2;
  args_info->sacrifice_orig = NULL;
  args_info->rank_compute_flag = 0;
  args_info->rank_verify_orig = NULL;
  args_info->rank_limit_orig = NULL;
  args_info->tau_flag = 0;
  args_info->twist_quadratic_flag = 0;
  args_info->start_arg = NULL;
  args_info->start_orig = NULL;
  args_info->finish_arg = NULL;
  args_info->finish_orig = NULL;
  args_info->twist_quadratic_even_flag = 0;
  args_info->twist_primitive_flag = 0;
  args_info->twist_all_flag = 0;
  args_info->twist_all_no_conj_pairs_flag = 0;
  args_info->twist_complex_no_conj_pairs_flag = 0;
  args_info->twist_generic_flag = 0;
  args_info->degree_orig = NULL;
  args_info->openmp_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->value_help = gengetopt_args_info_help[2] ;
  args_info->x_help = gengetopt_args_info_help[3] ;
  args_info->y_help = gengetopt_args_info_help[4] ;
  args_info->value_file_help = gengetopt_args_info_help[5] ;
  args_info->value_line_segment_help = gengetopt_args_info_help[6] ;
  args_info->use_dirichlet_series_help = gengetopt_args_info_help[7] ;
  args_info->hardy_help = gengetopt_args_info_help[8] ;
  args_info->X_help = gengetopt_args_info_help[9] ;
  args_info->Y_help = gengetopt_args_info_help[10] ;
  args_info->number_samples_help = gengetopt_args_info_help[11] ;
  args_info->zeros_help = gengetopt_args_info_help[12] ;
  args_info->explicit_help = gengetopt_args_info_help[13] ;
  args_info->zeros_interval_help = gengetopt_args_info_help[14] ;
  args_info->stepsize_help = gengetopt_args_info_help[15] ;
  args_info->derivative_help = gengetopt_args_info_help[16] ;
  args_info->elliptic_curve_help = gengetopt_args_info_help[17] ;
  args_info->a1_help = gengetopt_args_info_help[18] ;
  args_info->a2_help = gengetopt_args_info_help[19] ;
  args_info->a3_help = gengetopt_args_info_help[20] ;
  args_info->a4_help = gengetopt_args_info_help[21] ;
  args_info->a6_help = gengetopt_args_info_help[22] ;
  args_info->file_input_help = gengetopt_args_info_help[23] ;
  args_info->url_help = gengetopt_args_info_help[24] ;
  args_info->interpolate_help = gengetopt_args_info_help[25] ;
  args_info->output_character_help = gengetopt_args_info_help[26] ;
  args_info->output_data_help = gengetopt_args_info_help[27] ;
  args_info->verbose_help = gengetopt_args_info_help[28] ;
  args_info->precision_help = gengetopt_args_info_help[29] ;
  args_info->sacrifice_help = gengetopt_args_info_help[30] ;
  args_info->rank_compute_help = gengetopt_args_info_help[31] ;
  args_info->rank_verify_help = gengetopt_args_info_help[32] ;
  args_info->rank_limit_help = gengetopt_args_info_help[33] ;
  args_info->tau_help = gengetopt_args_info_help[34] ;
  args_info->twist_quadratic_help = gengetopt_args_info_help[35] ;
  args_info->start_help = gengetopt_args_info_help[36] ;
  args_info->finish_help = gengetopt_args_info_help[37] ;
  args_info->twist_quadratic_even_help = gengetopt_args_info_help[38] ;
  args_info->twist_primitive_help = gengetopt_args_info_help[39] ;
  args_info->twist_all_help = gengetopt_args_info_help[40] ;
  args_info->twist_all_no_conj_pairs_help = gengetopt_args_info_help[41] ;
  args_info->twist_complex_no_conj_pairs_help = gengetopt_args_info_help[42] ;
  args_info->twist_generic_help = gengetopt_args_info_help[43] ;
  args_info->degree_help = gengetopt_args_info_help[44] ;
  args_info->openmp_help = gengetopt_args_info_help[45] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->x_arg));
  free_string_field (&(args_info->x_orig));
  free_string_field (&(args_info->y_arg));
  free_string_field (&(args_info->y_orig));
  free_string_field (&(args_info->value_file_arg));
  free_string_field (&(args_info->value_file_orig));
  free_string_field (&(args_info->use_dirichlet_series_orig));
  free_string_field (&(args_info->X_arg));
  free_string_field (&(args_info->X_orig));
  free_string_field (&(args_info->Y_arg));
  free_string_field (&(args_info->Y_orig));
  free_string_field (&(args_info->number_samples_orig));
  free_string_field (&(args_info->zeros_orig));
  free_string_field (&(args_info->stepsize_arg));
  free_string_field (&(args_info->stepsize_orig));
  free_string_field (&(args_info->derivative_orig));
  free_string_field (&(args_info->a1_arg));
  free_string_field (&(args_info->a1_orig));
  free_string_field (&(args_info->a2_arg));
  free_string_field (&(args_info->a2_orig));
  free_string_field (&(args_info->a3_arg));
  free_string_field (&(args_info->a3_orig));
  free_string_field (&(args_info->a4_arg));
  free_string_field (&(args_info->a4_orig));
  free_string_field (&(args_info->a6_arg));
  free_string_field (&(args_info->a6_orig));
  free_string_field (&(args_info->file_input_arg));
  free_string_field (&(args_info->file_input_orig));
  free_string_field (&(args_info->url_arg));
  free_string_field (&(args_info->url_orig));
  free_string_field (&(args_info->interpolate_arg));
  free_string_field (&(args_info->interpolate_orig));
  free_string_field (&(args_info->output_character_arg));
  free_string_field (&(args_info->output_character_orig));
  free_string_field (&(args_info->output_data_orig));
  free_string_field (&(args_info->verbose_orig));
  free_string_field (&(args_info->precision_orig));
  free_string_field (&(args_info->sacrifice_orig));
  free_string_field (&(args_info->rank_verify_orig));
  free_string_field (&(args_info->rank_limit_orig));
  free_string_field (&(args_info->start_arg));
  free_string_field (&(args_info->start_orig));
  free_string_field (&(args_info->finish_arg));
  free_string_field (&(args_info->finish_orig));
  free_string_field (&(args_info->degree_orig));
  free_string_field (&(args_info->openmp_orig));
  
  

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->value_given)
    write_into_file(outfile, "value", 0, 0 );
  if (args_info->x_given)
    write_into_file(outfile, "x", args_info->x_orig, 0);
  if (args_info->y_given)
    write_into_file(outfile, "y", args_info->y_orig, 0);
  if (args_info->value_file_given)
    write_into_file(outfile, "value-file", args_info->value_file_orig, 0);
  if (args_info->value_line_segment_given)
    write_into_file(outfile, "value-line-segment", 0, 0 );
  if (args_info->use_dirichlet_series_given)
    write_into_file(outfile, "use-dirichlet-series", args_info->use_dirichlet_series_orig, 0);
  if (args_info->hardy_given)
    write_into_file(outfile, "hardy", 0, 0 );
  if (args_info->X_given)
    write_into_file(outfile, "X", args_info->X_orig, 0);
  if (args_info->Y_given)
    write_into_file(outfile, "Y", args_info->Y_orig, 0);
  if (args_info->number_samples_given)
    write_into_file(outfile, "number-samples", args_info->number_samples_orig, 0);
  if (args_info->zeros_given)
    write_into_file(outfile, "zeros", args_info->zeros_orig, 0);
  if (args_info->explicit_given)
    write_into_file(outfile, "explicit", 0, 0 );
  if (args_info->zeros_interval_given)
    write_into_file(outfile, "zeros-interval", 0, 0 );
  if (args_info->stepsize_given)
    write_into_file(outfile, "stepsize", args_info->stepsize_orig, 0);
  if (args_info->derivative_given)
    write_into_file(outfile, "derivative", args_info->derivative_orig, 0);
  if (args_info->elliptic_curve_given)
    write_into_file(outfile, "elliptic-curve", 0, 0 );
  if (args_info->a1_given)
    write_into_file(outfile, "a1", args_info->a1_orig, 0);
  if (args_info->a2_given)
    write_into_file(outfile, "a2", args_info->a2_orig, 0);
  if (args_info->a3_given)
    write_into_file(outfile, "a3", args_info->a3_orig, 0);
  if (args_info->a4_given)
    write_into_file(outfile, "a4", args_info->a4_orig, 0);
  if (args_info->a6_given)
    write_into_file(outfile, "a6", args_info->a6_orig, 0);
  if (args_info->file_input_given)
    write_into_file(outfile, "file-input", args_info->file_input_orig, 0);
  if (args_info->url_given)
    write_into_file(outfile, "url", args_info->url_orig, 0);
  if (args_info->interpolate_given)
    write_into_file(outfile, "interpolate", args_info->interpolate_orig, 0);
  if (args_info->output_character_given)
    write_into_file(outfile, "output-character", args_info->output_character_orig, cmdline_parser_output_character_values);
  if (args_info->output_data_given)
    write_into_file(outfile, "output-data", args_info->output_data_orig, 0);
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", args_info->verbose_orig, 0);
  if (args_info->precision_given)
    write_into_file(outfile, "precision", args_info->precision_orig, 0);
  if (args_info->sacrifice_given)
    write_into_file(outfile, "sacrifice", args_info->sacrifice_orig, 0);
  if (args_info->rank_compute_given)
    write_into_file(outfile, "rank-compute", 0, 0 );
  if (args_info->rank_verify_given)
    write_into_file(outfile, "rank-verify", args_info->rank_verify_orig, 0);
  if (args_info->rank_limit_given)
    write_into_file(outfile, "rank-limit", args_info->rank_limit_orig, 0);
  if (args_info->tau_given)
    write_into_file(outfile, "tau", 0, 0 );
  if (args_info->twist_quadratic_given)
    write_into_file(outfile, "twist-quadratic", 0, 0 );
  if (args_info->start_given)
    write_into_file(outfile, "start", args_info->start_orig, 0);
  if (args_info->finish_given)
    write_into_file(outfile, "finish", args_info->finish_orig, 0);
  if (args_info->twist_quadratic_even_given)
    write_into_file(outfile, "twist-quadratic-even", 0, 0 );
  if (args_info->twist_primitive_given)
    write_into_file(outfile, "twist-primitive", 0, 0 );
  if (args_info->twist_all_given)
    write_into_file(outfile, "twist-all", 0, 0 );
  if (args_info->twist_all_no_conj_pairs_given)
    write_into_file(outfile, "twist-all-no-conj-pairs", 0, 0 );
  if (args_info->twist_complex_no_conj_pairs_given)
    write_into_file(outfile, "twist-complex-no-conj-pairs", 0, 0 );
  if (args_info->twist_generic_given)
    write_into_file(outfile, "twist-generic", 0, 0 );
  if (args_info->degree_given)
    write_into_file(outfile, "degree", args_info->degree_orig, 0);
  if (args_info->openmp_given)
    write_into_file(outfile, "openmp", args_info->openmp_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  return EXIT_SUCCESS;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, char *possible_values[], const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "value",	0, NULL, 'v' },
        { "x",	1, NULL, 'x' },
        { "y",	1, NULL, 'y' },
        { "value-file",	1, NULL, 0 },
        { "value-line-segment",	0, NULL, 0 },
        { "use-dirichlet-series",	1, NULL, 0 },
        { "hardy",	0, NULL, 0 },
        { "X",	1, NULL, 'X' },
        { "Y",	1, NULL, 'Y' },
        { "number-samples",	1, NULL, 'n' },
        { "zeros",	1, NULL, 'z' },
        { "explicit",	0, NULL, 0 },
        { "zeros-interval",	0, NULL, 'Z' },
        { "stepsize",	1, NULL, 0 },
        { "derivative",	1, NULL, 'd' },
        { "elliptic-curve",	0, NULL, 'e' },
        { "a1",	1, NULL, 0 },
        { "a2",	1, NULL, 0 },
        { "a3",	1, NULL, 0 },
        { "a4",	1, NULL, 0 },
        { "a6",	1, NULL, 0 },
        { "file-input",	1, NULL, 'F' },
        { "url",	1, NULL, 'u' },
        { "interpolate",	1, NULL, 'i' },
        { "output-character",	1, NULL, 'C' },
        { "output-data",	1, NULL, 'o' },
        { "verbose",	1, NULL, 0 },
        { "precision",	1, NULL, 'P' },
        { "sacrifice",	1, NULL, 'S' },
        { "rank-compute",	0, NULL, 'r' },
        { "rank-verify",	1, NULL, 0 },
        { "rank-limit",	1, NULL, 'l' },
        { "tau",	0, NULL, 't' },
        { "twist-quadratic",	0, NULL, 'q' },
        { "start",	1, NULL, 's' },
        { "finish",	1, NULL, 'f' },
        { "twist-quadratic-even",	0, NULL, 0 },
        { "twist-primitive",	0, NULL, 'p' },
        { "twist-all",	0, NULL, 'A' },
        { "twist-all-no-conj-pairs",	0, NULL, 'a' },
        { "twist-complex-no-conj-pairs",	0, NULL, 'c' },
        { "twist-generic",	0, NULL, 'g' },
        { "degree",	1, NULL, 'D' },
        { "openmp",	1, NULL, 'O' },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVvx:y:X:Y:n:z:Zd:eF:u:i:C:o:P:S:rl:tqs:f:pAacgD:O:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'v':	/* compute L-function at x+iy. Should be used in conjuction with x and y options.  */
        
        
          if (update_arg((void *)&(args_info->value_flag), 0, &(args_info->value_given),
              &(local_args_info.value_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "value", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'x':	/* Used with value,value-line-segment, and zeros-interval options.  */
        
        
          if (update_arg( (void *)&(args_info->x_arg), 
               &(args_info->x_orig), &(args_info->x_given),
              &(local_args_info.x_given), optarg, 0, ".5", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "x", 'x',
              additional_error))
            goto failure;
        
          break;
        case 'y':	/* Used with value,value-line-segment, and zeros-interval options.  */
        
        
          if (update_arg( (void *)&(args_info->y_arg), 
               &(args_info->y_orig), &(args_info->y_given),
              &(local_args_info.y_given), optarg, 0, "0", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "y", 'y',
              additional_error))
            goto failure;
        
          break;
        case 'X':	/* Used with value-line-segment.  */
        
        
          if (update_arg( (void *)&(args_info->X_arg), 
               &(args_info->X_orig), &(args_info->X_given),
              &(local_args_info.X_given), optarg, 0, ".5", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "X", 'X',
              additional_error))
            goto failure;
        
          break;
        case 'Y':	/* Used with value-line-segment.  */
        
        
          if (update_arg( (void *)&(args_info->Y_arg), 
               &(args_info->Y_orig), &(args_info->Y_given),
              &(local_args_info.Y_given), optarg, 0, "100", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "Y", 'Y',
              additional_error))
            goto failure;
        
          break;
        case 'n':	/* Used with value-line-segment, and interpolate options.  */
        
        
          if (update_arg( (void *)&(args_info->number_samples_arg), 
               &(args_info->number_samples_orig), &(args_info->number_samples_given),
              &(local_args_info.number_samples_given), optarg, 0, "1000", ARG_INT,
              check_ambiguity, override, 0, 0,
              "number-samples", 'n',
              additional_error))
            goto failure;
        
          break;
        case 'z':	/* number of zeros to find.  */
        
        
          if (update_arg( (void *)&(args_info->zeros_arg), 
               &(args_info->zeros_orig), &(args_info->zeros_given),
              &(local_args_info.zeros_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "zeros", 'z',
              additional_error))
            goto failure;
        
          break;
        case 'Z':	/* number of zeros to find in an interval (1/2+ix,1/2+iy) using steps of size stepsize. Use with the x,y, and stepsize options.  */
        
        
          if (update_arg((void *)&(args_info->zeros_interval_flag), 0, &(args_info->zeros_interval_given),
              &(local_args_info.zeros_interval_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "zeros-interval", 'Z',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* compute derivative. use -d -1 to specify logarithmic derivative..  */
        
        
          if (update_arg( (void *)&(args_info->derivative_arg), 
               &(args_info->derivative_orig), &(args_info->derivative_given),
              &(local_args_info.derivative_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "derivative", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* specify an elliptic curve over Q. Use with the a1 a2 a3 a4 a6 options.  */
        
        
          if (update_arg((void *)&(args_info->elliptic_curve_flag), 0, &(args_info->elliptic_curve_given),
              &(local_args_info.elliptic_curve_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "elliptic-curve", 'e',
              additional_error))
            goto failure;
        
          break;
        case 'F':	/* input a file with basic L-function data.  */
        
        
          if (update_arg( (void *)&(args_info->file_input_arg), 
               &(args_info->file_input_orig), &(args_info->file_input_given),
              &(local_args_info.file_input_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "file-input", 'F',
              additional_error))
            goto failure;
        
          break;
        case 'u':	/* input a web based file with basic L-function data. Specify the url of the file.  */
        
        
          if (update_arg( (void *)&(args_info->url_arg), 
               &(args_info->url_orig), &(args_info->url_given),
              &(local_args_info.url_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "url", 'u',
              additional_error))
            goto failure;
        
          break;
        case 'i':	/* interpolate between two L-functions and find their zeros. Should be used in conjunction with file-input.  */
        
        
          if (update_arg( (void *)&(args_info->interpolate_arg), 
               &(args_info->interpolate_orig), &(args_info->interpolate_given),
              &(local_args_info.interpolate_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "interpolate", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'C':	/* if twisting, output the character.  */
        
        
          if (update_arg( (void *)&(args_info->output_character_arg), 
               &(args_info->output_character_orig), &(args_info->output_character_given),
              &(local_args_info.output_character_given), optarg, cmdline_parser_output_character_values, "1", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output-character", 'C',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* output basic data for the underlying L-function.  */
        
        
          if (update_arg( (void *)&(args_info->output_data_arg), 
               &(args_info->output_data_orig), &(args_info->output_data_given),
              &(local_args_info.output_data_given), optarg, 0, "10", ARG_INT,
              check_ambiguity, override, 0, 0,
              "output-data", 'o',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* number digits precision.  */
        
        
          if (update_arg( (void *)&(args_info->precision_arg), 
               &(args_info->precision_orig), &(args_info->precision_given),
              &(local_args_info.precision_given), optarg, 0, "14", ARG_INT,
              check_ambiguity, override, 0, 0,
              "precision", 'P',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* number digits to sacrifice.  */
        
        
          if (update_arg( (void *)&(args_info->sacrifice_arg), 
               &(args_info->sacrifice_orig), &(args_info->sacrifice_given),
              &(local_args_info.sacrifice_given), optarg, 0, "2", ARG_INT,
              check_ambiguity, override, 0, 0,
              "sacrifice", 'S',
              additional_error))
            goto failure;
        
          break;
        case 'r':	/* compute the rank.  */
        
        
          if (update_arg((void *)&(args_info->rank_compute_flag), 0, &(args_info->rank_compute_given),
              &(local_args_info.rank_compute_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "rank-compute", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'l':	/* when doing quadratic twists limit to L-functions with specified rank.  */
        
        
          if (update_arg( (void *)&(args_info->rank_limit_arg), 
               &(args_info->rank_limit_orig), &(args_info->rank_limit_given),
              &(local_args_info.rank_limit_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "rank-limit", 'l',
              additional_error))
            goto failure;
        
          break;
        case 't':	/* Ramanujan tau L-function (weight 12, full level).  */
        
        
          if (update_arg((void *)&(args_info->tau_flag), 0, &(args_info->tau_given),
              &(local_args_info.tau_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "tau", 't',
              additional_error))
            goto failure;
        
          break;
        case 'q':	/* twist by fundamental quadratic characters, start <= discriminant <= finish. Use with start and finish options..  */
        
        
          if (update_arg((void *)&(args_info->twist_quadratic_flag), 0, &(args_info->twist_quadratic_given),
              &(local_args_info.twist_quadratic_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "twist-quadratic", 'q',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* Used with various twisting options.  */
        
        
          if (update_arg( (void *)&(args_info->start_arg), 
               &(args_info->start_orig), &(args_info->start_given),
              &(local_args_info.start_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "start", 's',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* Used with various twisting options. Default has finish=start.  */
        
        
          if (update_arg( (void *)&(args_info->finish_arg), 
               &(args_info->finish_orig), &(args_info->finish_given),
              &(local_args_info.finish_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "finish", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'p':	/* twist by all primitive Dirichlet characters with start <= conductor <= finish. For L-functions with complex Dirichlet coefficients, conjugate characters are considered equivalent.  */
        
        
          if (update_arg((void *)&(args_info->twist_primitive_flag), 0, &(args_info->twist_primitive_given),
              &(local_args_info.twist_primitive_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "twist-primitive", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'A':	/* twist by all Dirichlet characters with start <= conductor <= finish..  */
        
        
          if (update_arg((void *)&(args_info->twist_all_flag), 0, &(args_info->twist_all_given),
              &(local_args_info.twist_all_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "twist-all", 'A',
              additional_error))
            goto failure;
        
          break;
        case 'a':	/* twist by all Dirichlet characters with start <= conductor <= finish. For L-functions with complex Dirichlet coefficients, conjugate pairs of characters are considered equivalent.  */
        
        
          if (update_arg((void *)&(args_info->twist_all_no_conj_pairs_flag), 0, &(args_info->twist_all_no_conj_pairs_given),
              &(local_args_info.twist_all_no_conj_pairs_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "twist-all-no-conj-pairs", 'a',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* twist by all complex primitive Dirichlet characters with start <= conductor <= finish. For L-functions with complex Dirichlet coefficients, conjugate pairs of characters are considered equivalent.  */
        
        
          if (update_arg((void *)&(args_info->twist_complex_no_conj_pairs_flag), 0, &(args_info->twist_complex_no_conj_pairs_given),
              &(local_args_info.twist_complex_no_conj_pairs_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "twist-complex-no-conj-pairs", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'g':	/* twist by a generic complex Dirichlet characters with start <= conductor <= finish..  */
        
        
          if (update_arg((void *)&(args_info->twist_generic_flag), 0, &(args_info->twist_generic_given),
              &(local_args_info.twist_generic_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "twist-generic", 'g',
              additional_error))
            goto failure;
        
          break;
        case 'D':	/* can only be used in conjuction with twist-primitive (?). Select characters of specified degree. Not yet implemented.  */
        
        
          if (update_arg( (void *)&(args_info->degree_arg), 
               &(args_info->degree_orig), &(args_info->degree_given),
              &(local_args_info.degree_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "degree", 'D',
              additional_error))
            goto failure;
        
          break;
        case 'O':	/* whether to use openmp parallelization (beta- very little parallelization currently implemented) . Specify the number of threads to use..  */
        
        
          if (update_arg( (void *)&(args_info->openmp_arg), 
               &(args_info->openmp_orig), &(args_info->openmp_given),
              &(local_args_info.openmp_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "openmp", 'O',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* compute L-function at points specified in file.  */
          if (strcmp (long_options[option_index].name, "value-file") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->value_file_arg), 
                 &(args_info->value_file_orig), &(args_info->value_file_given),
                &(local_args_info.value_file_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "value-file", '-',
                additional_error))
              goto failure;
          
          }
          /* compute L-function along a line segment connecting (x,y) to (X,Y) at number-sample points.  */
          else if (strcmp (long_options[option_index].name, "value-line-segment") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->value_line_segment_flag), 0, &(args_info->value_line_segment_given),
                &(local_args_info.value_line_segment_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "value-line-segment", '-',
                additional_error))
              goto failure;
          
          }
          /* compute values of the L-function using specified number of terms of the Dirichlet series rather than an approximate functional equation..  */
          else if (strcmp (long_options[option_index].name, "use-dirichlet-series") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->use_dirichlet_series_arg), 
                 &(args_info->use_dirichlet_series_orig), &(args_info->use_dirichlet_series_given),
                &(local_args_info.use_dirichlet_series_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "use-dirichlet-series", '-',
                additional_error))
              goto failure;
          
          }
          /* compute the Hardy Z function, i.e. the L-function rotated to be real on the critical line.  */
          else if (strcmp (long_options[option_index].name, "hardy") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->hardy_flag), 0, &(args_info->hardy_given),
                &(local_args_info.hardy_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "hardy", '-',
                additional_error))
              goto failure;
          
          }
          /* test the explicit formula (beta-still in development).  */
          else if (strcmp (long_options[option_index].name, "explicit") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->explicit_flag), 0, &(args_info->explicit_given),
                &(local_args_info.explicit_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "explicit", '-',
                additional_error))
              goto failure;
          
          }
          /* Used with zeros-interval.  */
          else if (strcmp (long_options[option_index].name, "stepsize") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->stepsize_arg), 
                 &(args_info->stepsize_orig), &(args_info->stepsize_given),
                &(local_args_info.stepsize_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "stepsize", '-',
                additional_error))
              goto failure;
          
          }
          /* Used with the elliptic-curve option.  */
          else if (strcmp (long_options[option_index].name, "a1") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->a1_arg), 
                 &(args_info->a1_orig), &(args_info->a1_given),
                &(local_args_info.a1_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "a1", '-',
                additional_error))
              goto failure;
          
          }
          /* Used with the elliptic-curve option.  */
          else if (strcmp (long_options[option_index].name, "a2") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->a2_arg), 
                 &(args_info->a2_orig), &(args_info->a2_given),
                &(local_args_info.a2_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "a2", '-',
                additional_error))
              goto failure;
          
          }
          /* Used with the elliptic-curve option.  */
          else if (strcmp (long_options[option_index].name, "a3") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->a3_arg), 
                 &(args_info->a3_orig), &(args_info->a3_given),
                &(local_args_info.a3_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "a3", '-',
                additional_error))
              goto failure;
          
          }
          /* Used with the elliptic-curve option.  */
          else if (strcmp (long_options[option_index].name, "a4") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->a4_arg), 
                 &(args_info->a4_orig), &(args_info->a4_given),
                &(local_args_info.a4_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "a4", '-',
                additional_error))
              goto failure;
          
          }
          /* Used with the elliptic-curve option.  */
          else if (strcmp (long_options[option_index].name, "a6") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->a6_arg), 
                 &(args_info->a6_orig), &(args_info->a6_given),
                &(local_args_info.a6_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "a6", '-',
                additional_error))
              goto failure;
          
          }
          /* verbosity > 0 outputs extra info.  */
          else if (strcmp (long_options[option_index].name, "verbose") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->verbose_arg), 
                 &(args_info->verbose_orig), &(args_info->verbose_given),
                &(local_args_info.verbose_given), optarg, 0, "0", ARG_INT,
                check_ambiguity, override, 0, 0,
                "verbose", '-',
                additional_error))
              goto failure;
          
          }
          /* verify if specified rank is correct.  */
          else if (strcmp (long_options[option_index].name, "rank-verify") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->rank_verify_arg), 
                 &(args_info->rank_verify_orig), &(args_info->rank_verify_given),
                &(local_args_info.rank_verify_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "rank-verify", '-',
                additional_error))
              goto failure;
          
          }
          /* twist by fundamental quadratic characters, even functional eqn, start <= discriminant <= finish.  */
          else if (strcmp (long_options[option_index].name, "twist-quadratic-even") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->twist_quadratic_even_flag), 0, &(args_info->twist_quadratic_even_given),
                &(local_args_info.twist_quadratic_even_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "twist-quadratic-even", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
