dnl Licensed under the Apache License, Version 2.0 (the "License");
dnl you may not use this file except in compliance with the License.
dnl You may obtain a copy of the License at
dnl 
dnl     http://www.apache.org/licenses/LICENSE-2.0
dnl 
dnl Unless required by applicable law or agreed to in writing, software
dnl distributed under the License is distributed on an "AS IS" BASIS,
dnl WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
dnl See the License for the specific language governing permissions and
dnl limitations under the License.
dnl 
dnl Authors (based on EGEE gLite-security.m4):
dnl 2010-
dnl     Oscar Koeroo <okoeroo@nikhef.nl>
dnl     Mischa Sall\'e <msalle@nikhef.nl>
dnl     NIKHEF Amsterdam, the Netherlands
dnl
dnl  VOMS_CFLAGS
dnl  VOMS_LIBS 
dnl  VOMS_CPP_LIBS
dnl  VOMS_STATIC_LIBS
dnl  VOMS_THR_LIBS
dnl  VOMS_NOTHR_LIBS
dnl  VOMS_CPP_THR_LIBS
dnl  VOMS_CPP_NOTHR_LIBS
dnl  VOMS_STATIC_THR_LIBS
dnl  VOMS_STATIC_NOTHR_LIBS

dnl Optional arguments:
dnl	C   - test only C api
dnl     CPP - test only CPP api
dnl without arguments test both

AC_DEFUN([AC_VOMS],
[
    dnl Make sure autoconf (bootstrap) fails when macro is undefined
    ifdef([PKG_CHECK_MODULES],
          [],
          [m4_fatal([macro PKG_CHECK_MODULES is not defined])])

    dnl check for explicit --with... flag first
    AC_ARG_WITH([voms-prefix],
        [AS_HELP_STRING([--with-voms-prefix=PFX],
	    [prefix where VOMS is installed (default is /usr)])],
        [ac_voms_prefix=$withval],
        [ac_voms_prefix=/usr])

    AC_ARG_WITH([voms-includes],
        [AS_HELP_STRING([--with-voms-includes=DIR],
	    [directory where VOMS headers are installed (default is VOMS-PREFIX/include)])],
        [ac_voms_includes=$withval],
        [ac_voms_includes=$ac_voms_prefix/include])

    AC_ARG_WITH([voms-libdir],
        [AS_HELP_STRING([--with-voms-libdir=DIR],
	    [directory where VOMS libraries are installed (default is VOMS-PREFIX/lib or VOMS_PREFIX/lib64)])],
        [ac_voms_libdir=$withval],
        [])

    dnl when no --with-voms-prefix is specified, try pkg_config
    have_voms_pkgconfig=no
    if test "x$with_voms_prefix" = "x" -a \
	    "x$with_voms_includes" = "x" -a \
	    "x$with_voms_libdir" = "x"  ; then
	PKG_CHECK_MODULES([VOMS], [voms-2.0],
	    [have_voms=yes],
	    [PKG_CHECK_MODULES([VOMS], [voms-1.0],
		[have_voms=yes], [have_voms=no])]
	)
	if test "$have_voms" = "no" ; then
	    AC_VOMS_DIRECT(VOMS$1, have_voms=yes, have_voms=no)
	else
	    dnl pkg-config ONLY sets VOMS_LIBS!
	    VOMS_CPP_LIBS=${VOMS_LIBS}
	fi
    else
	AC_VOMS_DIRECT(VOMS$1, have_voms=yes, have_voms=no)
	if test "$have_voms" = "no" ; then
	    PKG_CHECK_MODULES([VOMS], [voms-2.0],
		[have_voms=yes],
		[PKG_CHECK_MODULES([VOMS], [voms-1.0],
		    [have_voms=yes], [have_voms=no])]
	    )
	    dnl pkg-config ONLY sets VOMS_LIBS!
	    if test "$have_voms" = "yes" ; then
		VOMS_CPP_LIBS=${VOMS_LIBS}
	    fi
	fi
    fi

    VOMS_THR_LIBS=${VOMS_LIBS}
    VOMS_NOTHR_LIBS=${VOMS_LIBS}
    VOMS_CPP_THR_LIBS=${VOMS_CPP_LIBS}
    VOMS_CPP_NOTHR_LIBS=${VOMS_CPP_LIBS}
    AC_SUBST(VOMS_CFLAGS)
    AC_SUBST(VOMS_LIBS)
    AC_SUBST(VOMS_CPP_LIBS)
    AC_SUBST(VOMS_THR_LIBS)
    AC_SUBST(VOMS_NOTHR_LIBS)
    AC_SUBST(VOMS_CPP_THR_LIBS)
    AC_SUBST(VOMS_CPP_NOTHR_LIBS)
])

AC_DEFUN([AC_VOMS_DIRECT],
[
  AC_MSG_CHECKING([for VOMS installation at system default and ${ac_voms_prefix}])

  ac_save_CFLAGS=$CFLAGS
  ac_save_CPPFLAGS=$CPPFLAGS
  ac_save_LIBS=$LIBS
  if test -n "$ac_voms_libdir" ; then
     VOMS_PATH_LIBS="-L$ac_voms_libdir"
  elif test -n "$ac_voms_prefix" ; then
     if test "x$host_cpu" = "xx86_64" \
	 -a -e $ac_voms_prefix/lib64 \
	 -a ! -h $ac_voms_prefix/lib64 ; then
        ac_voms_libdir="$ac_voms_prefix/lib64"
     else
        ac_voms_libdir="$ac_voms_prefix/lib"
     fi
     VOMS_PATH_LIBS="-L$ac_voms_libdir"
  else
     VOMS_PATH_LIBS=""
  fi

  if test "x$ac_voms_includes" != "x" ; then
     VOMS_CFLAGS="-I$ac_voms_includes"
  fi

  dnl Note: for new voms, we always need vomsapi
  VOMS_LIBS="$VOMS_PATH_LIBS -lvomsc -lvomsapi"
  VOMS_CPP_LIBS="$VOMS_PATH_LIBS -lvomsapi"
  VOMS_STATIC_LIBS="$ac_voms_libdir/libvomsc.a"

  if test -n "$GLOBUS_THR_FLAVOR" ; then
     VOMS_THR_LIBS="$VOMS_PATH_LIBS -lvomsc_$GLOBUS_THR_FLAVOR"
     VOMS_CPP_THR_LIBS="$VOMS_PATH_LIBS -lvomsapi_$GLOBUS_THR_FLAVOR"
     VOMS_STATIC_THR_LIBS="$ac_voms_libdir/libvomsc_$GLOBUS_THR_FLAVOR.a"
  else
     VOMS_THR_LIBS=""
     VOMS_CPP_THR_LIBS=""
     VOMS_STATIC_THR_LIBS=""
  fi

  if test -n "$GLOBUS_NOTHR_FLAVOR" ; then
     VOMS_NOTHR_LIBS="$VOMS_PATH_LIBS -lvomsc_$GLOBUS_NOTHR_FLAVOR"
     VOMS_CPP_NOTHR_LIBS="$VOMS_PATH_LIBS -lvomsapi_$GLOBUS_NOTHR_FLAVOR"
     VOMS_STATIC_NOTHR_LIBS="$ac_voms_libdir/libvomsc_$GLOBUS_NOTHR_FLAVOR.a"
  else
     VOMS_NOTHR_LIBS=""
     VOMS_CPP_NOTHR_LIBS=""
     VOMS_STATIC_NOTHR_LIBS=""
  fi

  dnl Test the voms C api unless $1 == VOMSCPP
  ifelse([$1],[VOMSCPP],[],[
     AC_LANG_SAVE
     AC_LANG_C
     CFLAGS="$GLOBUS_GSSAPI_GSI_NOTHR_CFLAGS $GLOBUS_GSSAPI_GSI_CFLAGS $VOMS_CFLAGS $CFLAGS"
     LIBS="$VOMS_LIBS $VOMS_THR_LIBS $VOMS_NOTHR_LIBS $LIBS"
     
     AC_TRY_COMPILE([ #include <voms/voms_apic.h> ],
                    [ struct vomsdata *voms_info = VOMS_Init("/tmp", "/tmp") ],
                    [ ac_cv_vomsc_valid=yes ], [ac_cv_vomsc_valid=no ])
     CFLAGS=$ac_save_CFLAGS
     LIBS=$ac_save_LIBS
     AC_LANG_RESTORE
     AC_MSG_RESULT([$ac_cv_vomsc_valid for c api])
  ])

  dnl Test the voms C++ api unless $1 == VOMSC
  ifelse([$1],[VOMSC],[],[
     AC_LANG_SAVE
     AC_LANG_CPLUSPLUS
     CPPFLAGS="$GLOBUS_GSSAPI_GSI_NOTHR_CFLAGS $GLOBUS_GSSAPI_GSI_CFLAGS $VOMS_CFLAGS $CPPFLAGS"
     LIBS="$VOMS_CPP_LIBS $VOMS_CPP_THR_LIBS $VOMS_CPP_NOTHR_LIBS $LIBS"

     AC_TRY_COMPILE([ #include <voms/voms_api.h> ],
                    [ vomsdata vo_data("","") ],
                    [ ac_cv_vomscpp_valid=yes ], [ac_cv_vomscpp_valid=no ])
     CPPFLAGS=$ac_save_CPPFLAGS
     LIBS=$ac_save_LIBS
     AC_LANG_RESTORE
     AC_MSG_RESULT([$ac_cv_vomscpp_valid for cpp api])
  ])

  dnl Only C api ?
  ifelse([$1],[VOMSC],[
     if test "x$ac_cv_vomsc_valid" = "xyes" ; then
  ],[
     dnl Only C++ api ?
     ifelse([$1],[VOMSCPP],[
        if test "x$ac_cv_vomscpp_valid" = "xyes" ; then
     ],[
        dnl Need both
        if test "x$ac_cv_vomsc_valid" = "xyes" -a "x$ac_cv_vomscpp_valid" = "xyes" ; then
     ])
  ])
     [$2]
  else
     VOMS_LIBS=""
     VOMS_THR_LIBS=""
     VOMS_NOTHR_LIBS=""
     VOMS_CPP_LIBS=""
     VOMS_CPP_THR_LIBS=""
     VOMS_CPP_NOTHR_LIBS=""
     VOMS_STATIC_LIBS=""
     VOMS_STATIC_THR_LIBS=""
     VOMS_STATIC_NOTHR_LIBS=""
     [$3]
  fi

  AC_SUBST(VOMS_CFLAGS)
  AC_SUBST(VOMS_LIBS)
  AC_SUBST(VOMS_CPP_LIBS)
  AC_SUBST(VOMS_STATIC_LIBS)
  AC_SUBST(VOMS_THR_LIBS)
  AC_SUBST(VOMS_NOTHR_LIBS)
  AC_SUBST(VOMS_CPP_THR_LIBS)
  AC_SUBST(VOMS_CPP_NOTHR_LIBS)
  AC_SUBST(VOMS_STATIC_THR_LIBS)
  AC_SUBST(VOMS_STATIC_NOTHR_LIBS)
])

