/* See LICENSE for licensing and NOTICE for copyright. */
package org.ldaptive.control;

import java.util.UUID;
import org.ldaptive.asn1.DERBuffer;
import org.ldaptive.asn1.DefaultDERBuffer;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/**
 * Unit test for {@link SyncStateControl}.
 *
 * @author  Middleware Services
 */
public class SyncStateControlTest
{


  /**
   * Sync state control test data.
   *
   * @return  response test data
   */
  @DataProvider(name = "response")
  public Object[][] createData()
  {
    return
      new Object[][] {
        // Add state, no cookie
        new Object[] {
          new DefaultDERBuffer(
            new byte[] {
              0x30, 0x15, 0x0A, 0x01, 0x01, 0x04, 0x10, (byte) 0x84, 0x31, 0x77, (byte) 0xEC, 0x5B, 0x0E, 0x10, 0x31,
              (byte) 0x82, 0x7F, 0x11, 0x6F, (byte) 0xF5, 0x6E, 0x4E, 0x59}),
          new SyncStateControl(
            SyncStateControl.State.ADD,
            UUID.fromString("843177ec-5b0e-1031-827f-116ff56e4e59"),
            null,
            false),
        },
        // Modify state, cookie of length 52
        new Object[] {
          new DefaultDERBuffer(
            new byte[] {
              0x30, 0x4B, 0x0A, 0x01, 0x02, 0x04, 0x10, 0x5D, 0x5D, (byte) 0xA5, (byte) 0xD0, 0x5B, (byte) 0xE2, 0x10,
              0x31, (byte) 0x82, (byte) 0x84, 0x11, 0x6F, (byte) 0xF5, 0x6E, 0x4E, 0x59, 0x04, 0x34, 0x72, 0x69, 0x64,
              0x3D, 0x30, 0x30, 0x30, 0x2C, 0x63, 0x73, 0x6E, 0x3D, 0x32, 0x30, 0x31, 0x32, 0x30, 0x37, 0x30, 0x36,
              0x31, 0x38, 0x31, 0x35, 0x35, 0x32, 0x2E, 0x33, 0x33, 0x37, 0x37, 0x31, 0x38, 0x5A, 0x23, 0x30, 0x30,
              0x30, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30}),
          new SyncStateControl(
            SyncStateControl.State.MODIFY,
            UUID.fromString("5d5da5d0-5be2-1031-8284-116ff56e4e59"),
            new byte[] {
              (byte) 0x72, (byte) 0x69, (byte) 0x64, (byte) 0x3D, (byte) 0x30,
              (byte) 0x30, (byte) 0x30, (byte) 0x2C, (byte) 0x63, (byte) 0x73,
              (byte) 0x6E, (byte) 0x3D, (byte) 0x32, (byte) 0x30, (byte) 0x31,
              (byte) 0x32, (byte) 0x30, (byte) 0x37, (byte) 0x30, (byte) 0x36,
              (byte) 0x31, (byte) 0x38, (byte) 0x31, (byte) 0x35, (byte) 0x35,
              (byte) 0x32, (byte) 0x2E, (byte) 0x33, (byte) 0x33, (byte) 0x37,
              (byte) 0x37, (byte) 0x31, (byte) 0x38, (byte) 0x5A, (byte) 0x23,
              (byte) 0x30, (byte) 0x30, (byte) 0x30, (byte) 0x30, (byte) 0x30,
              (byte) 0x30, (byte) 0x23, (byte) 0x30, (byte) 0x30, (byte) 0x30,
              (byte) 0x23, (byte) 0x30, (byte) 0x30, (byte) 0x30, (byte) 0x30,
              (byte) 0x30, (byte) 0x30,
            },
            false),
        },
        // Add state, cookie length of 52, empty UUID
        new Object[] {
          new DefaultDERBuffer(
            new byte[] {
              0x30, 0x3B, 0x0A, 0x01, 0x01, 0x04, 0x00, 0x04, 0x34, 0x72, 0x69, 0x64, 0x3D, 0x30, 0x30, 0x30, 0x2C,
              0x63, 0x73, 0x6E, 0x3D, 0x32, 0x30, 0x31, 0x33, 0x30, 0x32, 0x31, 0x35, 0x32, 0x31, 0x32, 0x33, 0x32,
              0x30, 0x2E, 0x34, 0x36, 0x34, 0x34, 0x38, 0x35, 0x5A, 0x23, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x23,
              0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30}),
          new SyncStateControl(
            SyncStateControl.State.ADD,
            null,
            new byte[] {
              (byte) 0x72, (byte) 0x69, (byte) 0x64, (byte) 0x3d, (byte) 0x30,
              (byte) 0x30, (byte) 0x30, (byte) 0x2c, (byte) 0x63, (byte) 0x73,
              (byte) 0x6e, (byte) 0x3d, (byte) 0x32, (byte) 0x30, (byte) 0x31,
              (byte) 0x33, (byte) 0x30, (byte) 0x32, (byte) 0x31, (byte) 0x35,
              (byte) 0x32, (byte) 0x31, (byte) 0x32, (byte) 0x33, (byte) 0x32,
              (byte) 0x30, (byte) 0x2e, (byte) 0x34, (byte) 0x36, (byte) 0x34,
              (byte) 0x34, (byte) 0x38, (byte) 0x35, (byte) 0x5a, (byte) 0x23,
              (byte) 0x30, (byte) 0x30, (byte) 0x30, (byte) 0x30, (byte) 0x30,
              (byte) 0x30, (byte) 0x23, (byte) 0x30, (byte) 0x30, (byte) 0x30,
              (byte) 0x23, (byte) 0x30, (byte) 0x30, (byte) 0x30, (byte) 0x30,
              (byte) 0x30, (byte) 0x30,
            },
            false),
        },
      };
  }


  /**
   * @param  berValue  to encode.
   * @param  expected  sync state control to test.
   *
   * @throws  Exception  On test failure.
   */
  @Test(groups = "control", dataProvider = "response")
  public void decode(final DERBuffer berValue, final SyncStateControl expected)
    throws Exception
  {
    final SyncStateControl actual = new SyncStateControl(expected.getCriticality());
    actual.decode(berValue);
    Assert.assertEquals(actual, expected);
  }
}
