/***********************************************************************************

    Copyright (C) 2007-2020 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_CALENDAR_HEADER
#define LIFEOGRAPH_CALENDAR_HEADER


#include <gtkmm/widget.h>

#include "../helpers.hpp"


namespace LIFEO
{

using namespace HELPERS;


class Calendar
{
    public:
        // CONSTANTS
        static constexpr float      s_margin = 10.0;
        static constexpr float      s_border_label = 3.0;
        static constexpr float      s_font_height = 10.0;
        static constexpr float      s_title_bar_height = 28.0;
        static constexpr float      s_day_bar_height = 22.0;
        static constexpr float      COLUMN_WIDTH_MIN= 50.0;
        // CALCULATED CONSTANTS
        static constexpr float      s_grid_start_y = s_margin + s_title_bar_height + s_day_bar_height;

                                    Calendar();
        virtual                     ~Calendar(){ }

        void                        init_icons();

        void                        set_date( date_t );
        void                        set_day_shown( date_t d )
        {
            if( ! Date::is_ordinal( d ) )
            {
                Date::reset_order_3rd_0( d );
                m_day_shown = d;
            }
        }
        void                        set_selected_date( date_t date )
        { m_day_selected = date; set_date( date ); }
        date_t                      get_selected_date() const
        { return m_day_selected; }

        void                        resize( int, int );

        virtual void                update(){ }

    protected:
        void                        update_col_geom( bool = false );

        static void                 calculate_begin_date( date_t& begin_date );

        bool                        draw( const Cairo::RefPtr< Cairo::Context >& );

        Cairo::RefPtr< Cairo::ImageSurface >
                                    m_IS_entry_icon;
        Cairo::RefPtr< Cairo::ImageSurface >
                                    m_IS_entry_icon_plus;
        Cairo::RefPtr< Cairo::Context >
                                    m_IC_entry_icon;
        Cairo::RefPtr< Cairo::Context >
                                    m_IC_entry_icon_plus;

        // GEOMETRY
        int                         m_width{ -1 };
        int                         m_height{ -1 };

        float                       m_x_max{ 0.0f }, m_y_max{ 0.0f };
        float                       m_length{ 0.0f };

        double                      m_col_width{ 0.0 };
        double                      m_row_height{ 0.0 };

        Pango::FontDescription      m_font_base;
        Pango::FontDescription      m_font_bold;
        Pango::FontDescription      m_font_medium;
        Pango::FontDescription      m_font_big;

        // FLAGS
        bool                        m_flag_selection_locked{ false };
        bool                        m_flag_icons_initialized{ false };

        Date                        m_month{ Date::NOT_SET };
        date_t                      m_day_shown{ Date::NOT_SET };
        date_t                      m_day_selected{ Date::NOT_SET };
};

} // end of namespace LIFEO

#endif
