<?php
/*
# Copyright 2006, CRIM, Stephane Bond
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	require_once 'dbFunctions.php';
	
	/**
	*
	* Find computers in a classroom
	* 
	* @package MILLE-CONFIGURATOR
	*/
	class ClassroomFinder {

		/**
		* classroom attribute value of the node
		* @access private
		* @var int
		*/
		var $classroom;
		/**
		* computers of the classroom
		* @access private
		* @var int
		*/
		var $computers;
		/**
		* nodeid
		* @access private
		* @var string
		*/
		var $nodeid;

		/**
		* Last Error
		* @access private
		* @var string
		*/
		var $lastError;
		/**
		* Last Error
		* @access private
		* @var string
		*/
		var $isError;
		

		/**
		* The constructor of a ClassroomFinder
		*
		* Initialised in by :
		* <ul>
		* <li> IP of the computer
		* </ul>
		* 
		* Example of valid initialisation :
		*
		* <code>
		*   $finder=new ClassroomFinder("10.1.0.9");
		* </code>
		*
		* @access public
		*/
		function ClassroomFinder($id) {
			$this->notFound = false;
			$this->nodeid=$id;
			
			$node=new Node($id);
			$this->classroom = $node->getAttribute('CLASSROOM');
			if (empty($this->classroom)) {
				$this->classroom = $node->name;
			}

			// Retrieve computers
			$from ="nodes N INNER JOIN status S ON S.id = N.id";
			$where="N.id_parent=".$this->nodeid;
			$result=$this->getFromDB("S.ip, S.mac, S.code, S.username",$where,$from,true,true);
			$this->computers=$result;
		}
		

		/**
		* Get classroom description
		*
		* @access private
		* @return int
		*/
		function getClassroom() {
			return $this->classroom;
		}
		
		/**
		* Get computers
		*
		* @access private
		* @return int
		*/
		function getComputers() {
			return $this->computers;
		}
		
		/**
		* Return true if not found
		*
		* @access public
		* @return int
		*/
		function notFound() {
			return $this->notFound;
		}
		
		
		/**
		* Get the node ID
		*
		* @access public
		* @return int
		*/
		function getNodeID() {
			return $this->nodeid;
		}
		
		/**
		* Get the subnet string
		*
		* @access public
		* @return int
		*/
		function getSubnet() {
			return $this->subnet;
		}

		/**
		* Return yes if the object exists
		* To be used just after the construction
		*
		* @access public
		* @return float
		*/
		function isError() {
			return $this->isError;
		}

		/**
		* Get the last error
		*
		* @access public
		* @return float
		*/
		function lastError() {
			return $this->lastError;
		}


		
		/**
		* GetFromDB
		*
		* @access private
		* @return array
		*/
		function getFromDB($column,$where,$from,$isFatal=true,$multiple = false) {
			$query='SELECT '.$column.' FROM '.$from.' WHERE '.$where;
			if ($multiple) {
				$result = select($query.";");
			}
			else {
				$result = singleResultSelect($query);
			}
			if (!$result) {	
				$this->lastError = getMessage('not_found').$query; 
				$this->notFound = true; 
				if ($isFatal) 
					$this->isError = true; return NULL; 
			}
			elseif (!is_array($result)) { 
				$this->lastError = getMessage('db_error').$result." : ".$query; 
				if ($isFatal) $this->isError = true; return NULL;
			}
			return $result;
		}
		
	} // class ClassroomFinder
?>
