<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
    /**
    * This class is used to parse LTS files
    *
    * It generage text or <pre>text</pre> output
    * when print method is called.
    */
    class LTSParser {
	var $lts;
	var $isError;

	function LTSParser($node) {
	    if (strtolower(get_class($node)) != "node"){
		$this->isError = true;
		return;
	    }
	    if ($node->isError()) {
		return;
	    }

	   /**
	   *   (PDubois)Patrick Dubois  - July 9th, 2008
	   *   Added the following if condition to make sure
	   *   the node would include hardware group attributes if any.
           *
	   *   Does this node have any matching hardware groups?  
	   *   Yes -> get extended LTS. [ $node->getExtendedLTS() ]
	   *   No  -> get simple LTS.   [ $node->getLTS() ]
	   *
	   **/
	/**	
	    ORIGINAL CODE :
            --
	    $this->lts = $node->getLTS();
	    $this->isError = false;
            --
	**/
           if ( $node->hasHWgroup() ){
		   $this->lts = $node->getExtendedLTS($node->getHWgroupIDs());
	   } // end if 
	   else{
		  $this->lts = $node->getLTS();
	       } // end else
 
	}

	function printView($preOn = true) {
	    if ($this->isError) return;
	    if ($preOn){
		print "<h3>".getMessage('config_attributes_listing')."</h3>";
		print "<pre>\n";
	    }
	    if (is_array($this->lts)) {
		foreach ($this->lts as $name => $value) {
		    print "\t".$name."='".$value."'\n";
		}
	    }

	    if ($preOn) print "</pre>\n";
	}

	function isError(){
	    return $this->isError;
	}
    }
