#include "osl/record/csaRecord.h"
#include "osl/state/numEffectState.h"
#include "osl/oslConfig.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class FastCopierTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE( FastCopierTest );
  CPPUNIT_TEST(testCopy);
  CPPUNIT_TEST(testFile);
  CPPUNIT_TEST_SUITE_END();
public:
  void testCopy();
  void testFile();
};

CPPUNIT_TEST_SUITE_REGISTRATION(FastCopierTest);

using namespace osl;

void FastCopierTest::testCopy()
{
  NumEffectState state, state2;
  CPPUNIT_ASSERT(state.isConsistent());
  CPPUNIT_ASSERT(state2.isConsistent());

  state2.copyFrom(state);

  CPPUNIT_ASSERT(state.isConsistent());
  CPPUNIT_ASSERT(state2.isConsistent());

  state.makeMove(Move(Square(7,7), Square(7,6), PAWN, PTYPE_EMPTY, false, BLACK));

  CPPUNIT_ASSERT(state.isConsistent());
  CPPUNIT_ASSERT(state2.isConsistent());
  
  state2.copyFrom(state);

  CPPUNIT_ASSERT(state.isConsistent());
  CPPUNIT_ASSERT(state2.isConsistent());

}

void FastCopierTest::testFile()
{
  NumEffectState state, state2;
  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  std::string filename;
  size_t count = 0, limit = OslConfig::inUnitTestShort ? 512 : 65536;
  while ((ifs >> filename) && count++ < limit) {
    if (filename == "") 
      break;
    if (count % 128 == 0)
	std::cerr << '.';
    Record record=CsaFile(OslConfig::testCsaFile(filename)).getRecord();
    state = NumEffectState(record.getInitialState());
    vector<Move> moves=record.getMoves();

    for (size_t i=0; i<moves.size(); ++i) {
      CPPUNIT_ASSERT(state.isConsistent());
      CPPUNIT_ASSERT(state2.isConsistent());

      state.makeMove(moves[i]);
      state2.copyFrom(state);

      CPPUNIT_ASSERT(state.isConsistent());
      CPPUNIT_ASSERT(state2.isConsistent());
      CPPUNIT_ASSERT_EQUAL(state, state2);
      CPPUNIT_ASSERT_EQUAL(state.changedEffects(BLACK), state2.changedEffects(BLACK));
      CPPUNIT_ASSERT_EQUAL(state.changedEffects(WHITE), state2.changedEffects(WHITE));
      CPPUNIT_ASSERT_EQUAL(state.changedPieces(), state2.changedPieces());
      CPPUNIT_ASSERT_EQUAL(state.effectedChanged(BLACK), state2.effectedChanged(BLACK));
      CPPUNIT_ASSERT_EQUAL(state.effectedChanged(WHITE), state2.effectedChanged(WHITE));
    }
  }
}
