/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "fakemediarecordercontrol.h"
#include "fakecameraservice.h"

#include <QDebug>
#include <QUrl>

FakeMediaRecorderControl::FakeMediaRecorderControl(FakeCameraService *service, QObject *parent)
    : QMediaRecorderControl(parent),
      m_service(service),
      m_state(QMediaRecorder::StoppedState),
      m_duration(0.0)
{
    m_durationTimer.setInterval(1000);
    QObject::connect(&m_durationTimer, SIGNAL(timeout()), this, SLOT(durationIncrease()));
}

void FakeMediaRecorderControl::applySettings()
{
}

qint64 FakeMediaRecorderControl::duration() const
{
    return m_duration;
}

bool FakeMediaRecorderControl::isMuted() const
{
    return false;
}

QUrl FakeMediaRecorderControl::outputLocation() const
{
    return QUrl("/tmp/movie0001.mpg");
}

bool FakeMediaRecorderControl::setOutputLocation(const QUrl &location)
{
    Q_UNUSED(location);
    return true;
}

QMediaRecorder::State FakeMediaRecorderControl::state() const
{
    return m_state;
}

QMediaRecorder::Status FakeMediaRecorderControl::status() const
{
    return QMediaRecorder::LoadedStatus;
}

qreal FakeMediaRecorderControl::volume() const
{
    return 1.0;
}

void FakeMediaRecorderControl::setMuted(bool muted)
{
    Q_UNUSED(muted);
}

void FakeMediaRecorderControl::setState(QMediaRecorder::State state)
{
    if (m_state == state)
        return;

    m_state = state;
    Q_EMIT stateChanged(m_state);

    if (m_state == QMediaRecorder::StoppedState) {
         m_durationTimer.stop();
        m_duration = 0.0;
        Q_EMIT durationChanged(m_duration);
    } else {
        m_durationTimer.start();
    }
}

void FakeMediaRecorderControl::setVolume(qreal gain)
{
    Q_UNUSED(gain);
}

void FakeMediaRecorderControl::durationIncrease()
{
    m_duration += 1000;
}
