/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FAKECAMERASERVICE_H
#define FAKECAMERASERVICE_H

#include "fakedata.h"
#include <QMediaService>

class QCameraControl;
class FakeCameraControl;
class FakeCameraFlashControl;
class FakeCameraFocusControl;
class FakeCameraZoomControl;
class FakeImageCaptureControl;
class FakeMediaRecorderControl;
class FakeVideoDeviceSelectorControl;
class FakeVideoRendererControl;
class FakeViewfinderSettingsControl;

class FakeCameraService : public QMediaService
{
Q_OBJECT
public:
    FakeCameraService(QObject *parent = 0);
    ~FakeCameraService();

    QMediaControl* requestControl(const char *name);
    void releaseControl(QMediaControl *control);

    FakeCameraControl *cameraControl() const { return m_cameraControl; }
    FakeCameraFlashControl *flashControl() const { return m_flashControl; }
    FakeCameraFocusControl *focusControl() const { return m_focusControl; }
    FakeCameraZoomControl *zoomControl() const { return m_zoomControl; }
    FakeImageCaptureControl *imageCaptureControl() const { return m_imageCaptureControl; }
    FakeMediaRecorderControl *recorderControl() const { return m_recorderControl; }
    FakeVideoDeviceSelectorControl *deviceSelector() const { return m_deviceSelectControl; }
    FakeVideoRendererControl *videoOutputControl() const { return m_videoOutput; }
    FakeViewfinderSettingsControl *viewfinderControl() const { return m_viewfinderControl; }
    FakeData& fakeSensor() { return m_sensor; }

private:
    FakeCameraControl *m_cameraControl;
    FakeCameraFlashControl *m_flashControl;
    FakeCameraFocusControl *m_focusControl;
    FakeCameraZoomControl *m_zoomControl;
    FakeImageCaptureControl *m_imageCaptureControl;
    FakeMediaRecorderControl *m_recorderControl;
    FakeVideoDeviceSelectorControl *m_deviceSelectControl;
    FakeVideoRendererControl *m_videoOutput;
    FakeViewfinderSettingsControl *m_viewfinderControl;
    FakeData m_sensor;
};

#endif
