from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


app_log = _Mock()

default_handlers = _Mock()

filefind = _Mock()

functools = _Mock()

is_hidden = _Mock()

json = _Mock()

json_errors = _Mock()

logging = _Mock()

non_alphanum = _Mock()

os = _Mock()

re = _Mock()

responses = _Mock()

string_types = _Mock()

sys = _Mock()

traceback = _Mock()

web = _Mock()

notebook_name_regex = '(?P<name>[^/]+\\.ipynb)'

notebook_path_regex = '(?P<path>(?:/.*)*)/(?P<name>[^/]+\\.ipynb)'

path_regex = '(?P<path>(?:/.*)*)'

class Application(_Mock):
  pass


class AuthenticatedFileHandler(_Mock):
  pass
  CACHE_MAX_AGE = 315360000

class AuthenticatedHandler(_Mock):
  pass


class FileFindHandler(_Mock):
  pass
  CACHE_MAX_AGE = 315360000

class HTTPError(_Mock):
  pass


class IPythonHandler(_Mock):
  pass


class Template404(_Mock):
  pass


class TemplateNotFound(_Mock):
  pass


class TrailingSlashHandler(_Mock):
  pass


