<!--
  Stylesheet to convert Twitter user timelines to RSS.

  Copyright (C) 2013  Antonio Ospite <ospite@studenti.unina.it>

  This file is part of tweeper.

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:php="http://php.net/xsl"
    xsl:extension-element-prefixes="php">

    <xsl:param name="generateEnclosure"/>

    <xsl:output method="xml" indent="yes"/>

    <xsl:variable name="twitterBaseURL">
        <xsl:text>https://twitter.com</xsl:text>
    </xsl:variable>

    <xsl:template match="a[@data-expanded-url]">
        <xsl:value-of disable-output-escaping="yes" select="php:function('Tweeper::generate_enclosure', string(./@data-expanded-url))"/>
    </xsl:template>

    <xsl:variable name="screen-name" select="//div[@class='profile-card-inner']/@data-screen-name"/>

    <xsl:template match="//div[@id='timeline']//ol[@id='stream-items-id']//li[@data-item-type='tweet']">
        <xsl:variable name="user-name" select=".//span[@class='username js-action-profile-name']/b"/>
        <xsl:variable name="tweet-text" select=".//p[@class='js-tweet-text tweet-text']"/>
        <item>
            <title>
                <xsl:value-of select="concat($user-name, ': ', $tweet-text)"/>
            </title>
            <link>
                <xsl:value-of select="concat($twitterBaseURL, .//a[@class='details with-icn js-details']/@href)"/>
            </link>
            <pubDate>
                <xsl:value-of select="php:functionString('Tweeper::epoch_to_gmdate', .//small[@class='time']//span/@data-time)"/>
            </pubDate>
            <description>
                <xsl:value-of select="concat($user-name, ': ')"/>
                <xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
                <xsl:copy-of select="$tweet-text/node()"/>
                <xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
            </description>
            <xsl:if test="$generateEnclosure = 1">
                <xsl:apply-templates select="$tweet-text//a[@data-expanded-url]"/>
            </xsl:if>
        </item>
    </xsl:template>

    <xsl:template match="/">

        <rss version="2.0">
            <channel>
                <generator>Tweeper</generator>
                <title>
                    <xsl:text>Twitter / </xsl:text><xsl:value-of select="$screen-name"/>
                </title>
                <link>
                    <xsl:value-of select="//link[@rel='canonical']/@href"/>
                </link>
                <description>
                    <xsl:value-of select="//meta[@name='description']/@content"/>
                </description>
                <image>
                    <url>
                        <xsl:value-of select="//a[@class='profile-picture media-thumbnail']/@href"/>
                    </url>
                </image>
                <xsl:apply-templates select="//div[@id='timeline']//ol[@id='stream-items-id']//li[@data-item-type='tweet']"/>
            </channel>
        </rss>
    </xsl:template>
</xsl:stylesheet>
