/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "global-manager-plugin.h"

PluginInterface *GlobalManagerPlugin::m_Instance = nullptr;
GlobalManager *GlobalManagerPlugin::m_pManager = nullptr;

GlobalManagerPlugin::~GlobalManagerPlugin()
{
    if (m_pManager != nullptr) {
        delete m_pManager;
        m_pManager = nullptr;
    }
}

GlobalManagerPlugin::GlobalManagerPlugin()
{
    if (m_pManager == nullptr) {
        m_pManager = GlobalManager::GlobalManagerNew();
    }
}

PluginInterface *GlobalManagerPlugin::getInstance()
{
    if (nullptr == m_Instance) {
        m_Instance = new GlobalManagerPlugin();
    }
    return m_Instance;
}

void GlobalManagerPlugin::activate()
{
    m_pManager->start();
}

void GlobalManagerPlugin::deactivate()
{
    m_pManager->stop();
}

PluginInterface *createSettingsPlugin()
{
    return GlobalManagerPlugin::getInstance();
}
